/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.importexport;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ideimpl.importexport.HookHandler;
import oracle.ideimpl.importexport.ImportExportAdapter;
import oracle.ideimpl.importexport.ImportExportDefinitions;
import oracle.ideimpl.importexport.res.ExtensionBundle;
import oracle.ideri.importexport.ExportInvoker;
import oracle.ideri.importexport.ImportExportInvoker;
import oracle.ideri.importexport.ImportExportWizard;
import oracle.ideri.importexport.ImportInvoker;
import oracle.javatools.dialogs.ExceptionDialog;

public class ImportExportManager {
    private static final ImportExportManager _instance = new ImportExportManager();
    private List<ImportInvoker> _importWizards = new ArrayList<ImportInvoker>(10);
    private List<ExportInvoker> _exportWizards = new ArrayList<ExportInvoker>(10);
    private static final String IMPORT = "import";
    private static final String EXPORT = "export";

    private ImportExportManager() {
    }

    public static ImportExportManager getManager() {
        return _instance;
    }

    @Deprecated
    public void registerImportWizard(Class clazz, String[] params) {
        MetaClass metaClass = new MetaClass(clazz.getClassLoader(), clazz.getName());
        ImportInvoker importInvoker = new ImportInvoker(new ImportExportAdapter(metaClass));
        this.registerWizard(importInvoker, params, this._importWizards);
    }

    @Deprecated
    public void registerImportWizard(ClassLoader classLoader, String className, String[] params) {
        MetaClass metaClass = new MetaClass(classLoader, className);
        ImportInvoker importInvoker = new ImportInvoker(new ImportExportAdapter(metaClass));
        this.registerWizard(importInvoker, params, this._importWizards);
    }

    public void invokeImportWizard(Component parent, Context context) {
        this.invokeWizard(parent, context, IMPORT, ExtensionBundle.get("IMPORT_DIALOG_TITLE"), ExtensionBundle.get("IMPORT_DIALOG_LABEL"), "f1_idedimport_html");
    }

    @Deprecated
    public void registerExportWizard(Class clazz, String[] params) {
        MetaClass metaClass = new MetaClass(clazz.getClassLoader(), clazz.getName());
        ExportInvoker exportInvoker = new ExportInvoker(new ImportExportAdapter(metaClass));
        this.registerWizard(exportInvoker, params, this._exportWizards);
    }

    @Deprecated
    public void registerExportWizard(ClassLoader classLoader, String className, String[] params) {
        MetaClass metaClass = new MetaClass(classLoader, className);
        ExportInvoker exportInvoker = new ExportInvoker(new ImportExportAdapter(metaClass));
        this.registerWizard(exportInvoker, params, this._exportWizards);
    }

    public void invokeExportWizard(Component parent, Context context) {
        this.invokeWizard(parent, context, EXPORT, ExtensionBundle.get("EXPORT_DIALOG_TITLE"), ExtensionBundle.get("EXPORT_DIALOG_LABEL"), "f1_idedexport_html");
    }

    private void registerWizard(ImportExportInvoker invoker, String[] params, List invokers) {
        invoker.setParams(params);
        invokers.add(invoker);
    }

    private void invokeWizard(Component parent, Context context, String wizardType, String title, String label, String helpTag) {
        List<ImportExportInvoker> adapterList = this.createFullList(wizardType);
        try {
            ImportExportWizard wizard = new ImportExportWizard(parent, context, adapterList, title, label, helpTag);
            wizard.runDialog(context);
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Component)parent, (Throwable)e);
        }
    }

    private List<ImportExportInvoker> createFullList(String wizardType) {
        ArrayList<ImportExportInvoker> fullList = new ArrayList<ImportExportInvoker>(20);
        if (wizardType == IMPORT) {
            fullList.addAll(this._importWizards);
        } else {
            fullList.addAll(this._exportWizards);
        }
        ImportExportDefinitions defs = HookHandler.getImportExportDefinitions();
        if (wizardType == IMPORT) {
            List<ImportExportAdapter> hookWizards = defs.getImportDefinitions();
            for (ImportExportAdapter adapter : hookWizards) {
                fullList.add(new ImportInvoker(adapter));
            }
        } else {
            List<ImportExportAdapter> hookWizards = defs.getExportDefinitions();
            for (ImportExportAdapter adapter : hookWizards) {
                fullList.add(new ExportInvoker(adapter));
            }
        }
        return fullList;
    }
}

