/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.i18n.servlet.GeneralHelper;
import oracle.i18n.servlet.localesource.ApplicationDefault;
import oracle.i18n.servlet.localesource.HttpAcceptLanguage;
import oracle.i18n.servlet.localesource.LocaleSource;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.LocaleMapper;
import oracle.i18n.util.OraLocaleInfo;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ApplicationContext {
    public static final String OBJECT_KEY = "oracle.i18n.servlet.ApplicationContext.contextkey";
    public static final String DEFAULT_GDKAPP = "/WEB-INF/gdkapp.xml";
    private static final String M_C_GDKAPP_XSD = "gdkapp.xsd";
    private static final String M_C_LOCALE_CHARSETS = "locale-charset-maps";
    private static final String M_C_PAGE_CHARSET = "page-charset";
    private static final String M_C_APPLICATION_LOCALE = "application-locales";
    private static final String M_C_LOCALE_DETERMINATION_RULE = "locale-determine-rule";
    private static final String M_C_REWRITE_RULE = "url-rewrite-rule";
    private static final String M_C_LOCALE_PARAMETER_NAME = "locale-parameter-name";
    private static final String M_C_USER_AGENT = "user-agent";
    private static final String M_C_PATTERN = "pattern";
    private static final String M_C_RESULT = "result";
    private static final String M_C_YES = "yes";
    private static final String M_C_MESSAGE_BUNDLES = "message-bundles";
    private static final String M_C_RESOURCE_BUNDLE = "resource-bundle";
    private static final String M_C_NAME = "name";
    private static final String M_C_FALLBACK = "fallback";
    private static final String M_C_DB_LOCALE_SOURCE = "db-locale-source";
    static final String DEFAULT = "default";
    private static final String M_C_UTF_8 = "UTF-8";
    private static final String[] M_C_ZERO_STRING_ARRAY = new String[0];
    private static final TimeZone[] M_C_ZERO_TIMEZONE_ARRAY = new TimeZone[0];
    private static final Pattern M_C_REWRITE_PATTERN;
    private static final Object[] M_C_REWRITE_RESULT;
    private static final Pattern M_C_PARAMETER_NAME_PATTERN;
    private static final Pattern M_C_LOCALE_NAME_PATTERN;
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final Map m_paramStrToParameter;
    private int m_hashValue;
    private final ClassLoader m_cloader;
    private final LocaleSource m_appDefaultLocSrc;
    private String m_pageCharset = "UTF-8";
    private boolean m_pageCharsetForceSet = true;
    private Map m_localeCharsetMap = new HashMap();
    private Locale m_applicationDefaultLocale = new Locale("en", "US");
    private Locale[] m_applicationLocales = OraLocaleInfo.getCommonLocales();
    private Set m_applicationLocaleSet = new HashSet();
    private List m_localeDeterminationRuleList = new ArrayList(2);
    private List m_localeDeterminationRuleMethodList = new ArrayList(2);
    private Map m_messageBundleMap = new HashMap();
    private Map m_rewriteRuleMap = new HashMap();
    private final Object[] m_rewriteRule = new Object[]{M_C_REWRITE_PATTERN, M_C_REWRITE_RESULT, new Boolean(false)};
    private Map m_parameterNames = new HashMap(LocaleSource.Parameter.size());
    private String[] m_applicationOraLanguages = M_C_ZERO_STRING_ARRAY;
    private String[] m_applicationOraTerritories = M_C_ZERO_STRING_ARRAY;
    private Map m_applicationOraLanguagesForTerritory = new HashMap();
    private Map m_applicationOraTerritoriesForLanguage = new HashMap();
    private String[] m_applicationIANACharacterSets = M_C_ZERO_STRING_ARRAY;

    public ApplicationContext() throws ClassNotFoundException, PatternSyntaxException, UnsupportedEncodingException {
        this((String)null);
    }

    public ApplicationContext(String string, Map map, Locale locale, Locale[] localeArray, Class[] classArray, Map map2, Map map3, Map map4, ClassLoader classLoader) throws PatternSyntaxException, UnsupportedEncodingException {
        this.m_cloader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
        this.m_appDefaultLocSrc = ApplicationDefault.getInstance();
        this.initPresetValues();
        this.initPostsetValues(string, map, locale, localeArray, classArray, map2, map3, map4);
    }

    public ApplicationContext(String string) throws ClassNotFoundException, PatternSyntaxException, UnsupportedEncodingException {
        this(string, null);
    }

    public ApplicationContext(InputStream inputStream) throws ClassNotFoundException, PatternSyntaxException, UnsupportedEncodingException {
        this(inputStream, null);
    }

    public ApplicationContext(String string, ClassLoader classLoader) throws ClassNotFoundException, PatternSyntaxException, UnsupportedEncodingException {
        this.m_cloader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        this.m_appDefaultLocSrc = ApplicationDefault.getInstance();
        this.initPresetValues();
        if (string != null) {
            this.parseStoreOgsApp(string);
        }
        this.initPostsetValues(null, null, null, null, null, null, null, null);
    }

    public ApplicationContext(InputStream inputStream, ClassLoader classLoader) throws ClassNotFoundException, PatternSyntaxException, UnsupportedEncodingException {
        this.m_cloader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        this.m_appDefaultLocSrc = ApplicationDefault.getInstance();
        this.initPresetValues();
        if (inputStream != null) {
            this.parseStoreOgsApp(inputStream);
        }
        this.initPostsetValues(null, null, null, null, null, null, null, null);
    }

    public String getIANAPageCharacterSet() {
        return this.m_pageCharset;
    }

    public String getIANAPageCharacterSet(Locale locale, String string) {
        if (!this.m_pageCharset.equals("AUTO-CHARSET")) {
            return this.m_pageCharset;
        }
        Locale locale2 = this.fallbackLocale(locale);
        if (string == null) {
            return LocaleMapper.getIANACharSetFromLocale(6, locale2)[0];
        }
        List list = (List)this.m_localeCharsetMap.get(locale2);
        if (list == null) {
            Object object = null;
            if (!locale2.getVariant().equals("")) {
                object = new Locale(locale2.getLanguage(), locale2.getCountry());
                list = (List)this.m_localeCharsetMap.get(object);
            }
            if (list == null) {
                object = new Locale(locale2.getLanguage(), "");
                list = (List)this.m_localeCharsetMap.get(object);
            }
        }
        if (list == null) {
            return LocaleMapper.getIANACharSetFromLocale(6, locale2)[0];
        }
        for (Object[] objectArray : list) {
            if (!((Pattern)objectArray[0]).matcher(string).find()) continue;
            return (String)objectArray[1];
        }
        return LocaleMapper.getIANACharSetFromLocale(7, locale2)[0];
    }

    public String getParameterName(LocaleSource.Parameter parameter) {
        return (String)this.m_parameterNames.get(parameter);
    }

    public Class[] getLocaleSources() {
        Class[] classArray = new Class[this.m_localeDeterminationRuleList.size()];
        int n = this.m_localeDeterminationRuleList.size();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = (Object[])this.m_localeDeterminationRuleList.get(i);
            classArray[i] = (Class)objectArray[0];
        }
        return classArray;
    }

    public List getLocaleSourceList() {
        return this.m_localeDeterminationRuleList;
    }

    public List getLocaleSourceGetInstanceList() {
        return this.m_localeDeterminationRuleMethodList;
    }

    public LocaleSource getApplicationDefaultLocaleSource() {
        return this.m_appDefaultLocSrc;
    }

    public Map getMessageBundle() {
        return this.m_messageBundleMap;
    }

    public Locale[] getSupportedLocales() {
        return this.m_applicationLocales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSupportedOraLanguages(String string) {
        if (string == null) {
            return this.getSupportedOraLanguages();
        }
        String string2 = string.toUpperCase(Locale.US);
        String[] stringArray = (String[])this.m_applicationOraLanguagesForTerritory.get(string2);
        if (stringArray != null) {
            return stringArray;
        }
        Map map = this.m_applicationOraLanguagesForTerritory;
        synchronized (map) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.m_applicationLocales.length; ++i) {
                String string3 = LocaleMapper.getOraLanguage(this.m_applicationLocales[i]);
                String string4 = LocaleMapper.getOraTerritory(this.m_applicationLocales[i]);
                if (string3 == null || !string2.equals(string4) || arrayList.contains(string3)) continue;
                arrayList.add(string3);
            }
            stringArray = arrayList.toArray(new String[0]);
            this.m_applicationOraLanguagesForTerritory.put(string2, stringArray);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSupportedOraLanguages() {
        if (this.m_applicationOraLanguages.length > 0) {
            return this.m_applicationOraLanguages;
        }
        String[] stringArray = this.m_applicationOraLanguages;
        synchronized (this.m_applicationOraLanguages) {
            if (this.m_applicationOraLanguages.length == 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < this.m_applicationLocales.length; ++i) {
                    String string = LocaleMapper.getOraLanguage(this.m_applicationLocales[i]);
                    if (string == null || arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
                this.m_applicationOraLanguages = arrayList.toArray(new String[0]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_applicationOraLanguages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSupportedOraTerritories(String string) {
        if (string == null) {
            return this.getSupportedOraTerritories();
        }
        String string2 = string.toUpperCase(Locale.US);
        String[] stringArray = (String[])this.m_applicationOraTerritoriesForLanguage.get(string2);
        if (stringArray != null) {
            return stringArray;
        }
        Map map = this.m_applicationOraTerritoriesForLanguage;
        synchronized (map) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.m_applicationLocales.length; ++i) {
                String string3 = LocaleMapper.getOraTerritory(this.m_applicationLocales[i]);
                String string4 = LocaleMapper.getOraLanguage(this.m_applicationLocales[i]);
                if (string3 == null || !string2.equals(string4) || arrayList.contains(string3)) continue;
                arrayList.add(string3);
            }
            stringArray = arrayList.toArray(new String[0]);
            this.m_applicationOraTerritoriesForLanguage.put(string2, stringArray);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSupportedOraTerritories() {
        if (this.m_applicationOraTerritories.length > 0) {
            return this.m_applicationOraTerritories;
        }
        String[] stringArray = this.m_applicationOraTerritories;
        synchronized (this.m_applicationOraTerritories) {
            if (this.m_applicationOraTerritories.length == 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < this.m_applicationLocales.length; ++i) {
                    String string = LocaleMapper.getOraTerritory(this.m_applicationLocales[i]);
                    if (string == null || arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
                this.m_applicationOraTerritories = arrayList.toArray(new String[0]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_applicationOraTerritories;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSupportedIANACharacterSets() {
        if (this.m_applicationIANACharacterSets.length > 0) {
            return this.m_applicationIANACharacterSets;
        }
        String[] stringArray = this.m_applicationIANACharacterSets;
        synchronized (this.m_applicationIANACharacterSets) {
            if (this.m_applicationIANACharacterSets.length == 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < this.m_applicationLocales.length; ++i) {
                    String[] stringArray2 = LocaleMapper.getIANACharSetFromLocale(7, this.m_applicationLocales[i]);
                    for (int j = 0; j < stringArray2.length; ++j) {
                        if (arrayList.contains(stringArray2[j])) continue;
                        arrayList.add(stringArray2[j]);
                    }
                    String[] stringArray3 = LocaleMapper.getIANACharSetFromLocale(6, this.m_applicationLocales[i]);
                    for (int j = 0; j < stringArray3.length; ++j) {
                        if (arrayList.contains(stringArray3[j])) continue;
                        arrayList.add(stringArray3[j]);
                    }
                }
                this.m_applicationIANACharacterSets = arrayList.toArray(new String[0]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_applicationIANACharacterSets;
        }
    }

    public ClassLoader getClassLoader() {
        return this.m_cloader;
    }

    public Locale fallbackLocale(Locale locale) {
        if (locale == null) {
            return this.m_applicationDefaultLocale;
        }
        if (this.m_applicationLocaleSet.contains(locale)) {
            return locale;
        }
        Locale locale2 = null;
        if (!locale.getVariant().equals("") && this.m_applicationLocaleSet.contains(locale2 = new Locale(locale.getLanguage(), locale.getCountry()))) {
            return locale2;
        }
        locale2 = new Locale(locale.getLanguage(), "");
        return this.m_applicationLocaleSet.contains(locale2) ? locale2 : this.m_applicationDefaultLocale;
    }

    public boolean isIANAPageCharacterSetForcedSet() {
        return this.m_pageCharsetForceSet;
    }

    public Class getLocaleSource(String string) {
        int n = this.m_localeDeterminationRuleList.size();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = (Object[])this.m_localeDeterminationRuleList.get(i);
            Class clazz = (Class)objectArray[0];
            if (!clazz.getName().equals(string)) continue;
            return clazz;
        }
        return ApplicationDefault.class;
    }

    public int hashCode() {
        return this.m_hashValue;
    }

    Object[] getRewritingRule(String string) {
        return (Object[])this.m_rewriteRuleMap.get(string);
    }

    Object[] getRewritingRule() {
        return this.getRewritingRule(DEFAULT);
    }

    static RewriteURLVariable[] parseOutputPatternRewriteURL(String string) {
        ArrayList<RewriteURLVariable> arrayList = new ArrayList<RewriteURLVariable>();
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '$' && i + 1 < cArray.length) {
                RewriteURLVariable rewriteURLVariable;
                if ((rewriteURLVariable = RewriteURLVariable.getInstance(cArray[++i])) != null) {
                    if (stringBuffer.length() > 0) {
                        arrayList.add(RewriteURLVariable.getInstance(stringBuffer.toString()));
                        stringBuffer = new StringBuffer();
                    }
                    arrayList.add(rewriteURLVariable);
                    continue;
                }
                stringBuffer.append('$');
                stringBuffer.append(cArray[i]);
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(RewriteURLVariable.getInstance(stringBuffer.toString()));
        }
        return arrayList.toArray(new RewriteURLVariable[0]);
    }

    private void initPresetValues() {
        LocaleSource.resetParameterVariables(this.m_parameterNames);
        this.m_localeDeterminationRuleList.add(new Object[]{HttpAcceptLanguage.class, Collections.EMPTY_MAP});
        try {
            this.m_localeDeterminationRuleMethodList.add(HttpAcceptLanguage.class.getMethod("getInstance", GeneralHelper.ARG_HTTP_SERVLET_REQUEST_CLASS));
            this.m_localeDeterminationRuleMethodList = Collections.unmodifiableList(this.m_localeDeterminationRuleMethodList);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        this.m_rewriteRuleMap.put(DEFAULT, this.m_rewriteRule);
    }

    private void initPostsetValues(String string, Map map, Locale locale, Locale[] localeArray, Class[] classArray, Map map2, Map map3, Map map4) throws PatternSyntaxException, UnsupportedEncodingException {
        int n;
        Object[] objectArray;
        Object object32;
        if (string != null) {
            this.m_pageCharset = GeneralHelper.getIANACharacterSetFromCs(string);
        }
        if (map != null) {
            for (Object object2 : map.keySet()) {
                if (!(object2 instanceof Locale)) {
                    object32 = GDKMessage.getMessage(5207, (Object)Locale.class.getName());
                    throw new IllegalArgumentException((String)object32);
                }
                object32 = map.get(object2);
                if (!(object32 instanceof List)) {
                    throw new IllegalArgumentException(GDKMessage.getMessage(5208, (Object)List.class.getName()));
                }
                objectArray = (List)object32;
                for (Object[] objectArray2 : objectArray) {
                    if (!(objectArray2[0] instanceof Pattern)) {
                        throw new IllegalArgumentException(GDKMessage.getMessage(5209));
                    }
                    if (!(objectArray2[1] instanceof String)) {
                        throw new IllegalArgumentException(GDKMessage.getMessage(5210));
                    }
                    objectArray2[1] = GeneralHelper.getIANACharacterSetFromCs((String)objectArray2[1]);
                }
            }
            this.m_localeCharsetMap = map;
        }
        if (locale != null) {
            this.m_applicationDefaultLocale = locale;
        }
        if (localeArray != null) {
            this.m_applicationLocales = localeArray;
        }
        for (n = 0; n < this.m_applicationLocales.length; ++n) {
            this.m_applicationLocaleSet.add(this.m_applicationLocales[n]);
        }
        if (!this.m_applicationLocaleSet.contains(this.m_applicationDefaultLocale)) {
            throw new IllegalArgumentException(GDKMessage.getMessage(5211));
        }
        if (classArray != null) {
            this.m_localeDeterminationRuleList = new ArrayList();
            this.m_localeDeterminationRuleMethodList = new ArrayList();
            for (n = 0; n < classArray.length; ++n) {
                Object object2;
                object2 = classArray[n];
                try {
                    object32 = ((Class)object2).getMethod("getInstance", GeneralHelper.ARG_HTTP_SERVLET_REQUEST_CLASS);
                    this.m_localeDeterminationRuleMethodList.add(object32);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException(noSuchMethodException.getMessage());
                }
                this.m_localeDeterminationRuleList.add(new Object[]{object2, Collections.EMPTY_MAP});
            }
            this.m_localeDeterminationRuleMethodList = Collections.unmodifiableList(this.m_localeDeterminationRuleMethodList);
            this.m_localeDeterminationRuleList = Collections.unmodifiableList(this.m_localeDeterminationRuleList);
        }
        if (map4 != null) {
            for (Object object2 : map4.keySet()) {
                if (!(object2 instanceof String)) {
                    object32 = GDKMessage.getMessage(5222, (Object)String.class.getName());
                    throw new IllegalArgumentException((String)object32);
                }
                object32 = map4.get(object2);
                if (object32 instanceof String) continue;
                objectArray = GDKMessage.getMessage(5223, (Object)Class.class.getName());
                throw new IllegalArgumentException((String)objectArray);
            }
            this.m_messageBundleMap = map4;
        }
        if (map2 != null) {
            for (Object object2 : map2.keySet()) {
                object32 = map2.get(object2);
                if (object2 == null) {
                    object2 = DEFAULT;
                }
                if (!object32.getClass().isArray()) {
                    throw new IllegalArgumentException(GDKMessage.getMessage(5212));
                }
                objectArray = (Object[])object32;
                if (objectArray.length != 3) {
                    throw new IllegalArgumentException(GDKMessage.getMessage(5212));
                }
                Object[] objectArray3 = new Object[]{Pattern.compile((String)objectArray[0]), ApplicationContext.parseOutputPatternRewriteURL((String)objectArray[1]), Boolean.valueOf((String)objectArray[2])};
                this.m_rewriteRuleMap.put(object2, objectArray3);
            }
            boolean bl = false;
            for (Object object32 : this.m_rewriteRuleMap.keySet()) {
                if (!DEFAULT.equals(object32)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IllegalArgumentException(GDKMessage.getMessage(5212));
            }
        }
        if (map3 != null) {
            for (Object object2 : map3.keySet()) {
                if (!(object2 instanceof LocaleSource.Parameter)) {
                    throw new IllegalArgumentException(GDKMessage.getMessage(5213, (Object)LocaleSource.Parameter.class.getName()));
                }
                object32 = map3.get(object2);
                if (!(object32 instanceof String)) {
                    throw new IllegalArgumentException(GDKMessage.getMessage(5214, (Object)String.class.getName()));
                }
                if (!M_C_PARAMETER_NAME_PATTERN.matcher((String)object32).find()) {
                    throw new IllegalArgumentException(GDKMessage.getMessage(5215));
                }
                this.m_parameterNames.put(object2, object32);
            }
        }
        this.m_appDefaultLocSrc.setLocale(this.m_applicationDefaultLocale);
        int n2 = 37;
        n2 = n2 * 37 + this.m_cloader.hashCode();
        n2 = n2 * 37 + this.m_appDefaultLocSrc.hashCode();
        n2 = n2 * 37 + this.m_pageCharset.hashCode();
        n2 = n2 * 37 + (this.m_pageCharsetForceSet ? 1 : 0);
        n2 = n2 * 37 + this.m_applicationDefaultLocale.hashCode();
        n2 = n2 * 37 + this.m_applicationLocaleSet.hashCode();
        n2 = n2 * 37 + this.m_localeDeterminationRuleList.hashCode();
        n2 = n2 * 37 + this.m_messageBundleMap.hashCode();
        this.m_hashValue = n2 = n2 * 37 + this.m_parameterNames.hashCode();
    }

    private void parseStoreOgsApp(Object object) throws ClassNotFoundException, PatternSyntaxException, UnsupportedEncodingException {
        Object object2;
        InputStream inputStream = this.getClass().getResourceAsStream(M_C_GDKAPP_XSD);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, inputStream);
        Document document = null;
        try {
            object2 = documentBuilderFactory.newDocumentBuilder();
            document = object instanceof String ? ((DocumentBuilder)object2).parse(new File((String)object)) : ((DocumentBuilder)object2).parse((InputStream)object);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalArgumentException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage());
        }
        object2 = document.getDocumentElement();
        NodeList nodeList = object2.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            Object object3;
            NodeList nodeList2;
            Node node = nodeList.item(i);
            String string = node.getNodeName();
            if (string.equals(M_C_LOCALE_CHARSETS)) {
                nodeList2 = node.getChildNodes();
                int n4 = nodeList2.getLength();
                for (int j = 0; j < n4; ++j) {
                    Object object4;
                    node = nodeList2.item(j);
                    NodeList nodeList3 = node.getChildNodes();
                    object3 = null;
                    String string2 = ".*";
                    String string3 = null;
                    n3 = nodeList3.getLength();
                    for (n2 = 0; n2 < n3; ++n2) {
                        node = nodeList3.item(n2);
                        object4 = node.getNodeName();
                        if (((String)object4).equals("locale")) {
                            object3 = node.getFirstChild().getNodeValue().toLowerCase(Locale.US);
                            continue;
                        }
                        if (((String)object4).equals(M_C_USER_AGENT)) {
                            string2 = node.getFirstChild().getNodeValue();
                            continue;
                        }
                        if (!((String)object4).equals("charset")) continue;
                        string3 = GeneralHelper.getIANACharacterSetFromCs(node.getFirstChild().getNodeValue());
                    }
                    if (object3 == null) continue;
                    Pattern pattern = Pattern.compile(string2);
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object3, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        object4 = OraLocaleInfo.getLocaleFromString(stringTokenizer.nextToken());
                        ArrayList<Object[]> arrayList = (ArrayList<Object[]>)this.m_localeCharsetMap.get(object4);
                        if (arrayList == null) {
                            arrayList = new ArrayList<Object[]>(1);
                            this.m_localeCharsetMap.put(object4, arrayList);
                        }
                        arrayList.add(new Object[]{pattern, string3});
                    }
                }
                continue;
            }
            if (string.equals(M_C_PAGE_CHARSET)) {
                this.m_pageCharset = GeneralHelper.getIANACharacterSetFromCs(node.getChildNodes().item(0).getNodeValue());
                if (!node.hasAttributes() || node.getAttributes().item(0).getNodeValue().equals(M_C_YES)) continue;
                this.m_pageCharsetForceSet = false;
                continue;
            }
            if (string.equals(M_C_APPLICATION_LOCALE)) {
                nodeList2 = node.getChildNodes();
                ArrayList<Locale> arrayList = new ArrayList<Locale>();
                int n5 = nodeList2.getLength();
                for (int j = 0; j < n5; ++j) {
                    node = nodeList2.item(j);
                    if (!node.getNodeName().equals("locale")) continue;
                    object3 = node.getFirstChild().getNodeValue();
                    if (!M_C_LOCALE_NAME_PATTERN.matcher((CharSequence)object3).find()) {
                        throw new IllegalArgumentException(GDKMessage.getMessage(5224, object3));
                    }
                    Locale[] localeArray = OraLocaleInfo.getLocalesFromString((String)object3);
                    if (node.hasAttributes() && node.getAttributes().item(0).getNodeValue().equals(M_C_YES) && localeArray.length == 1) {
                        this.m_applicationDefaultLocale = localeArray[0];
                    }
                    for (int k = 0; k < localeArray.length; ++k) {
                        this.m_applicationLocaleSet.add(localeArray[k]);
                        arrayList.add(localeArray[k]);
                    }
                }
                this.m_applicationLocales = arrayList.toArray(new Locale[0]);
                continue;
            }
            if (string.equals(M_C_LOCALE_DETERMINATION_RULE)) {
                this.m_localeDeterminationRuleList = new ArrayList();
                this.m_localeDeterminationRuleMethodList = new ArrayList();
                nodeList2 = node.getChildNodes();
                int n6 = nodeList2.getLength();
                for (int j = 0; j < n6; ++j) {
                    Class<?> clazz;
                    node = nodeList2.item(j);
                    if (node.getNodeName().equals("locale-source")) {
                        clazz = Class.forName(node.getFirstChild().getNodeValue(), true, this.m_cloader);
                        try {
                            object3 = clazz.getMethod("getInstance", GeneralHelper.ARG_HTTP_SERVLET_REQUEST_CLASS);
                            this.m_localeDeterminationRuleMethodList.add(object3);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            throw new RuntimeException(noSuchMethodException.getMessage());
                        }
                        this.m_localeDeterminationRuleList.add(new Object[]{clazz, Collections.EMPTY_MAP});
                        continue;
                    }
                    if (!M_C_DB_LOCALE_SOURCE.equals(node.getNodeName())) continue;
                    clazz = Class.forName(node.getFirstChild().getNodeValue(), true, this.m_cloader);
                    object3 = node.getAttributes();
                    HashMap<String, String> hashMap = new HashMap<String, String>(object3.getLength());
                    n2 = object3.getLength();
                    for (int k = 0; k < n2; ++k) {
                        Node node2 = object3.item(k);
                        hashMap.put(node2.getNodeName(), node2.getNodeValue());
                    }
                    try {
                        Method method = clazz.getMethod("getInstance", GeneralHelper.ARG_HTTP_SERVLET_REQUEST_CLASS);
                        this.m_localeDeterminationRuleMethodList.add(method);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new RuntimeException(noSuchMethodException.getMessage());
                    }
                    this.m_localeDeterminationRuleList.add(new Object[]{clazz, hashMap});
                }
                this.m_localeDeterminationRuleList = Collections.unmodifiableList(this.m_localeDeterminationRuleList);
                this.m_localeDeterminationRuleMethodList = Collections.unmodifiableList(this.m_localeDeterminationRuleMethodList);
                continue;
            }
            if (string.equals(M_C_LOCALE_PARAMETER_NAME)) {
                nodeList2 = node.getChildNodes();
                String string4 = null;
                int n7 = nodeList2.getLength();
                for (int j = 0; j < n7; ++j) {
                    node = nodeList2.item(j);
                    string4 = node.getNodeName();
                    object3 = (LocaleSource.Parameter)m_paramStrToParameter.get(string4);
                    if (object3 == null) continue;
                    String string5 = node.getFirstChild().getNodeValue();
                    if (!M_C_PARAMETER_NAME_PATTERN.matcher(string5).find()) {
                        throw new IllegalArgumentException(GDKMessage.getMessage(5221, (Object)string5));
                    }
                    this.m_parameterNames.put(object3, string5);
                }
                continue;
            }
            if (string.equals(M_C_REWRITE_RULE)) {
                nodeList2 = node.getChildNodes();
                String string6 = null;
                Boolean bl = null;
                String string7 = null;
                object3 = null;
                Object[] objectArray = new Object[3];
                NamedNodeMap namedNodeMap = node.getAttributes();
                n3 = namedNodeMap.getLength();
                for (n2 = 0; n2 < n3; ++n2) {
                    node = namedNodeMap.item(n2);
                    if (node.getNodeName().equals(M_C_NAME)) {
                        string6 = node.getNodeValue();
                        continue;
                    }
                    if (!node.getNodeName().equals(M_C_FALLBACK)) continue;
                    bl = new Boolean(M_C_YES.equals(node.getNodeValue()));
                }
                if (string6 == null) {
                    string6 = DEFAULT;
                }
                if (bl == null) {
                    bl = new Boolean(false);
                }
                n3 = nodeList2.getLength();
                for (n2 = 0; n2 < n3; ++n2) {
                    node = nodeList2.item(n2);
                    if (node.getNodeName().equals(M_C_PATTERN)) {
                        string7 = node.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (!node.getNodeName().equals(M_C_RESULT)) continue;
                    object3 = node.getFirstChild().getNodeValue();
                }
                objectArray[0] = Pattern.compile(string7);
                objectArray[1] = ApplicationContext.parseOutputPatternRewriteURL((String)object3);
                objectArray[2] = bl;
                this.m_rewriteRuleMap.put(string6, objectArray);
                continue;
            }
            if (!string.equals(M_C_MESSAGE_BUNDLES)) continue;
            this.m_messageBundleMap.clear();
            nodeList2 = node.getChildNodes();
            int n8 = nodeList2.getLength();
            for (int j = 0; j < n8; ++j) {
                node = nodeList2.item(j);
                if (!node.getNodeName().equals(M_C_RESOURCE_BUNDLE)) continue;
                String string8 = null;
                object3 = node.getAttributes();
                int n9 = object3.getLength();
                for (int k = 0; k < n9; ++k) {
                    Node node3 = object3.item(k);
                    if (!node3.getNodeName().equals(M_C_NAME)) continue;
                    string8 = node3.getNodeValue();
                }
                if (string8 == null) {
                    string8 = DEFAULT;
                }
                this.m_messageBundleMap.put(string8, node.getFirstChild().getNodeValue());
            }
        }
    }

    static {
        try {
            M_C_REWRITE_PATTERN = Pattern.compile("(.*)/([^/]+)$");
            M_C_PARAMETER_NAME_PATTERN = Pattern.compile("^[a-z][-a-z0-9]*$");
            M_C_LOCALE_NAME_PATTERN = Pattern.compile("^(([a-zA-Z]+|\\*)([-_]([a-zA-Z]+|\\*)([-_][a-zA-Z0-9]+)?)?|\\*)$");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException(patternSyntaxException.getMessage());
        }
        M_C_REWRITE_RESULT = ApplicationContext.parseOutputPatternRewriteURL("/$L/$1/$2");
        m_paramStrToParameter = new HashMap(LocaleSource.Parameter.size());
        m_paramStrToParameter.put("locale", LocaleSource.Parameter.LOCALE);
        m_paramStrToParameter.put("language", LocaleSource.Parameter.LANGUAGE);
        m_paramStrToParameter.put("territory", LocaleSource.Parameter.TERRITORY);
        m_paramStrToParameter.put("charset", LocaleSource.Parameter.CHARSET);
        m_paramStrToParameter.put("timezone", LocaleSource.Parameter.TIMEZONE);
        m_paramStrToParameter.put("iso-currency", LocaleSource.Parameter.ISO_CURRENCY);
        m_paramStrToParameter.put("linguistic-sort", LocaleSource.Parameter.LINGUISTIC_SORT);
        m_paramStrToParameter.put("date-format", LocaleSource.Parameter.DATE_FORMAT);
        m_paramStrToParameter.put("long-date-format", LocaleSource.Parameter.LONG_DATE_FORMAT);
        m_paramStrToParameter.put("time-format", LocaleSource.Parameter.TIME_FORMAT);
        m_paramStrToParameter.put("date-time-format", LocaleSource.Parameter.DATE_TIME_FORMAT);
        m_paramStrToParameter.put("long-date-time-format", LocaleSource.Parameter.LONG_DATE_TIME_FORMAT);
        m_paramStrToParameter.put("number-format", LocaleSource.Parameter.NUMBER_FORMAT);
        m_paramStrToParameter.put("currency-format", LocaleSource.Parameter.CURRENCY_FORMAT);
        m_paramStrToParameter.put("writing-direction", LocaleSource.Parameter.WRITING_DIRECTION);
        m_paramStrToParameter.put("command", LocaleSource.Parameter.COMMAND);
        m_paramStrToParameter.put("locale-source", LocaleSource.Parameter.LOCALE_SOURCE);
    }

    static abstract class RewriteURLVariable {
        private static final Character M_C_STAR = new Character('*');
        private static final Map m_nameToObj = new HashMap(16);
        public static final RewriteURLVariable LOCALE = new RewriteURLVariable('A'){

            @Override
            public String getResult(Matcher matcher, Locale locale) {
                return locale.toString();
            }
        };
        public static final RewriteURLVariable LANGUAGE = new RewriteURLVariable('L'){

            @Override
            public String getResult(Matcher matcher, Locale locale) {
                return locale.getLanguage();
            }
        };
        public static final RewriteURLVariable COUNTRY = new RewriteURLVariable('C'){

            @Override
            public String getResult(Matcher matcher, Locale locale) {
                return locale.getCountry();
            }
        };
        public static final RewriteURLVariable VARIANT = new RewriteURLVariable('V'){

            @Override
            public String getResult(Matcher matcher, Locale locale) {
                return locale.getVariant();
            }
        };
        public static final RewriteURLVariable ZERO = new RewriteURLVariable('0'){

            @Override
            public String getResult(Matcher matcher, Locale locale) {
                return matcher.group(0);
            }
        };
        public static final RewriteURLVariable ONE = new RewriteURLVariable('1'){

            @Override
            public String getResult(Matcher matcher, Locale locale) {
                return matcher.group(1);
            }
        };
        public static final RewriteURLVariable TWO = new RewriteURLVariable('2'){

            @Override
            public String getResult(Matcher matcher, Locale locale) {
                return matcher.group(2);
            }
        };
        public static final RewriteURLVariable THREE = new RewriteURLVariable('3'){

            @Override
            public String getResult(Matcher matcher, Locale locale) {
                return matcher.group(3);
            }
        };
        public static final RewriteURLVariable FOUR = new RewriteURLVariable('4'){

            @Override
            public String getResult(Matcher matcher, Locale locale) {
                return matcher.group(4);
            }
        };
        public static final RewriteURLVariable FIVE = new RewriteURLVariable('5'){

            @Override
            public String getResult(Matcher matcher, Locale locale) {
                return matcher.group(5);
            }
        };
        public static final RewriteURLVariable SIX = new RewriteURLVariable('6'){

            @Override
            public String getResult(Matcher matcher, Locale locale) {
                return matcher.group(6);
            }
        };
        public static final RewriteURLVariable SEVEN = new RewriteURLVariable('7'){

            @Override
            public String getResult(Matcher matcher, Locale locale) {
                return matcher.group(7);
            }
        };
        public static final RewriteURLVariable EIGHT = new RewriteURLVariable('8'){

            @Override
            public String getResult(Matcher matcher, Locale locale) {
                return matcher.group(8);
            }
        };
        public static final RewriteURLVariable NINE = new RewriteURLVariable('9'){

            @Override
            public String getResult(Matcher matcher, Locale locale) {
                return matcher.group(9);
            }
        };
        public static final RewriteURLVariable DOLLER = new RewriteURLVariable('$'){

            @Override
            public String getResult(Matcher matcher, Locale locale) {
                return "$";
            }
        };
        private final Character m_name;
        private final String m_data;

        public RewriteURLVariable(char c) {
            this.m_name = new Character(c);
            this.m_data = null;
            m_nameToObj.put(this.m_name, this);
        }

        public RewriteURLVariable(String string) {
            this.m_name = M_C_STAR;
            this.m_data = string;
        }

        public final String getData() {
            return this.m_data;
        }

        public abstract String getResult(Matcher var1, Locale var2);

        public static final RewriteURLVariable getInstance(char c) {
            return (RewriteURLVariable)m_nameToObj.get(new Character(c));
        }

        public static final RewriteURLVariable getInstance(String string) {
            return new RewriteURLVariable(string){

                @Override
                public String getResult(Matcher matcher, Locale locale) {
                    return this.getData();
                }
            };
        }
    }
}

