/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.put;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.delete.IDeleteObjectReply;
import oracle.cloudstorage.api.delete.IDeleteOrphansReply;
import oracle.cloudstorage.api.delete.IDeleteRequestBuilder;
import oracle.cloudstorage.api.dlo.DynamicLargeObjectConfig;
import oracle.cloudstorage.api.dlo.InputStreamSegmenter;
import oracle.cloudstorage.api.head.IHeadObjectReply;
import oracle.cloudstorage.api.head.IHeadRequestBuilder;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.header.Map;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.put.IPutContainerReply;
import oracle.cloudstorage.api.put.IPutObjectReply;
import oracle.cloudstorage.api.put.IPutRequestBuilder;
import oracle.cloudstorage.api.put.IPutRequestProcessor;
import oracle.cloudstorage.api.put.PutObjectReply;
import oracle.cloudstorage.api.put.ReadAwareInputStream;
import oracle.cloudstorage.api.request.processor.AbstractRequestProcessor;
import oracle.cloudstorage.api.request.processor.IContent;
import oracle.cloudstorage.api.request.processor.IProcessorFactory;
import oracle.cloudstorage.api.request.processor.ISendable;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.api.stripe.InputStreamStriper;
import oracle.cloudstorage.api.stripe.Md5SegmentInputStreamProcessor;
import oracle.cloudstorage.api.stripe.StripeSegmentConfig;
import oracle.cloudstorage.concurrent.Future;
import oracle.cloudstorage.io.Md5InputStream;
import oracle.cloudstorage.util.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PutRequestProcessor
extends AbstractRequestProcessor<IPutRequestBuilder, IPutRequestProcessor>
implements IPutRequestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PutRequestProcessor.class);

    protected PutRequestProcessor(IProcessorFactory factory) {
        super(factory);
    }

    protected String getContentType(String defaultContentType) {
        if (this.getBuilder() == null) {
            return null;
        }
        String contentType = Header.contentType.get(((IPutRequestBuilder)this.getBuilder()).getSendable().getHeaders());
        if (contentType == null) {
            contentType = defaultContentType.toString();
        }
        return contentType;
    }

    protected StripeSegmentConfig getStripeSegmentConfig() {
        if (this.getBuilder() == null) {
            return null;
        }
        StripeSegmentConfig stripeSegmentConfig = ((IPutRequestBuilder)this.getBuilder()).getStripeSegmentConfig();
        return stripeSegmentConfig;
    }

    protected DynamicLargeObjectConfig getDynamicLargeObjectConfig() {
        if (this.getBuilder() == null) {
            return null;
        }
        DynamicLargeObjectConfig dynamicLargeObjectConfig = ((IPutRequestBuilder)this.getBuilder()).getDynamicLargeObjectConfig();
        return dynamicLargeObjectConfig;
    }

    protected abstract IPutObjectReply atomicObject(IContent var1, IDeleteObjectReply var2) throws RetryException;

    @Override
    public final IPutObjectReply object() throws RetryException, InterruptedException {
        try {
            IPutObjectReply putObjectReply;
            ISendable sendable = ((IPutRequestBuilder)this.getBuilder()).getSendable();
            IContent content = sendable.getContent();
            Future<String> futureMd5 = new Future<String>();
            InputStream inputStream = content.getInputStream();
            inputStream = new Md5InputStream(inputStream, futureMd5);
            content.wrapInputStream(inputStream);
            boolean skipCryptography = ((IPutRequestBuilder)this.getBuilder()).skipCryptography();
            if (!skipCryptography) {
                inputStream = this.getSession().encrypt((IPutRequestBuilder)this.getBuilder(), content.getInputStream());
                content.wrapInputStream(inputStream);
            }
            if ((putObjectReply = this.stripe(content, futureMd5)) == null) {
                putObjectReply = this.segment(content, futureMd5);
            }
            if (putObjectReply == null) {
                putObjectReply = this.atomicObject(content, null);
            }
            return putObjectReply;
        }
        catch (RetryException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private IPutObjectReply segment(IContent content, Future<String> futureMd5) throws RetryException, InterruptedException, ExecutionException, IOException {
        IPutObjectReply putObjectReply;
        DynamicLargeObjectConfig dynamicLargeObjectConfig = this.getDynamicLargeObjectConfig();
        if (dynamicLargeObjectConfig == null) {
            return null;
        }
        String accountId = ((IPutRequestBuilder)this.getBuilder()).getAccountId();
        String containerId = ((IPutRequestBuilder)this.getBuilder()).getContainerId();
        String objectId = ((IPutRequestBuilder)this.getBuilder()).getObjectId();
        String segmentContainerId = dynamicLargeObjectConfig.getSegmentContainer();
        if (segmentContainerId == null) {
            segmentContainerId = containerId;
        } else {
            IPutContainerReply putContainerReply = ((IPutRequestBuilder.Container)((IPutRequestBuilder.Account)this.put().account(((IPutRequestBuilder)this.getBuilder()).getAccountId())).container(segmentContainerId)).send();
            if (!putContainerReply.isSuccessful()) {
                String message = "Could not create Dynamic Large Object segment container " + segmentContainerId;
                Map headers = putContainerReply.getHeaders();
                int statusCode = putContainerReply.getStatus().getStatusCode();
                IReply.Context context = putContainerReply.getContext();
                PutObjectReply reply = new PutObjectReply(headers, statusCode, message, 0L, futureMd5, context);
                return reply;
            }
        }
        String prefix = dynamicLargeObjectConfig.getSegmentPrefix();
        if (prefix == null) {
            prefix = objectId + "/";
        }
        int segmentSize = dynamicLargeObjectConfig.getSegmentSize();
        int segment = 0;
        InputStreamSegmenter segmentedData = null;
        content.prepareForRead();
        Exception t = null;
        try {
            segmentedData = new InputStreamSegmenter(content.getInputStream(), segmentSize);
            for (InputStream segmentData : segmentedData) {
                String segmentId = prefix + String.format("%08d", segment++);
                putObjectReply = ((IPutRequestBuilder.Object)((IPutRequestBuilder.Container)((IPutRequestBuilder.Account)((IPutRequestBuilder.Header)((IPutRequestBuilder.Header)((IPutRequestBuilder.Header)((IPutRequestBuilder.Header)this.put().header(Header.envelopeKey1.provide(null))).header(Header.envelopeKey2.provide(null))).header(Header.digestKey1.provide(null))).header(Header.digestKey2.provide(null))).account(accountId)).container(segmentContainerId)).object(segmentId)).encrypt(false).enableExpect100Continue(((IPutRequestBuilder)this.getBuilder()).isExpect100ContinueEnabled()).data(segmentData).send();
                if (putObjectReply.isSuccessful()) continue;
                IPutObjectReply iPutObjectReply = putObjectReply;
                return iPutObjectReply;
            }
        }
        catch (RetryException e) {
            t = e;
            throw e;
        }
        catch (InterruptedException e) {
            t = e;
            throw e;
        }
        catch (RuntimeException e) {
            t = e;
            throw e;
        }
        finally {
            if (segmentedData != null) {
                try {
                    segmentedData.close();
                }
                catch (Exception e) {
                    if (t == null) {
                        throw new RuntimeException(e);
                    }
                    Throwables.addSuppressed(t, e);
                }
            }
        }
        String manifestValue = segmentContainerId + "/" + prefix;
        String md5 = futureMd5.get();
        IPutObjectReply mainfestReply = ((IPutRequestBuilder.Object)((IPutRequestBuilder.Container)((IPutRequestBuilder.Account)((IPutRequestBuilder.Header)((IPutRequestBuilder.Header)this.put().header(Header.dynamicLargeObjectManifest.provide(manifestValue))).header(Header.dynamicLargeObjectMd5.provide(md5))).account(accountId)).container(containerId)).object(objectId)).encrypt(false).enableExpect100Continue(((IPutRequestBuilder)this.getBuilder()).isExpect100ContinueEnabled()).data((InputStream)null).send();
        putObjectReply = new PutObjectReply(mainfestReply, content);
        return putObjectReply;
    }

    private IPutObjectReply stripe(IContent content, Future<String> futureMd5) throws RetryException, InterruptedException, IOException, ExecutionException, TimeoutException {
        StripeSegmentConfig stripeSegmentConfig = this.getStripeSegmentConfig();
        if (stripeSegmentConfig == null) {
            return null;
        }
        Map builderHeaders = ((IPutRequestBuilder)this.getBuilder()).getSendable().getHeaders();
        Map manifest = new Map(builderHeaders);
        Map segmentHeaders = new Map(builderHeaders);
        builderHeaders.clearHeaders();
        String accountId = ((IPutRequestBuilder)this.getBuilder()).getAccountId();
        String containerId = ((IPutRequestBuilder)this.getBuilder()).getContainerId();
        String objectId = ((IPutRequestBuilder)this.getBuilder()).getObjectId();
        String uuid = StripeSegmentConfig.calculateStripedObjectUuid();
        IHeadObjectReply headObjectReply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)((IHeadRequestBuilder.Account)this.getInternalRequestBuilderRoot().head().account(accountId)).container(containerId)).object(objectId)).send();
        String lock = Header.stripedObjectPutLock.get(headObjectReply);
        if (lock != null && !lock.equals(uuid)) {
            String msg = "Conflicting PUT of striped object to " + this.getObjectUrl() + " in progress with UUID " + lock + ".";
            PutObjectReply putObjectReply = new PutObjectReply(headObjectReply.getHeaders(), Status.CONFLICT.getStatusCode(), msg, -1L, null, headObjectReply.getContext());
            return putObjectReply;
        }
        int count = stripeSegmentConfig.getCount();
        int width = stripeSegmentConfig.getWidth();
        manifest.put(Header.stripedObjectUuid, (Object)uuid);
        manifest.put(Header.stripedObjectPutLock, (Object)uuid);
        manifest.put(Header.stripedSegmentWidth, (Object)width);
        manifest.put(Header.stripedSegmentCount, (Object)count);
        IPutObjectReply reply = ((IPutRequestBuilder.Object)((IPutRequestBuilder.Container)((IPutRequestBuilder.Account)((IPutRequestBuilder.Header)this.put().header(manifest)).account(accountId)).container(containerId)).object(objectId)).enableExpect100Continue(((IPutRequestBuilder)this.getBuilder()).isExpect100ContinueEnabled()).data((InputStream)null).send();
        if (!reply.isSuccessful()) {
            return reply;
        }
        IDeleteOrphansReply deleteOrphansReply = ((IDeleteRequestBuilder.Container)((IDeleteRequestBuilder.Account)this.getInternalRequestBuilderRoot().delete().account(accountId)).container(containerId)).orphans().send();
        if (deleteOrphansReply != null && !deleteOrphansReply.isSuccessful()) {
            String msg = "Conflicting PUT of striped object to " + this.getObjectUrl() + ". Unalbe to delete existing object " + (Object)((Object)deleteOrphansReply.getStatus()) + ".";
            PutObjectReply putObjectReply = new PutObjectReply(deleteOrphansReply.getHeaders(), Status.CONFLICT.getStatusCode(), msg, -1L, null, deleteOrphansReply.getContext());
            return putObjectReply;
        }
        segmentHeaders.put(Header.stripeSegment, (Object)uuid);
        SegmentProcessor[] processors = new SegmentProcessor[stripeSegmentConfig.getCount()];
        for (int segment = 0; segment < count; ++segment) {
            String stripeSegmentSuffix = StripeSegmentConfig.calculateSegmentSuffix(uuid, segment);
            processors[segment] = new SegmentProcessor(stripeSegmentSuffix, segmentHeaders);
        }
        ExecutorService executor = this.getSession().getExecutor();
        content.prepareForRead();
        InputStreamStriper striper = new InputStreamStriper(executor, content.getInputStream(), width, stripeSegmentConfig.getBufferSize(), processors);
        striper.segment();
        for (int segment = 0; segment < count; ++segment) {
            logger.trace("getting stripe segment {} reply", (Object)segment);
            reply = processors[segment].getReply();
            logger.trace("got stripe segment {} reply {}", (Object)segment, (Object)reply);
            if (reply == null || !reply.isSuccessful()) {
                return reply;
            }
            String inMd5 = (String)striper.getResult(segment);
            String eTagMd5 = Header.eTag.get(reply);
            String outMd5 = reply.getMd5(0L, TimeUnit.MILLISECONDS);
            if (inMd5 != null && inMd5.equals(eTagMd5) && inMd5.equals(outMd5)) continue;
            String msg = "Unexpected message digest for " + this.getObjectUrl() + processors[segment].stripeSegmentSuffix + ".  Expected: " + inMd5 + ", sent: " + outMd5 + ", eTag: " + eTagMd5 + ".";
            segmentHeaders.putAll(manifest);
            segmentHeaders.putAll(reply.getHeaders());
            return new PutObjectReply(segmentHeaders, Status.BAD_GATEWAY.getStatusCode(), msg, -1L, new Future<String>(outMd5), reply.getContext());
        }
        striper.throwConcurrentException();
        builderHeaders.clearHeaders();
        String md5 = futureMd5.get(1L, TimeUnit.SECONDS);
        manifest.put(Header.stripedObjectMd5, (Object)md5);
        manifest.remove(Header.stripedObjectPutLock);
        builderHeaders.putAll(manifest);
        reply = this.atomicObject(null, deleteOrphansReply);
        return reply;
    }

    private IPutRequestBuilder.Header put() throws InterruptedException {
        return this.getInternalRequestBuilderRoot().put();
    }

    private class SegmentProcessor
    extends Md5SegmentInputStreamProcessor {
        private final String stripeSegmentSuffix;
        private final Map headers = new Map();
        private volatile Thread thread = null;
        private final Future<IPutObjectReply> futureReply = new Future();

        public SegmentProcessor(String stripeSegmentSuffix, Map headers) {
            this.stripeSegmentSuffix = stripeSegmentSuffix;
            this.headers.putAll(headers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process() throws Exception {
            this.thread = Thread.currentThread();
            InputStream md5InputStream = this.getMd5InputStream();
            String accountId = ((IPutRequestBuilder)PutRequestProcessor.this.getBuilder()).getAccountId();
            String containerId = ((IPutRequestBuilder)PutRequestProcessor.this.getBuilder()).getContainerId();
            String objectId = ((IPutRequestBuilder)PutRequestProcessor.this.getBuilder()).getObjectId() + this.stripeSegmentSuffix;
            ReadAwareInputStream data = new ReadAwareInputStream(md5InputStream);
            try {
                IPutObjectReply reply = ((IPutRequestBuilder.Object)((IPutRequestBuilder.Container)((IPutRequestBuilder.Account)((IPutRequestBuilder.Header)PutRequestProcessor.this.getInternalRequestBuilderRoot().put().header(this.headers)).account(accountId)).container(containerId)).object(objectId)).encrypt(false).enableExpect100Continue(((IPutRequestBuilder)PutRequestProcessor.this.getBuilder()).isExpect100ContinueEnabled()).data(data).send();
                this.futureReply.set(reply);
            }
            catch (Exception e) {
                logger.error("stripe segment {} put exception", (Object)this.stripeSegmentSuffix, (Object)e);
                this.futureReply.set(null);
            }
            finally {
                logger.trace("stripe segment {} put reply: {}", (Object)this.stripeSegmentSuffix, (Object)this.futureReply.getNow());
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            logger.info("stripe segment {}, thread: {}, put cancelled reply: {}", new Object[]{this.stripeSegmentSuffix, this.thread, this.futureReply.getNow()});
            this.futureReply.cancel(true);
        }

        public IPutObjectReply getReply() throws InterruptedException, ExecutionException {
            IPutObjectReply reply = this.futureReply.get();
            return reply;
        }
    }
}

