/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.ProxySelector;
import oracle.dbtools.http.SessionType;
import oracle.dbtools.http.auth.AuthenticationEngine;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;

public abstract class Client {
    private SessionType m_type;
    private CloseableHttpClient m_client;
    private AuthenticationEngine m_engine;

    protected Client(SessionType type) {
        this.m_type = type;
        this.init();
    }

    private void init() {
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(60000).build();
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();
        connMgr.setDefaultSocketConfig(socketConfig);
        connMgr.setDefaultMaxPerRoute(10);
        HttpClientBuilder builder = HttpClients.custom();
        builder.setConnectionManager((HttpClientConnectionManager)connMgr);
        builder.setUserAgent(this.getUserAgent());
        this.initProxy();
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        builder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        this.m_client = builder.build();
    }

    protected void initProxy() {
    }

    protected abstract String getUserAgent();

    public AuthenticationEngine getAuthenticationEngine() {
        if (this.m_engine == null) {
            this.m_engine = this.createAuthenticationEngine();
            this.m_engine.init(this);
        }
        return this.m_engine;
    }

    protected final void shutdownClient() {
        this.m_engine.init(this);
    }

    protected abstract AuthenticationEngine createAuthenticationEngine();

    public CloseableHttpResponse executeRequest(HttpUriRequest request) throws ClientProtocolException, IOException {
        return this.m_client.execute(request);
    }

    public <T> T executeRequest(HttpUriRequest request, ResponseHandler<? extends T> handler) throws ClientProtocolException, IOException {
        return (T)this.m_client.execute(request, handler);
    }

    public final SessionType getConnectionType() {
        return this.m_type;
    }

    public static Reader createReader(HttpResponse resp) {
        HttpEntity entity = resp.getEntity();
        Header enc = entity.getContentEncoding();
        try {
            return new BufferedReader(new InputStreamReader(entity.getContent()));
        }
        catch (Exception e) {
            return new StringReader("");
        }
    }
}

