/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet;

import java.util.ArrayList;
import javax.swing.text.Segment;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.ide.config.Preferences;
import oracle.javatools.buffer.AbstractTextBuffer;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.data.PropertyStorage;

public class AppendQuickTextBuffer
extends AbstractTextBuffer {
    private static final int DEFAULT_INIT_SIZE = 51200;
    private static final float DEFAULT_GAP_SIZE = 0.2f;
    private static final int MINIMUM_GAP_SIZE = 64;
    private static final int MAXIMUM_GAP_SIZE = 512;
    private static final int MAXIMUM_OVERHEAD = 2048;
    private char[] gapBuffer;
    private int dataSize;
    private int gapOffset;
    private int gapSize;
    private ArrayList<Integer> chunkIndexes = new ArrayList();
    private int maxLines = 0;
    private boolean isLast = false;

    public AppendQuickTextBuffer(ReadWriteLock readWriteLock) {
        super(readWriteLock);
        this.init(51200);
    }

    private void init(int n) {
        this.gapSize = n;
        this.gapBuffer = new char[this.gapSize];
        this.dataSize = 0;
        this.gapOffset = 0;
        this.chunkIndexes = new ArrayList();
        Preferences preferences = Preferences.getPreferences();
        DBConfig dBConfig = DBConfig.getInstance((PropertyStorage)preferences);
        this.maxLines = dBConfig.getInt("MAXSCRIPTLINES");
    }

    private int calculateGapSize(int n) {
        int n2 = (int)((float)n * 0.2f);
        n2 = Math.max(n2, 64);
        return n2;
    }

    public int getLength() {
        return this.dataSize;
    }

    public char getChar(int n) throws IndexOutOfBoundsException {
        return n < this.gapOffset ? this.gapBuffer[n] : this.gapBuffer[n + this.gapSize];
    }

    public char[] getCharsImpl(int n, int n2) throws IndexOutOfBoundsException {
        this.checkOffsets(n, n2);
        char[] cArray = new char[n2];
        int n3 = n;
        int n4 = n + n2;
        if (n4 <= this.gapOffset) {
            System.arraycopy(this.gapBuffer, n3, cArray, 0, n2);
        } else if (this.gapOffset <= n3) {
            System.arraycopy(this.gapBuffer, n3 + this.gapSize, cArray, 0, n2);
        } else {
            int n5 = this.gapOffset - n3;
            int n6 = n4 - this.gapOffset;
            System.arraycopy(this.gapBuffer, n3, cArray, 0, n5);
            System.arraycopy(this.gapBuffer, this.gapOffset + this.gapSize, cArray, n5, n6);
        }
        return cArray;
    }

    protected String getStringImpl(int n, int n2) throws IndexOutOfBoundsException {
        if (n2 == 0) {
            if (n < 0) {
                throw new StringIndexOutOfBoundsException(n);
            }
            if (n > this.getLength()) {
                throw new StringIndexOutOfBoundsException(n);
            }
            return "";
        }
        this.checkOffsets(n, n2);
        int n3 = n;
        int n4 = n + n2;
        if (n4 <= this.gapOffset) {
            return new String(this.gapBuffer, n3, n2);
        }
        if (this.gapOffset <= n3) {
            return new String(this.gapBuffer, n3 + this.gapSize, n2);
        }
        char[] cArray = this.getCharsImpl(n, n2);
        return new String(cArray);
    }

    public void getTextImpl(int n, int n2, Segment segment) throws IndexOutOfBoundsException {
        int n3 = n;
        int n4 = n + n2;
        if (n4 <= this.gapOffset) {
            segment.array = this.gapBuffer;
            segment.offset = n;
            segment.count = n2;
        } else if (this.gapOffset <= n3) {
            segment.array = this.gapBuffer;
            segment.offset = n + this.gapSize;
            segment.count = n2;
        } else {
            char[] cArray = this.getChars(n, n2);
            segment.array = cArray;
            segment.offset = 0;
            segment.count = n2;
        }
    }

    protected void insertImpl(int n, char[] cArray, int n2, int n3) {
        int n4;
        if (n > this.dataSize) {
            throw new IndexOutOfBoundsException("insertImpl out ofbounds:  dataSize: " + this.dataSize + " offset: " + n);
        }
        this.chunkIndexes.add(n3);
        int n5 = this.dataSize + this.gapSize;
        int n6 = n3;
        int n7 = n6 + this.dataSize;
        char[] cArray2 = this.gapBuffer;
        int n8 = n5;
        int n9 = this.gapSize;
        int n10 = this.gapOffset;
        int n11 = n;
        int n12 = Math.min(n10, n11);
        int n13 = Math.max(n10, n11);
        if (this.isLastInsert() && this.getLineCount() > this.maxLines) {
            n4 = this.getLineCount() - this.maxLines;
            int n14 = this.getLineMap().getLineEndOffset(n4);
            int n15 = this.shiftCharsLeftToMakeSpace(n14);
            this.isLast = false;
            this.insertImpl(n - n15, cArray, n2, n3);
        }
        if (n6 > this.gapSize) {
            if (this.getLineCount() > this.maxLines && this.dataSize > n3) {
                n4 = this.shiftCharsLeftToMakeSpace(n3);
                this.insertImpl(n - n4, cArray, n2, n3);
            } else {
                n9 = this.calculateGapSize(n7) + n6;
                n8 = n9 + this.dataSize;
                cArray2 = new char[n8];
                System.arraycopy(this.gapBuffer, 0, cArray2, 0, n12);
                System.arraycopy(this.gapBuffer, n13 + this.gapSize, cArray2, n13 + n9, this.dataSize - n13);
            }
        }
        if (n10 != n11) {
            n4 = n13 - n12;
            if (n10 < n11) {
                System.arraycopy(this.gapBuffer, n12 + this.gapSize, cArray2, n12, n4);
            } else {
                System.arraycopy(this.gapBuffer, n12, cArray2, n12 + n9, n4);
            }
            this.gapOffset = n;
        }
        if (cArray != null) {
            System.arraycopy(cArray, n2, cArray2, this.gapOffset, n6);
        }
        this.gapOffset += n6;
        this.gapSize = n9 - n6;
        this.gapBuffer = cArray2;
        this.dataSize = n7;
    }

    private int shiftCharsLeftToMakeSpace(int n) {
        int n2;
        char[] cArray = this.gapBuffer;
        for (n2 = 0; n2 < n; n2 += this.chunkIndexes.get(0).intValue()) {
            this.chunkIndexes.remove(0);
        }
        this.shiftCharsLeft(n2);
        return n2;
    }

    private int shiftCharsLeft(int n) {
        char[] cArray = this.gapBuffer;
        System.arraycopy(cArray, n, cArray, 0, cArray.length - n);
        int n2 = this.gapOffset - n;
        this.gapOffset -= n;
        this.dataSize -= n;
        this.gapSize = this.gapSize + n - 1;
        for (int i = n2; i < this.gapBuffer.length; ++i) {
            this.gapBuffer[i] = '\u0000';
        }
        this.chunkIndexes.remove(this.chunkIndexes.size() - 1);
        return n;
    }

    protected void removeImpl(int n, int n2) {
        this.checkOffsets(n, 1);
        int n3 = this.dataSize + this.gapSize;
        int n4 = n2;
        int n5 = this.gapOffset;
        int n6 = this.gapSize;
        int n7 = n;
        int n8 = n + n4;
        if (n8 < n5) {
            System.arraycopy(this.gapBuffer, n8, this.gapBuffer, n8 + n6, n5 - n8);
        } else if (n5 < n7) {
            System.arraycopy(this.gapBuffer, n5 + n6, this.gapBuffer, n5, n7 - n5);
        }
        this.gapOffset = n7;
        this.gapSize += n4;
        this.dataSize -= n4;
    }

    private void checkOffsets(int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > this.getLength()) {
            throw new IndexOutOfBoundsException("out of bounds: dataSize: " + this.getLength() + " offset: " + n + " length: " + n2);
        }
    }

    public void finish() {
        this.isLast = true;
    }

    private boolean isLastInsert() {
        return this.isLast;
    }

    protected int getLineCount() {
        return this.getLineMap().getLineCount();
    }
}

