/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands;

import java.awt.Color;
import java.sql.Connection;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.GuiScriptRunnerContext;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;

public class UpdateEditorPane
extends CommandListener {
    private static final Logger LOGGER = Logger.getLogger(UpdateEditorPane.class.getName());
    private HighlightTracker m_highlighter;
    private static Object LOCK = new Object();

    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, final ISQLCommand iSQLCommand) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = LOCK;
                synchronized (object) {
                    if (UpdateEditorPane.this.m_highlighter != null) {
                        UpdateEditorPane.this.m_highlighter.highlight(iSQLCommand);
                    }
                }
            }
        });
    }

    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        return false;
    }

    public void beginScript(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand[] iSQLCommandArray) {
        this.m_highlighter = new HighlightTracker((GuiScriptRunnerContext)scriptRunnerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endScript(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand[] iSQLCommandArray) {
        Object object = LOCK;
        synchronized (object) {
            this.m_highlighter.clearHighlights();
            this.m_highlighter = null;
        }
    }

    private static final class HighlightTracker {
        private HighlightLayer m_layer;
        private HighlightStyle m_style;
        private HighlightedText m_text;
        private GuiScriptRunnerContext m_context;

        private HighlightTracker(GuiScriptRunnerContext guiScriptRunnerContext) {
            this.m_context = guiScriptRunnerContext;
        }

        private void highlight(ISQLCommand iSQLCommand) {
            if (this.init()) {
                try {
                    BasicEditorPane basicEditorPane = this.m_context.getEditorComponenet();
                    int n = basicEditorPane.getLineCount();
                    int n2 = iSQLCommand.getStartLine();
                    int n3 = iSQLCommand.getEndLine() - 1;
                    if (n2 < n && n3 < n) {
                        int n4 = basicEditorPane.getLineStartOffset(n2);
                        int n5 = basicEditorPane.getLineEndOffset(n3);
                        if (this.m_text != null) {
                            this.m_layer.removeHighlight(this.m_text);
                        }
                        if (n4 == 0 && n5 == 0) {
                            n5 = iSQLCommand.getSQLOrig().length();
                        }
                        this.m_text = this.m_layer.addHighlight(this.m_style, n4, n5);
                    }
                }
                catch (ExpiredTextBufferException expiredTextBufferException) {
                    LOGGER.info(expiredTextBufferException.getLocalizedMessage());
                }
                catch (Exception exception) {
                    LOGGER.info(exception.getLocalizedMessage());
                }
            }
        }

        private void clearHighlights() {
            if (this.m_layer != null) {
                try {
                    this.m_layer.removeAllHighlights();
                    this.m_context.getEditorComponenet().destroyHighlightLayer(this.m_layer);
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (Exception exception) {
                    LOGGER.info(exception.getLocalizedMessage());
                }
            }
        }

        private boolean init() {
            BasicEditorPane basicEditorPane;
            if (this.m_layer == null && (basicEditorPane = this.m_context.getEditorComponenet()) != null) {
                this.m_layer = basicEditorPane.createHighlightLayer();
                if (this.m_layer != null) {
                    this.m_style = basicEditorPane.getHighlightRegistry().createStyle("current_sql", "Current SQL", 1, null, new Color(247, 247, 247));
                }
            }
            return this.m_style != null;
        }
    }
}

