/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintBuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import oracle.bali.dbUI.constraint.DCBooleanExpression;
import oracle.bali.dbUI.constraint.DCUnaryExpression;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilder;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilderComp;
import oracle.bali.dbUI.constraintBuilder.DragComponent;
import oracle.bali.dbUI.constraintBuilder.GroupComponent;
import oracle.bali.dbUI.constraintBuilder.GroupPainterComponent;
import oracle.bali.dbUI.constraintBuilder.ParentComponent;
import oracle.bali.dbUI.constraintBuilder.RootComponent;
import oracle.bali.dbUI.constraintBuilder.Sprout;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.dnd.DropTargetDragEvent;

public class AndOrComponent
extends ParentComponent {
    private static final String KEY_REMOVE_AND = "REMOVE_AND";
    private static final String KEY_REMOVE_OR = "REMOVE_OR";
    private static final String KEY_CHANGE_TO_AND = "CHANGE_TO_AND";
    private static final String KEY_CHANGE_TO_OR = "CHANGE_TO_OR";
    private static final int _EXPANDED_WIDTH = 0;
    private static final int _EXPANDED_INCREMENT = 0;
    private GroupComponent _painterComponent;
    private DragComponent _dragComponent;
    private DK _dk;

    public AndOrComponent() {
        this(true);
    }

    public AndOrComponent(boolean isAnd) {
        int value = isAnd ? 0 : 1;
        this._painterComponent = this.createGroupComponent();
        this._painterComponent.setGroup(value);
        LWComponent actualComp = this._painterComponent.getComponent();
        this.addDropTarget(actualComp);
        this._dragComponent = this.createDragComponent(this, actualComp);
        this.addDropTarget(this._dragComponent);
        this.add((Component)((Object)this._dragComponent));
    }

    @Override
    public void enableJDKDnD() {
        super.enableJDKDnD();
        this._dragComponent.enableJDKDnD();
    }

    @Override
    public void performNot() {
        this.setNot(!this.isNot());
    }

    public boolean isNot() {
        int group = this._painterComponent.getGroup();
        return group == 3 || group == 2;
    }

    public void setNot(boolean not) {
        if (this.isNot() != not) {
            String oldName = null;
            if (this.accessibleContext != null) {
                oldName = this.getAccessName();
            }
            int group = this._getGroup(this.isAnd(), not);
            this._painterComponent.setGroup(group);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleName", oldName, this.getAccessName());
            }
        }
    }

    public boolean isAnd() {
        int group = this._painterComponent.getGroup();
        return group == 0 || group == 2;
    }

    public void setAnd(boolean isAnd) {
        if (this.isAnd() != isAnd) {
            String oldName = null;
            if (this.accessibleContext != null) {
                oldName = this.getAccessName();
            }
            int group = this._getGroup(isAnd, this.isNot());
            this._painterComponent.setGroup(group);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleName", oldName, this.getAccessName());
            }
        }
    }

    @Override
    public DataConstraint getDataConstraint() {
        int count = this.getChildCount();
        Vector<DataConstraint> constraints = new Vector<DataConstraint>();
        for (int i = 0; i < count; ++i) {
            DataConstraint current = this.getChild(i).getDataConstraint();
            if (current == null) continue;
            constraints.addElement(current);
        }
        DCBooleanExpression andOr = null;
        count = constraints.size();
        if (count != 0) {
            Object[] c = new DataConstraint[count];
            constraints.copyInto(c);
            int condition = this.isAnd() ? 1 : 2;
            andOr = new DCBooleanExpression((DataConstraint[])c, condition);
        }
        if (!this.isNot()) {
            return andOr;
        }
        return new DCUnaryExpression(andOr, 1);
    }

    @Override
    public void setDataConstraint(DataConstraint constraint) {
        if (constraint instanceof DCUnaryExpression) {
            DCUnaryExpression not = (DCUnaryExpression)constraint;
            constraint = not.getConstraint(0);
            this.setNot(true);
        }
        if (constraint != null && !(constraint instanceof DCBooleanExpression)) {
            throw new IllegalArgumentException("invalid expression");
        }
        this.removeAll();
        if (constraint == null) {
            return;
        }
        boolean and = false;
        ConstraintBuilder b = this.getConstraintBuilder();
        if (constraint instanceof DCBooleanExpression) {
            DCBooleanExpression andOr = (DCBooleanExpression)constraint;
            and = andOr.getOperand() == 1;
            for (int i = 0; i < andOr.getConstraintCount(); ++i) {
                this.addChild(b.parseConstraint(andOr.getConstraint(i)));
            }
        }
        this.setAnd(and);
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this._dragComponent.setSelected(selected);
    }

    @Override
    public void setConstraintBuilder(ConstraintBuilder builder) {
        super.setConstraintBuilder(builder);
        this._dragComponent.setConstraintBuilder(builder);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._dragComponent.setEnabled(enabled);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        Dimension size = this._dragComponent.getPreferredSize();
        d.width += size.width + 2;
        d.width += this._dragComponent.getBorderWidth();
        if (size.height > d.height) {
            d.height = size.height;
        }
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        Dimension size = this._dragComponent.getMinimumSize();
        d.width += size.width + 2;
        if (size.height > d.height) {
            d.height = size.height;
        }
        return d;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        Dimension size = this._dragComponent.getMaximumSize();
        d.width += size.width + 2;
        if (size.height > d.height) {
            d.height = size.height;
        }
        return d;
    }

    @Override
    public int computeLeafLocation() {
        int max = 0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            int temp;
            ConstraintBuilderComp child = this.getChild(i);
            if (!(child instanceof ParentComponent) || (temp = ((ParentComponent)child).computeLeafLocation()) <= max) continue;
            max = temp;
        }
        return max + this.getGroupWidth();
    }

    @Override
    public void setLeafLocation(int location) {
        super.setLeafLocation(location);
        int count = this.getChildCount();
        int toChange = location - (this._dragComponent.getPreferredSize().width + 2);
        for (int i = 0; i < count; ++i) {
            ConstraintBuilderComp child = this.getChild(i);
            if (!(child instanceof ParentComponent)) continue;
            ParentComponent parent = (ParentComponent)child;
            parent.setLeafLocation(toChange);
        }
    }

    public void doLayout() {
        Dimension size = this.getSize();
        Dimension prefSize = this._dragComponent.getPreferredSize();
        int half = (size.height - prefSize.height) / 2;
        this._dragComponent.setBounds(0, half, prefSize.width, prefSize.height);
        int width = prefSize.width;
        if (this.isExpanded()) {
            prefSize = this.getPreferredSize();
            int groupX = width + 2;
            int location = this.getLeafLocation();
            int y = (size.height - prefSize.height) / 2 + 2;
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                ConstraintBuilderComp child = this.getChild(i);
                prefSize = child.getPreferredSize();
                int x = child instanceof ParentComponent || this.getConstraintBuilder() != null && !this.getConstraintBuilder().isAlignLeaves() ? groupX : location;
                child.setBounds(x, y, prefSize.width, prefSize.height);
                y += prefSize.height + 4;
            }
        }
        this.layoutSprouts();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isExpanded()) {
            g.setColor(Color.black);
            Rectangle bounds = this._dragComponent.getBounds();
            int x1 = bounds.x + bounds.width;
            int y = bounds.y + bounds.height / 2;
            int x2 = x1 + 0;
            int inc = 0;
            g.drawLine(x1, y, x2, y);
            g.drawLine(x1, y + 1, x2, y + 1);
            x1 = x2 + inc;
            x2 = x1 + 0;
            g.drawLine(x1, y, x2, y);
            g.drawLine(x1, y + 1, x2, y + 1);
            x1 = x2 + inc;
            x2 = x1 + 0;
            g.drawLine(x1, y, x2, y);
            g.drawLine(x1, y + 1, x2, y + 1);
            x1 = x2 + inc;
            x2 = x1 + 0;
        }
    }

    @Override
    public boolean isDragging() {
        return this._dragComponent.isDragging();
    }

    @Override
    protected void updateSelection(int x, int y, int width, int height) {
        if (this.intersects(this._dragComponent.getBounds(), x, y, width, height)) {
            this.getConstraintBuilder().addToSelection(this, false);
        } else {
            this.getConstraintBuilder().removeFromSelection(this, false);
            super.updateSelection(x, y, width, height);
        }
    }

    @Override
    protected void calculateFeedback(int x, int y) {
        int dragChild;
        if (x < 0) {
            this._dragComponent.setDropping(false);
            this.setFeedbackSprout(null);
            return;
        }
        Rectangle bounds = this._dragComponent.getBounds();
        int defaultX = bounds.x + bounds.width / 4;
        int maxX = bounds.x + bounds.width - 1;
        int topY = bounds.y;
        int bottomY = bounds.y + bounds.height;
        int x1 = -1;
        int x2 = -1;
        int y2 = -1;
        int y1 = -1;
        int insertIndex = -1;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            ConstraintBuilderComp child = this.getChild(i);
            bounds = child.getBounds();
            if (y > bounds.y + bounds.height / 2) continue;
            x2 = bounds.x;
            y2 = bounds.y - 2;
            x2 = bounds.x;
            x1 = defaultX;
            if (y2 <= topY) {
                y1 = topY;
            } else if (y2 >= bottomY) {
                y1 = bottomY;
            } else {
                y1 = y2;
                x1 = maxX;
            }
            insertIndex = i;
            break;
        }
        if (x1 == -1) {
            if (count == 0) {
                Dimension size = this.getSize();
                x1 = bounds.x + bounds.width;
                x2 = 2 + x1;
                y2 = y1 = size.height / 2;
                insertIndex = 0;
            } else {
                x2 = bounds.x;
                y2 = bounds.y + bounds.height + 1;
                x2 = bounds.x;
                x1 = defaultX;
                if (y2 <= topY) {
                    y1 = topY;
                } else if (y2 >= bottomY) {
                    y1 = bottomY;
                } else {
                    y1 = y2;
                    x1 = maxX;
                }
                insertIndex = this.getChildCount();
            }
        }
        if ((dragChild = this._getDraggingChild()) != -1) {
            if (insertIndex == dragChild) {
                this.setFeedbackSprout(null);
                this._dragComponent.setDropping(false);
                return;
            }
            if (insertIndex == dragChild + 1) {
                this.setFeedbackSprout(null);
                this._dragComponent.setDropping(false);
                return;
            }
        }
        this._dragComponent.setDropping(true);
        Sprout feedback = this.getFeedbackSprout();
        if (feedback == null) {
            feedback = new Sprout(0, 0, 0, 0);
        }
        if (feedback.x1 != x1 || feedback.x2 != x2 || feedback.y1 != y1 || feedback.y2 != y2) {
            feedback.x1 = x1;
            feedback.x2 = x2;
            feedback.y1 = y1;
            feedback.y2 = y2;
            this.setFeedbackSprout(feedback);
        }
    }

    @Override
    protected boolean acceptDrag(DropTargetDragEvent dtde) {
        if (this.isDragging()) {
            return false;
        }
        return super.acceptDrag(dtde);
    }

    @Override
    protected int getAccessActionCount() {
        return 11;
    }

    @Override
    protected String getAccessActionDescription(int i) {
        switch (i) {
            case 0: {
                return this.getTranslatedAccessibleString("TOGGLE_SELECT");
            }
            case 1: {
                return this.getTranslatedAccessibleString("CREATE_AND");
            }
            case 2: {
                return this.getTranslatedAccessibleString("CREATE_OR");
            }
            case 3: {
                return this.getTranslatedAccessibleString("PERFORM_NOT");
            }
            case 4: {
                return this.getTranslatedAccessibleString("DELETE");
            }
            case 5: {
                return this.getTranslatedAccessibleString("SIMPLIFY");
            }
            case 6: {
                return this.getTranslatedAccessibleString("TOGGLE_EXPANDED");
            }
            case 7: {
                return this.getTranslatedAccessibleString(KEY_REMOVE_AND);
            }
            case 8: {
                return this.getTranslatedAccessibleString(KEY_REMOVE_OR);
            }
            case 9: {
                return this.getTranslatedAccessibleString(KEY_CHANGE_TO_AND);
            }
            case 10: {
                return this.getTranslatedAccessibleString(KEY_CHANGE_TO_OR);
            }
            case 11: {
                return this.getTranslatedAccessibleString("ADD_CONSTRAINT");
            }
        }
        return null;
    }

    @Override
    protected boolean doAccessAction(int i) {
        boolean root = this.getParentComponent() instanceof RootComponent;
        boolean singleChild = this.getChildCount() == 1;
        boolean removeOK = !root || root & singleChild;
        switch (i) {
            case 0: {
                boolean selected;
                boolean bl = selected = !this.isSelected();
                if (selected) {
                    this.getConstraintBuilder().addToSelection(this, false);
                } else {
                    this.getConstraintBuilder().removeFromSelection(this, false);
                }
                return true;
            }
            case 1: {
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().performCreateAndOr(true, false);
                return true;
            }
            case 2: {
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().performCreateAndOr(false, false);
                return true;
            }
            case 3: {
                if (!this.isNot()) {
                    this.getConstraintBuilder().setSelection(this);
                    this.getConstraintBuilder().createNotOnSelection();
                }
                return true;
            }
            case 4: {
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().deleteSelectedComponents();
                return true;
            }
            case 5: {
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().performSimplify();
                return true;
            }
            case 6: {
                this.setExpanded(!this.isExpanded());
                return true;
            }
            case 7: {
                if (!this.isAnd() || !removeOK) {
                    return false;
                }
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().performRemoveParent();
                return true;
            }
            case 8: {
                if (this.isAnd() || !removeOK) {
                    return false;
                }
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().performRemoveParent();
                return true;
            }
            case 9: {
                if (!this.isAnd()) {
                    this.getConstraintBuilder().setSelection(this);
                    this.getConstraintBuilder().performAndOr(true);
                }
                return true;
            }
            case 10: {
                if (this.isAnd()) {
                    this.getConstraintBuilder().setSelection(this);
                    this.getConstraintBuilder().performAndOr(false);
                }
                return true;
            }
            case 11: {
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().performAdd();
                return true;
            }
        }
        return false;
    }

    protected DragComponent createDragComponent(ParentComponent parent, LWComponent child) {
        DragComponent dragged = new DragComponent(parent, child);
        if (this._dk == null) {
            this._dk = new DK();
        }
        dragged.addMouseListener(this._dk);
        return dragged;
    }

    protected GroupComponent createGroupComponent() {
        GroupPainterComponent grouper = new GroupPainterComponent();
        if (this._dk == null) {
            this._dk = new DK();
        }
        grouper.getComponent().addMouseListener((MouseListener)this._dk);
        return grouper;
    }

    protected final GroupComponent getGroupComponent() {
        return this._painterComponent;
    }

    protected final DragComponent getDragComponent() {
        return this._dragComponent;
    }

    @Override
    protected void layoutSprouts() {
        this.removeAllSprouts();
        int count = this.getChildCount();
        if (count == 0 || !this.isExpanded()) {
            return;
        }
        Rectangle bounds = this._dragComponent.getBounds();
        int defaultX = bounds.x + bounds.width / 2;
        int maxX = bounds.x + bounds.width - 1;
        int topY = bounds.y;
        int bottomY = bounds.y + bounds.height;
        for (int i = 0; i < count; ++i) {
            int y1;
            ConstraintBuilderComp child = this.getChild(i);
            bounds = child.getBounds();
            int y2 = bounds.y + bounds.height / 2;
            int x2 = bounds.x;
            int x1 = defaultX;
            if (y2 <= topY) {
                y1 = topY;
            } else if (y2 >= bottomY) {
                y1 = bottomY;
            } else {
                y1 = y2;
                x1 = maxX;
            }
            Sprout newSprout = new Sprout(x1, y1, x2, y2);
            this.addSprout(newSprout);
        }
    }

    private int _getGroup(boolean and, boolean not) {
        int group = and ? (not ? 2 : 0) : (not ? 3 : 1);
        return group;
    }

    private int _getDraggingChild() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!this.getChild(i).isDragging()) continue;
            return i;
        }
        return -1;
    }

    private class DK
    extends MouseAdapter {
        private DK() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            boolean leftButton;
            boolean bl = leftButton = (e.getModifiers() & 0x10) != 0;
            if (leftButton && AndOrComponent.this.isEnabled() && e.getClickCount() == 2) {
                if (AndOrComponent.this.getConstraintBuilder().isCollapseAllowed()) {
                    AndOrComponent.this.setExpanded(!AndOrComponent.this.isExpanded());
                } else {
                    AndOrComponent.this.getConstraintBuilder().performAndOr(!AndOrComponent.this.isAnd());
                }
                e.consume();
            }
        }
    }
}

