/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.db.impl;

import java.util.Locale;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.Relationship;

public final class RelationshipImpl
extends Relationship {
    private Column[] _children;
    private Column[] _referenced;
    private String _name;
    private int _type;

    public RelationshipImpl(Column child, Column referenced, String name) {
        this(child, referenced, name, 0);
    }

    public RelationshipImpl(Column child, Column referenced, String name, int type) {
        if (type < 0 || type > 5) {
            throw new IllegalArgumentException("type is incorrect");
        }
        this._children = new Column[1];
        this._children[0] = child;
        this._referenced = new Column[1];
        this._referenced[0] = referenced;
        this._name = name;
        this._type = type;
    }

    public RelationshipImpl(Column[] children, Column[] referenced, String name) {
        this(children, referenced, name, 0);
    }

    public RelationshipImpl(Column[] children, Column[] referenced, String name, int type) {
        if (children == null || children.length == 0) {
            throw new IllegalArgumentException("children is empty");
        }
        if (referenced == null || referenced.length == 0) {
            throw new IllegalArgumentException("referenced is empty");
        }
        if (type < 0 || type > 5) {
            throw new IllegalArgumentException("type is incorrect");
        }
        this._children = new Column[children.length];
        System.arraycopy(children, 0, this._children, 0, children.length);
        this._referenced = new Column[referenced.length];
        System.arraycopy(referenced, 0, this._referenced, 0, referenced.length);
        this._name = name;
        this._type = type;
    }

    @Override
    public int getColumnCount() {
        return this._children.length;
    }

    @Override
    public Column getColumn(int index) {
        return this._children[index];
    }

    @Override
    public Column getReferencedColumn(int index) {
        return this._referenced[index];
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public int getRelationshipType() {
        return this._type;
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.getName();
    }

    public String toString() {
        return "Relationship: " + this.getName();
    }
}

