/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.Element;
import oracle.ideimpl.db.explorer.model.DBObjectFolderFactory;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.util.Maps;

public final class ErrorSupport {
    private final Map<String, ErrorProvider> m_reg = new HashMap<String, ErrorProvider>();
    private final Map<URL, Element> m_folders = new Maps.WeakHashMap();

    public void registerErrorProvider(String providerType, ErrorProvider provider) {
        this.m_reg.put(providerType, provider);
    }

    public void setErrors(URL nodeURL, List<Element> errors) {
        Element root = this.m_folders.get(nodeURL);
        if (root != null) {
            DBObjectFolderFactory.setErrors(root, errors);
        }
    }

    private ErrorProvider getErrorProvider(DBObjectNode node) {
        String type;
        ErrorProvider retval = null;
        if (node != null && (type = DBObjectNodeUtil.getProviderType((Object)node)) != null) {
            retval = this.m_reg.get(type);
        }
        return retval;
    }

    void startObserving(DBObjectNode node, Element root) {
        ErrorProvider ep = this.getErrorProvider(node);
        if (ep != null) {
            this.m_folders.put(node.getURL(), root);
            ep.startObserving(node);
        }
    }

    void stopObserving(DBObjectNode node) {
        ErrorProvider ep = this.getErrorProvider(node);
        if (ep != null) {
            ep.stopObserving(node);
            this.m_folders.remove(node.getURL());
        }
    }

    void update(DBObjectNode node, Element root) {
        ErrorProvider ep = this.getErrorProvider(node);
        if (ep != null && this.m_folders.containsKey(node.getURL())) {
            ep.update(node, root);
        }
    }

    public static synchronized ErrorSupport getInstance() {
        DBCore core = DBCore.getInstance();
        ErrorSupport retval = (ErrorSupport)core.get(ErrorSupport.class);
        if (retval == null) {
            retval = new ErrorSupport();
            core.put((Object)retval);
        }
        return retval;
    }

    public static abstract class ErrorProvider {
        public void startObserving(DBObjectNode node) {
        }

        public void stopObserving(DBObjectNode node) {
        }

        public void update(DBObjectNode node, Element root) {
        }
    }
}

