/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import javax.swing.Icon;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ideimpl.db.explorer.model.BaseDBObjectFolder;
import oracle.ideimpl.db.explorer.model.ExplorerModelHelper;
import oracle.ideimpl.db.explorer.model.ObjectFolder;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.property.PropertyInfo;

class DBObjectFolder
extends ObjectFolder
implements BaseDBObjectFolder {
    private DBObjectNode m_node;

    public DBObjectFolder(DBObject obj, DBObjectProvider pro, String propName) {
        super(obj, pro, propName);
    }

    public DBObjectFolder(DBObjectNode node) {
        super(null, DBObjectNodeUtil.findProvider((Object)node), null);
        this.m_node = node;
    }

    @Override
    protected DBObjectProvider useDBRunnable() {
        DBObject cachedObj;
        DBObjectProvider retval = null;
        DBObjectProvider pro = this.getProvider();
        if (pro instanceof Database && ((cachedObj = (DBObject)super.getObject()) == null || DBUtil.needsBuilding((DBObject)DBUtil.getSystemObject((DBObject)cachedObj)))) {
            retval = pro;
        }
        return retval;
    }

    void setDBObjectNode(DBObjectNode node) {
        if (this.m_node != null) {
            this.m_node = node;
            this.setObject(null);
        }
    }

    @Override
    protected boolean isIgnoredProperty(PropertyInfo info, DBObjectProvider pro, Object object) {
        boolean retval = pro instanceof Database && object instanceof Index && "table".equals(info.getPropertyName()) ? false : super.isIgnoredProperty(info, pro, object);
        return retval;
    }

    @Override
    public String getObjectType() {
        String retval = this.m_node == null ? BaseDBObjectFolder.super.getObjectType() : DBObjectNodeUtil.normalizeType((DBObjectTypeNode)this.m_node);
        return retval;
    }

    public DBObject getDBObject() {
        return this.getObject();
    }

    @Override
    public String getObjectName() {
        String retval = this.m_node == null ? BaseDBObjectFolder.super.getObjectName() : this.m_node.getObjectName();
        return retval;
    }

    @Override
    public String getSchemaName() {
        String retval = this.m_node == null ? BaseDBObjectFolder.super.getSchemaName() : DBObjectNodeUtil.getSchemaName((DBObjectTypeNode)this.m_node);
        return retval;
    }

    @Override
    public Object getKey() {
        return ExplorerModelHelper.getKeyForObject(this.getObject(), this.getProperty());
    }

    protected DBObject getObject() {
        DBObject retval = (DBObject)super.getObject();
        if (retval == null && this.m_node != null && (retval = this.m_node.getDBObject()) != null) {
            this.setObject(retval);
        }
        return retval;
    }

    @Override
    protected Icon createIcon() {
        Icon retval = this.m_node == null ? super.createIcon() : this.m_node.getIcon();
        return retval;
    }

    @Override
    protected String createLabel() {
        String retval = this.m_node == null ? super.createLabel() : this.m_node.getShortLabel();
        return retval;
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }
}

