/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.model.Element;
import oracle.ideimpl.db.explorer.model.DBExplorerElement;
import oracle.ideimpl.db.explorer.model.DBObjectFolder;
import oracle.ideimpl.db.explorer.model.ExplorerModelHelper;
import oracle.ideimpl.db.explorer.model.ObjectFolder;
import oracle.ideimpl.db.explorer.model.PlSqlFragmentElement;
import oracle.ideimpl.db.explorer.model.PropertyNode;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.icons.OracleIcons;

final class DBTypeFolder
extends PropertyNode
implements DBObjectTypeNode {
    private Icon m_icon;

    public DBTypeFolder(PropertyInfo info, DBObject obj, DBObjectProvider pro) {
        super(info, obj, pro, true);
    }

    @Override
    protected List<Element> createChildren(List<Element> existing) {
        ArrayList<Element> retval = new ArrayList<Element>();
        DBObjectProvider pro = this.getProvider();
        PropertyInfo info = this.getPropertyInfo();
        Object value = info.getPropertyValue(this.getParentObject());
        this.setObject(value);
        if (value instanceof Object[]) {
            for (Object obj : (Object[])value) {
                DBExplorerElement elem = null;
                if (obj instanceof DBObject) {
                    elem = ExplorerModelHelper.find(existing, ExplorerModelHelper.getKeyForObject((DBObject)obj, info.getPropertyName()));
                    if (elem instanceof DBObjectFolder) {
                        ((DBObjectFolder)elem).setObject((DBObject)obj);
                    } else {
                        elem = obj instanceof DBObjectPlSqlFragment ? new PlSqlFragmentElement((DBObject)obj, pro, null) : new DBObjectFolder((DBObject)obj, pro, null);
                    }
                } else {
                    elem = new ObjectFolder(obj, pro, null);
                }
                if (elem == null) continue;
                elem.setHelper(this.getHelper());
                retval.add(elem);
            }
        } else if (value != null) {
            throw new IllegalStateException(this.getPropertyName() + ": DBTypeFolder is only valid for array props");
        }
        return retval;
    }

    public String getSchemaName() {
        return null;
    }

    public String getObjectType() {
        Class<?> clz = this.getPropertyInfo().getPropertyClass();
        if (clz.isArray()) {
            clz = clz.getComponentType();
        }
        return Metadata.getType((Class)clz);
    }

    public Object getProviderIdentifier() {
        return this.getProvider().getProviderIdentifier();
    }

    public String getProviderType() {
        return this.getProvider().getProviderType();
    }

    @Override
    public Icon getIcon() {
        if (this.m_icon == null) {
            this.m_icon = DBTypeDisplayRegistry.getFolderIcon((String)this.getObjectType());
            if (this.m_icon == null) {
                this.m_icon = OracleIcons.getIcon((String)"folder.png");
            }
        }
        return this.m_icon;
    }

    @Override
    protected String createLabel() {
        return PropertyDisplayRegistry.getDisplayName((String)this.getPropertyName(), (DBObjectProvider)this.getProvider(), (DBObject)this.getParentDBObject());
    }

    @Override
    protected boolean sortChildren() {
        String propName = this.getPropertyName();
        return "constraints".equals(propName) || "indexes".equals(propName);
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }
}

