/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ideimpl.db.explorer.model.BaseFolder;
import oracle.ideimpl.db.explorer.model.DBExplorerElement;
import oracle.ideimpl.db.explorer.model.DBObjectFolder;
import oracle.ideimpl.db.explorer.model.DBTypeFolder;
import oracle.ideimpl.db.explorer.model.PlSqlFragmentElement;
import oracle.ideimpl.db.explorer.model.PropertiesFolder;
import oracle.ideimpl.db.explorer.model.PropertyNode;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.DynamicPropertySet;
import oracle.javatools.util.ModelUtil;

final class ExplorerModelHelper {
    private Context m_context;
    private DBObjectFolder m_rootFolder;

    public ExplorerModelHelper(Context context) {
        this.m_context = context;
        if (context == null || !(context.getNode() instanceof DBObjectNode)) {
            throw new IllegalArgumentException("Context must contain a DBObject.");
        }
    }

    public DBExplorerElement findOrCreateElement(Object parent, PropertyInfo info, DBObjectProvider pro, List<Element> existing) {
        DBExplorerElement elem = null;
        String propName = info.getPropertyName();
        Class propClz = info.getPropertyClass();
        if (Schema.class == propClz) {
            elem = new PropertyNode(info, parent, pro);
        } else if (DBObject.class.isAssignableFrom(propClz)) {
            DBObject obj = (DBObject)info.getPropertyValue(parent);
            if (obj != null) {
                elem = ExplorerModelHelper.find(existing, ExplorerModelHelper.getKeyForObject(obj, propName));
                if (elem instanceof DBObjectFolder) {
                    ((DBObjectFolder)elem).setObject(obj);
                } else {
                    elem = obj instanceof DBObjectPlSqlFragment ? new PlSqlFragmentElement(obj, pro, propName) : new DBObjectFolder(obj, pro, propName);
                }
            }
        } else {
            elem = ExplorerModelHelper.find(existing, propName);
            if (elem == null) {
                if (propClz.isArray()) {
                    if (parent instanceof DBObject) {
                        elem = new DBTypeFolder(info, (DBObject)parent, pro);
                    }
                } else {
                    elem = Map.class.isAssignableFrom(propClz) || DynamicPropertySet.class.isAssignableFrom(propClz) ? new PropertiesFolder(info, parent, pro) : new PropertyNode(info, parent, pro);
                }
            } else if (elem instanceof PropertyNode) {
                ((PropertyNode)elem).setParentObject(parent);
            }
        }
        if (elem != null) {
            elem.setHelper(this);
            if (this.shouldInclude(elem, parent, info, pro)) {
                DBLog.getLogger((Object)this).log(Level.FINEST, "Including {0}", info.getPropertyName());
            } else {
                elem = null;
                DBLog.getLogger((Object)this).log(Level.FINEST, "Ignoring {0}", info.getPropertyName());
            }
        }
        return elem;
    }

    private boolean shouldInclude(DBExplorerElement elem, Object parent, PropertyInfo info, DBObjectProvider pro) {
        boolean retval;
        if (parent instanceof DBObject && elem.mayHaveChildren()) {
            if (elem instanceof BaseFolder && ((BaseFolder)elem).useDBRunnable() != null) {
                String propName = info.getPropertyName();
                if ("properties".equals(propName)) {
                    Class<?> objClz = ((DBObject)parent).getClass();
                    PropertyCriteria crit = new PropertyCriteria();
                    crit.setIncludeBean(false);
                    crit.addPredicate(pi -> this.isLazy((DBObject)parent, pi.getPropertyName()) || this.hasValue((PropertyInfo)pi, parent));
                    retval = Metadata.getInstance().hasSupportedProperty(objClz, pro.getClass(), (Predicate)crit);
                } else {
                    retval = this.isLazy((DBObject)parent, propName) ? pro.getPropertyManager().supportsProperty(((DBObject)parent).getClass(), propName) : this.hasValue(info, parent);
                }
            } else {
                retval = elem instanceof PropertiesFolder || elem instanceof DBTypeFolder ? elem.getChildren().hasNext() : this.hasValue(info, parent);
            }
        } else {
            retval = this.hasValue(info, parent);
        }
        return retval;
    }

    private boolean isLazy(DBObject obj, String propName) {
        return DBUtil.getDBObjectBuilder((DBObject)obj, (String)propName) != null;
    }

    private boolean hasValue(PropertyInfo info, Object parent) {
        Object value = info.getPropertyValue(parent);
        boolean retval = value == null ? info.getNullBehaviour() == Nullable.NullBehaviour.NULLABLE : (value instanceof Object[] ? ((Object[])value).length > 0 : (value instanceof Map ? !((Map)value).isEmpty() : true));
        return retval;
    }

    void setRootFolder(DBObjectFolder root) {
        this.m_rootFolder = root;
    }

    public boolean isChildOfTopObject(DBObjectID id) {
        DBObject obj;
        boolean retval = false;
        if (this.m_rootFolder != null && (obj = this.m_rootFolder.getDBObject()) != null) {
            DBObjectID topID = obj.getID();
            retval = DBUtil.isSameOrChildOf((DBObjectID)id, (DBObjectID)topID, (boolean)true);
        }
        return retval;
    }

    DBObjectNode getNode() {
        Node node = this.m_context.getNode();
        if (!(node instanceof DBObjectNode)) {
            String nodeDesc = node == null ? "null" : node.getClass().getName() + " " + node.getLongLabel();
            throw new IllegalStateException("Context must have a DBObjectNode, not " + nodeDesc);
        }
        DBObjectNode retval = (DBObjectNode)node;
        return retval;
    }

    static final Object getKeyForObject(DBObject childObj, String propName) {
        String retval = childObj.getName();
        if (!ModelUtil.hasLength((String)retval)) {
            retval = propName;
        }
        return String.valueOf(retval);
    }

    static final DBExplorerElement find(List<Element> elems, Object key) {
        DBExplorerElement retval = null;
        if (elems != null) {
            for (Element elem : elems) {
                if (!(elem instanceof DBExplorerElement) || !ModelUtil.areEqual((Object)((DBExplorerElement)elem).getKey(), (Object)key)) continue;
                retval = (DBExplorerElement)elem;
                break;
            }
        }
        return retval;
    }
}

