/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.Collections;
import java.util.List;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.model.Element;
import oracle.ideimpl.db.explorer.model.DBObjectFolder;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInfo;

public class PlSqlFragmentElement
extends DBObjectFolder {
    private Boolean m_isPlSqlReference;
    private String m_label;

    public PlSqlFragmentElement(DBObject obj, DBObjectProvider pro, String propName) {
        super(obj, pro, propName);
    }

    public PlSqlFragmentElement(DBObjectNode node) {
        super(node);
    }

    public int getStartOffset() {
        DBObject obj = this.getDBObject();
        Integer start = null;
        if (obj instanceof DBObjectPlSqlFragment) {
            start = ((DBObjectPlSqlFragment)obj).getStartOffset();
        }
        return start == null ? 0 : start;
    }

    @Override
    protected DBObjectProvider useDBRunnable() {
        return this.getProvider();
    }

    @Override
    protected List<Element> createChildren(List<Element> existing) throws CancelledException {
        boolean incChildren = true;
        DBObject object = this.getObject();
        if (object instanceof PlSqlSourceObject) {
            PlSqlParser parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)((PlSqlSourceObject)object), (DBObjectProvider)this.getProvider());
            incChildren = parser != null && !parser.isWrapped();
        }
        return incChildren ? super.createChildren(existing) : Collections.emptyList();
    }

    @Override
    protected boolean isIgnoredProperty(PropertyInfo info, DBObjectProvider pro, Object object) {
        String prop = info.getPropertyName();
        boolean ignore = super.isIgnoredProperty(info, pro, object);
        if (!ignore && ("startOffset".equals(prop) || "endOffset".equals(prop) || "statementType".equals(prop) || "properties".equals(prop))) {
            ignore = true;
        }
        if (!ignore) {
            Class<?> cls = info.getPropertyClass();
            if (cls.isArray()) {
                cls = cls.getComponentType();
            }
            if (!(!DBObjectPlSqlFragment.class.isAssignableFrom(cls) || "dataTypeReference".equals(prop) || "returnTypeReference".equals(prop) || PlSqlDatum.class.isAssignableFrom(cls) || PlSqlSubProgram.class.isAssignableFrom(cls))) {
                ignore = true;
            }
        }
        return ignore;
    }

    @Override
    public boolean mayHaveChildren() {
        if (this.isPlSqlReference()) {
            return false;
        }
        return super.mayHaveChildren();
    }

    @Override
    public String getShortLabel() {
        if (this.m_label == null) {
            if (this.isPlSqlReference()) {
                PlSqlReference ref = (PlSqlReference)this.getDBObject();
                this.m_label = this.createPropertyLabel(this.getProperty(), ref.toString(), ref.getParent());
            } else {
                this.m_label = super.getShortLabel();
            }
        }
        return this.m_label;
    }

    private boolean isPlSqlReference() {
        if (this.m_isPlSqlReference == null) {
            this.m_isPlSqlReference = Metadata.getInstance().isTypeOf(PlSqlReference.class, this.getObjectType());
        }
        return this.m_isPlSqlReference;
    }
}

