/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.net.URL;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectPropertyNode;
import oracle.ide.model.Element;
import oracle.ideimpl.db.explorer.model.ObjectFolder;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyInfo;

class PropertyNode
extends ObjectFolder
implements DBObjectPropertyNode {
    private URL m_url;
    private Object m_parentObject;
    private final boolean m_lazy;
    private final PropertyInfo m_info;

    public PropertyNode(PropertyInfo info, Object parent, DBObjectProvider pro) {
        this(info, parent, pro, false);
    }

    protected PropertyNode(PropertyInfo info, Object parent, DBObjectProvider pro, boolean lazy) {
        super(null, pro, info.getPropertyName());
        this.m_info = info;
        this.m_lazy = lazy;
        this.setParentObject(parent);
    }

    protected final PropertyInfo getPropertyInfo() {
        return this.m_info;
    }

    @Override
    public Object getKey() {
        return this.getProperty();
    }

    @Override
    public boolean mayHaveChildren() {
        return super.mayHaveChildren() && !"schema".toString().equals(this.getProperty());
    }

    @Override
    protected String createPropertyLabel(String propName, Object value, DBObject context) {
        if (context == null && this.m_parentObject instanceof DBObject) {
            context = (DBObject)this.m_parentObject;
        }
        return super.createPropertyLabel(propName, value, context);
    }

    @Override
    protected DBObjectProvider useDBRunnable() {
        DBObjectProvider pro = this.getProvider();
        return pro instanceof Database && this.m_parentObject instanceof AbstractBuildableObject ? pro : null;
    }

    protected final Object getParentObject() {
        return this.m_parentObject;
    }

    public final void setParentObject(Object obj) {
        this.m_parentObject = obj;
        this.setObject(this.m_lazy ? null : this.m_info.getPropertyValue(obj));
    }

    public DBObject getParentDBObject() {
        DBObject retval = null;
        if (this.m_parentObject instanceof DBObject) {
            retval = (DBObject)this.m_parentObject;
        } else {
            Element par = this.getParentElement();
            if (par instanceof DBObjectPropertyNode) {
                retval = ((DBObjectPropertyNode)par).getParentDBObject();
            } else if (par instanceof DBObjectNode) {
                retval = ((DBObjectNode)par).getDBObject();
            }
        }
        return retval;
    }

    public String getPropertyName() {
        String retval = this.getProperty();
        if (!(this.m_parentObject instanceof DBObject)) {
            Element par = this.getParentElement();
            retval = par instanceof DBObjectPropertyNode ? Property.createPath((String[])new String[]{((DBObjectPropertyNode)par).getPropertyName(), retval}) : null;
        }
        return retval;
    }

    public void setURL(URL url) {
        this.m_url = url;
    }

    public URL getURL() {
        return this.m_url;
    }
}

