/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.fop.render.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.render.afp.modca.MaximumSizeExceededException;
import org.apache.fop.render.afp.modca.PresentationTextData;

public class PresentationTextObject
extends AbstractNamedAFPObject {
    private static final String DEFAULT_NAME = "PTO00001";
    private PresentationTextData currentPresentationTextData = null;
    private ArrayList presentationTextData = new ArrayList();

    public PresentationTextObject() {
        this(DEFAULT_NAME);
    }

    public PresentationTextObject(String name) {
        super(name);
    }

    public void createTextData(int fontNumber, int x, int y, Color col, int vsci, int ica, byte[] data) {
        this.createTextData(fontNumber, x, y, 0, col, vsci, ica, data);
    }

    public void createTextData(int fontNumber, int x, int y, int orientation, Color col, int vsci, int ica, byte[] data) {
        if (this.currentPresentationTextData == null) {
            this.startPresentationTextData();
        }
        try {
            this.currentPresentationTextData.createTextData(fontNumber, x, y, orientation, col, vsci, ica, data);
        }
        catch (MaximumSizeExceededException msee) {
            this.endPresentationTextData();
            this.createTextData(fontNumber, x, y, orientation, col, vsci, ica, data);
        }
    }

    public void createLineData(int x1, int y1, int x2, int y2, int thickness, Color col) {
        this.createLineData(x1, y1, x2, y2, thickness, 0, col);
    }

    public void createLineData(int x1, int y1, int x2, int y2, int thickness, int orientation, Color col) {
        if (this.currentPresentationTextData == null) {
            this.startPresentationTextData();
        }
        try {
            this.currentPresentationTextData.createLineData(x1, y1, x2, y2, thickness, orientation, col);
        }
        catch (MaximumSizeExceededException msee) {
            this.endPresentationTextData();
            this.createLineData(x1, y1, x2, y2, thickness, orientation, col);
        }
    }

    private void startPresentationTextData() {
        this.currentPresentationTextData = this.presentationTextData.size() == 0 ? new PresentationTextData(true) : new PresentationTextData();
        this.presentationTextData.add(this.currentPresentationTextData);
    }

    private void endPresentationTextData() {
        this.currentPresentationTextData = null;
    }

    public void writeDataStream(OutputStream os) throws IOException {
        this.writeStart(os);
        this.writeObjectList(this.presentationTextData, os);
        this.writeEnd(os);
    }

    public String getName() {
        return this.name;
    }

    private void writeStart(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -88;
        data[5] = -101;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this.nameBytes.length; ++i) {
            data[9 + i] = this.nameBytes[i];
        }
        os.write(data);
    }

    private void writeEnd(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -87;
        data[5] = -101;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this.nameBytes.length; ++i) {
            data[9 + i] = this.nameBytes[i];
        }
        os.write(data);
    }

    public void endControlSequence() {
        if (this.currentPresentationTextData == null) {
            this.startPresentationTextData();
        }
        try {
            this.currentPresentationTextData.endControlSequence();
        }
        catch (MaximumSizeExceededException msee) {
            this.endPresentationTextData();
            this.endControlSequence();
        }
    }
}

