/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.Preferences;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.DockableView;
import oracle.ide.layout.Layouts;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.panels.Navigable;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.RunProcessLifecycleListener;
import oracle.ide.runner.Runner;
import oracle.ide.runner.RunnerOptions;
import oracle.ide.runner.StarterFactory;
import oracle.ideimpl.runner.Processes;
import oracle.ideimpl.runner.RunManager;
import oracle.ideimpl.runner.RunManagerUI;
import oracle.ideimpl.runner.RunManagerWindow;
import oracle.ideimpl.runner.RunnerBundle;
import oracle.ideimpl.runner.RunnerHook;
import oracle.ideimpl.runner.StarterFactoryHook;
import oracle.javatools.data.PropertyStorage;

public class RunnerImpl
extends Runner
implements ShutdownHook {
    private boolean shuttingDown = false;
    private static Processes processes;
    private static RunManagerWindow runManagerWindow;
    private static RunnerOptions runnerOptions;
    private static RunManagerUI instanceUI;
    private static boolean hasUI;
    private static Runner instance;
    private StarterFactoryHook starterFactoryHook;

    private RunnerImpl() {
        ExitCommand.addShutdownHook((ShutdownHook)this);
        hasUI = Ide.getIdeArgs().getCreateUI();
        this.starterFactoryHook = new StarterFactoryHook();
    }

    public static synchronized Runner getInstance() {
        if (instance == null) {
            instance = new RunnerImpl();
        }
        return instance;
    }

    @Override
    public boolean isRunning(Project project) {
        if (processes != null) {
            for (RunProcess runProcess : processes.getRunProcesses()) {
                if (project != null && project != runProcess.getProject()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean terminate(Project project, boolean force) {
        if (processes != null) {
            ArrayList<RunProcess> temp = new ArrayList<RunProcess>();
            for (RunProcess runProcess : processes.getRunProcesses()) {
                if (project != null && project != runProcess.getProject()) continue;
                temp.add(runProcess);
            }
            int length = temp.size();
            if (length > 0) {
                boolean kill;
                if (force) {
                    kill = true;
                } else {
                    String title;
                    Object[] messages = new Object[1 + length];
                    int im = 0;
                    String productName = Ide.getProgramShortName();
                    if (length == 1) {
                        messages[im++] = RunnerBundle.format("ASK_BEFORE_TERMINATE_1", productName);
                        title = RunnerBundle.get("ASK_BEFORE_TERMINATE_TITLE_1");
                    } else {
                        messages[im++] = RunnerBundle.format("ASK_BEFORE_TERMINATE_1", productName);
                        title = RunnerBundle.get("ASK_BEFORE_TERMINATE_TITLE_2");
                    }
                    for (RunProcess runProcess : temp) {
                        JLabel label = new JLabel(runProcess.getShortLabel(), runProcess.getIcon(), 2);
                        messages[im++] = label;
                    }
                    int answer = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), messages, title, 0, 3);
                    boolean bl = kill = answer == 0;
                }
                if (kill) {
                    this.shuttingDown = true;
                    for (RunProcess runProcess : temp) {
                        runProcess.terminate();
                    }
                    final Layouts layouts = Layouts.getLayouts();
                    Runnable activate = new Runnable(){

                        @Override
                        public void run() {
                            layouts.activateLayout(layouts.getDesignLayout());
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        activate.run();
                    } else {
                        SwingUtilities.invokeLater(activate);
                    }
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public JMenu getRunMenu() {
        return MenuManager.getJMenu((String)"Run");
    }

    @Override
    public synchronized NavigatorWindow getRunManagerWindow() {
        RunManagerUI runManagerUI = this.getUI();
        if (runManagerUI != null) {
            if (runManagerWindow == null) {
                Context context = Context.newIdeContext((Element)RunManager.getInstance());
                context.setProject(null);
                context.setWorkspace(null);
                runManagerWindow = new RunManagerWindow(context, this);
                runManagerWindow.setToolbarVisible(true);
                runManagerWindow.addViewSelectionListener(runManagerUI);
                this.getProcessesFolder();
            }
            return runManagerWindow;
        }
        return null;
    }

    @Override
    public Folder getRunManagerFolder() {
        this.getRunManagerWindow();
        return RunManager.getInstance();
    }

    @Override
    public synchronized Folder getProcessesFolder() {
        if (processes == null) {
            try {
                processes = new Processes(this);
                this.getRunManagerFolder().add((Element)processes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return processes;
    }

    @Override
    public synchronized RunProcess[] getRunProcesses() {
        return ((Processes)this.getProcessesFolder()).getRunProcesses();
    }

    @Override
    public void viewRunManager() {
        DockUtil.showDockableWindow((DockableView)this.getRunManagerWindow());
    }

    @Override
    public boolean isRunManagerVisible() {
        if (runManagerWindow == null) {
            return false;
        }
        return runManagerWindow.isVisible();
    }

    @Override
    public IdeAction getViewRunManagerAction() {
        return IdeAction.find((int)RunManagerUI.VIEW_RUN_MANAGER_CMD_ID);
    }

    @Override
    public boolean selectProcess(RunProcess runProcess) {
        return ((RunManagerWindow)this.getRunManagerWindow()).selectProcess(runProcess);
    }

    @Override
    public void addTerminateMenu(RunProcess runProcess) {
        RunManagerUI runManagerUI = this.getUI();
        if (runManagerUI != null) {
            runManagerUI.addTerminateMenu(runProcess);
        }
    }

    @Override
    public void removeTerminateMenu(RunProcess runProcess) {
        RunManagerUI runManagerUI = this.getUI();
        if (runManagerUI != null) {
            runManagerUI.removeTerminateMenu(runProcess);
        }
    }

    @Override
    public void registerStarterFactory(Class targetClass, StarterFactory starterFactory) {
        this.starterFactoryHook.registerStarterFactory(targetClass, starterFactory);
    }

    @Override
    public void unregisterStarterFactory(Class targetClass, StarterFactory starterFactory) {
        this.starterFactoryHook.unRegisterStarterFactory(targetClass, starterFactory);
    }

    @Override
    @Deprecated
    public Class[] getClassesWithRegisteredStarterFactory() {
        return this.starterFactoryHook.getClassesWithRegisteredStarterFactory();
    }

    @Override
    @Deprecated
    public AbstractStarterFactory[] getRegisteredStarterFactories(Class targetClass) {
        return this.starterFactoryHook.getStarterFactoriesForTarget(null, null, targetClass, true, null);
    }

    @Override
    @Deprecated
    public AbstractStarterFactory[] getRegisteredStarterFactories(Class targetClass, Class starterFactorySubClass) {
        return this.starterFactoryHook.getStarterFactoriesForTarget(null, null, targetClass, true, starterFactorySubClass);
    }

    @Override
    public AbstractStarterFactory[] getRegisteredStarterFactories(Project project, Node targetNode, Class starterFactoryClass) {
        return this.starterFactoryHook.getStarterFactoriesForTarget(project, targetNode, null, true, starterFactoryClass);
    }

    @Override
    @Deprecated
    public AbstractStarterFactory[] getStarterFactoriesForTarget(Class targetClass) {
        return this.starterFactoryHook.getStarterFactoriesForTarget(null, null, targetClass, false, null);
    }

    @Override
    @Deprecated
    public AbstractStarterFactory[] getStarterFactoriesForTarget(Class targetClass, Class starterFactorySubClass) {
        return this.starterFactoryHook.getStarterFactoriesForTarget(null, null, targetClass, false, starterFactorySubClass);
    }

    @Override
    public AbstractStarterFactory[] getStarterFactoriesForTarget(Project project, Node targetNode, Class starterFactorySubClass) {
        return this.starterFactoryHook.getStarterFactoriesForTarget(project, targetNode, null, false, starterFactorySubClass);
    }

    @Override
    public boolean couldNodeBeRunnable(Node node) {
        if (node == null) {
            assert (node != null);
            return false;
        }
        return this.starterFactoryHook.hasStarterFactoryForTarget(node.getClass(), null);
    }

    @Override
    public boolean couldNodeBeRunnable(Node node, Class starterFactorySubClass) {
        if (node == null) {
            assert (node != null);
            return false;
        }
        return this.starterFactoryHook.hasStarterFactoryForTarget(node.getClass(), starterFactorySubClass);
    }

    @Override
    public boolean enableRunDebugActions(Context context, Class starterFactorySubClass) {
        return this.starterFactoryHook.enableRunDebugActions(context, starterFactorySubClass);
    }

    @Override
    @Deprecated
    public Navigable getProjectSettingsRunnerNavigable() {
        return null;
    }

    @Override
    @Deprecated
    public void setProjectSettingsRunnerNavigable(Navigable navigable) {
    }

    @Override
    public void addRunConfigurationLaunchNavigable(Navigable navigable) {
        RunnerHook.addLaunchNavigable(navigable);
    }

    @Override
    public Navigable[] getRunConfigurationLaunchNavigables(Project project) {
        List<Navigable> navigables = RunnerHook.getLaunchNavigables(null, project);
        return navigables.toArray(new Navigable[navigables.size()]);
    }

    @Override
    public void addRunConfigurationToolNavigable(Navigable navigable) {
        RunnerHook.addToolNavigable(navigable);
    }

    @Override
    public Navigable[] getRunConfigurationToolNavigables(Project project) {
        List<Navigable> navigables = RunnerHook.getToolNavigables(null, project);
        return navigables.toArray(new Navigable[navigables.size()]);
    }

    @Override
    public Navigable[] getRunConfigurationMacroNavigables(Project project) {
        List<Navigable> navigables = RunnerHook.getMacroNavigables(project.getWorkspace(), project);
        return navigables.toArray(new Navigable[navigables.size()]);
    }

    @Override
    public Navigable[] getRunConfigurationCustomNavigables(Project project) {
        List<Navigable> navigables = RunnerHook.getCustomNavigables(project.getWorkspace(), project);
        return navigables.toArray(new Navigable[navigables.size()]);
    }

    @Override
    public RunProcess[] getContainedRunProcesses(RunProcess container) {
        ArrayList<RunProcess> procs = new ArrayList<RunProcess>();
        RunProcess[] allprocs = this.getRunProcesses();
        if (allprocs != null) {
            for (RunProcess runProcess : allprocs) {
                if (runProcess.hasFinished() || runProcess.getContainer() != container) continue;
                procs.add(runProcess);
            }
        }
        return procs.toArray(new RunProcess[procs.size()]);
    }

    @Override
    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    @Override
    public void addLifecycleListener(RunProcessLifecycleListener listener) {
        RunnerHook.addLifecycleListener(listener);
    }

    @Override
    public void removeLifecycleListener(RunProcessLifecycleListener listener) {
        RunnerHook.removeLifecycleListener(listener);
    }

    @Override
    public List<RunProcessLifecycleListener> getLifecycleListeners(Context context) {
        return RunnerHook.getLifecycleListeners(context.getWorkspace(), context.getProject());
    }

    @Override
    @Deprecated
    public EventListenerList getListeners(Context context) {
        List<RunProcessLifecycleListener> listeners = RunnerHook.getLifecycleListeners(context.getWorkspace(), context.getProject());
        EventListenerList list = new EventListenerList();
        for (RunProcessLifecycleListener listener : listeners) {
            list.add(RunProcessLifecycleListener.class, listener);
        }
        return list;
    }

    @Override
    public RunnerOptions getRunnerOptions() {
        if (runnerOptions == null) {
            RunnerImpl.initializeIdeSettings();
        }
        return runnerOptions;
    }

    public void shutdown() {
        this.terminate(null, true);
    }

    public boolean canShutdown() {
        return !this.isRunning(null) || this.terminate(null, false);
    }

    private static void initializeIdeSettings() {
        Preferences p = Preferences.getPreferences();
        runnerOptions = RunnerOptions.getInstance((PropertyStorage)p);
    }

    boolean isActiveRunProcess(RunProcess runProcess) {
        RunManagerUI runManagerUI = this.getUI();
        if (runManagerUI != null) {
            return runManagerUI.isActiveRunProcess(runProcess);
        }
        return false;
    }

    void selectNewActiveRunProcess(RunProcess newActiveRunProcess) {
        RunManagerUI runManagerUI = this.getUI();
        if (runManagerUI != null) {
            runManagerUI.selectNewActiveRunProcess(newActiveRunProcess);
        }
    }

    private RunManagerUI getUI() {
        if (instanceUI == null && hasUI) {
            instanceUI = (RunManagerUI)AddinManager.getAddinManager().getAddin(RunManagerUI.class);
        }
        return instanceUI;
    }

    static {
        instanceUI = null;
    }
}

