/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.jar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeUtil;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarIndexEntry;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableCellRenderer;
import oracle.jdeveloper.resource.ViewersArb;
import oracle.jdevimpl.jar.JarFileTableModel;
import oracle.jdevimpl.jar.JarNode;

class JarViewerContentPanel
extends JPanel {
    private final JLabel _lblHeader = new JLabel();
    private final JarFileTableModel _model = new JarFileTableModel();
    private final GenericTable _table;
    private final JScrollPane _spTable;
    private transient JarNode _jarNode;
    private static final NumberFormat TWO_DP_FORMAT = NumberFormat.getInstance();

    JarViewerContentPanel() {
        final TableRowSorter<JarFileTableModel> caseSensitiveSorter = new TableRowSorter<JarFileTableModel>(this._model);
        caseSensitiveSorter.setComparator(0, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = o1.toString();
                String s2 = o2.toString();
                return s1.compareTo(s2);
            }
        });
        this._table = new GenericTable(this._model){

            public void setRowSorter(RowSorter<? extends TableModel> sorter) {
                super.setRowSorter((RowSorter)caseSensitiveSorter);
            }
        };
        this._table.setRowSorter(caseSensitiveSorter);
        this._spTable = new JScrollPane((Component)this._table);
        this._lblHeader.setHorizontalAlignment(0);
        this._lblHeader.setText(ViewersArb.getString((int)2));
        this._spTable.setBorder(null);
        this._table.setAutoResizeMode(0);
        this._table.setDefaultRenderer(Date.class, (TableCellRenderer)new GenericTableCellRenderer((TableCellRenderer)new DateRenderer()));
        this._table.setDefaultRenderer(Integer.class, (TableCellRenderer)new GenericTableCellRenderer((TableCellRenderer)new SizeRenderer()));
        this._table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    URL jarFileURL = URLFactory.newFileURL((File)JarViewerContentPanel.this._jarNode.getFile());
                    int row = JarViewerContentPanel.this._table.getSelectedRow();
                    row = JarViewerContentPanel.this._table.convertRowIndexToModel(row);
                    String entryName = (String)JarViewerContentPanel.this._table.getModel().getValueAt(row, 0);
                    URL url = URLFactory.newJarURL((URL)jarFileURL, (String)entryName);
                    JarViewerContentPanel.openEditor(url);
                    e.consume();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this._lblHeader, "Center");
    }

    void setNode(JarNode jarNode) {
        if (this._jarNode != jarNode) {
            if (this._jarNode != null) {
                JarUtil.releaseJarIndex((URL)this._jarNode.getURL());
            }
            this._jarNode = jarNode;
            this.updateTable();
        }
    }

    private void updateTable() {
        final JarNode jarNode = this._jarNode;
        SwingWorker<ArrayList, Object> worker = new SwingWorker<ArrayList, Object>(){

            @Override
            public ArrayList doInBackground() {
                return this.getTableData(jarNode);
            }

            @Override
            public void done() {
                JarViewerContentPanel panel = JarViewerContentPanel.this;
                try {
                    ArrayList rows = (ArrayList)this.get();
                    JarViewerContentPanel.this._model.setData(rows);
                    JarViewerContentPanel.this._table.setSortColumn(0, true);
                }
                catch (Exception ex) {
                    JarViewerContentPanel.this._model.setData(new ArrayList(0));
                }
                JarViewerContentPanel.this._spTable.setSize(panel.getSize());
                JarViewerContentPanel.this._table.autoSizeColumnsToFit();
                JarViewerContentPanel.this.remove(JarViewerContentPanel.this._lblHeader);
                JarViewerContentPanel.this.add((Component)JarViewerContentPanel.this._spTable, "Center");
                String name = JarViewerContentPanel.this._lblHeader.getName();
                if (name != null) {
                    JarViewerContentPanel.this._table.setName(name);
                }
            }

            private ArrayList getTableData(JarNode jarNode2) {
                try {
                    final ArrayList rows = new ArrayList();
                    URL jarFileURL = URLFactory.newFileURL((File)jarNode2.getFile());
                    final JarIndex jarIndex = JarUtil.getJarIndex((URL)jarFileURL);
                    jarIndex.visit(new JarIndex.Visitor(){

                        public boolean visit(JarIndexEntry entry) {
                            String entryName = entry.getName();
                            if (!entryName.endsWith("/")) {
                                ArrayList<Object> row = new ArrayList<Object>();
                                row.add(entryName);
                                row.add(entry.getTime());
                                row.add(new Long(entry.getSize()));
                                row.add(new Long(jarIndex.getCompressedSize(entryName)));
                                rows.add(row);
                            }
                            return true;
                        }
                    });
                    return rows;
                }
                catch (Exception ex) {
                    Assert.printStackTrace();
                    return new ArrayList(0);
                }
            }
        };
        worker.execute();
    }

    private static void openEditor(URL url) {
        Node node = NodeFactory.find((URL)url);
        if (node != null && node.isOpen()) {
            NodeUtil.reloadBuffers(Collections.singletonList(node), (boolean)true);
        }
        EditorManager.getEditorManager().openDefaultEditorInFrame(url);
    }

    private static String getDisplaySize(long bytes) {
        StringBuffer buffer = new StringBuffer();
        if (bytes < 1024L) {
            buffer.append(TWO_DP_FORMAT.format(bytes));
            buffer.append(" bytes");
        } else if (bytes >= 1024L && bytes < 0x100000L) {
            buffer.append(TWO_DP_FORMAT.format((double)bytes / 1024.0));
            buffer.append(" KB");
        } else if (bytes >= 0x100000L && bytes < 0x40000000L) {
            buffer.append(TWO_DP_FORMAT.format((double)bytes / 1048567.0));
            buffer.append(" MB");
        } else {
            buffer.append(TWO_DP_FORMAT.format((double)bytes / 1.073741824E9));
            buffer.append(" GB");
        }
        return buffer.toString();
    }

    static {
        TWO_DP_FORMAT.setMaximumFractionDigits(2);
        TWO_DP_FORMAT.setMinimumFractionDigits(2);
        TWO_DP_FORMAT.setParseIntegerOnly(false);
    }

    private class DateRenderer
    extends DefaultTableCellRenderer {
        final SimpleDateFormat _sdf = new SimpleDateFormat();

        private DateRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable t, Object value, boolean selected, boolean focus, int column, int row) {
            Component c = super.getTableCellRendererComponent(t, value, selected, focus, column, row);
            if (value != null) {
                this.setText(this._sdf.format((Date)value));
            }
            return c;
        }
    }

    private class SizeRenderer
    extends DefaultTableCellRenderer {
        NumberFormat _defaultFormat = NumberFormat.getInstance();

        private SizeRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable t, Object value, boolean selected, boolean focus, int column, int row) {
            Component c = super.getTableCellRendererComponent(t, value, selected, focus, column, row);
            long i = (Long)value;
            if (i < 1024L) {
                this.setText(this._defaultFormat.format(i));
            } else {
                this.setText(JarViewerContentPanel.getDisplaySize((Long)value));
            }
            return c;
        }
    }
}

