/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.util.ArrayList;
import java.util.Enumeration;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.View;
import oracle.help.common.navigator.BaseNavigator;
import oracle.help.library.Book;
import oracle.help.library.LibraryEvent;
import oracle.help.navigator.NavigatorEvent;
import oracle.help.navigator.NavigatorListener;

public class NavigatorHelper {
    public static final void libraryChanged(LibraryEvent e, BaseNavigator navigator, boolean filterByLabel, String label, ArrayList views) {
        block8: {
            if (e == null) break block8;
            View[] viewArr = null;
            Book book = e.getBook();
            if (book != null) {
                viewArr = book.getViewsByType(navigator.getType());
                if (filterByLabel) {
                    viewArr = NavigatorHelper.filterViewsByLabel(viewArr, label);
                }
            }
            if (viewArr != null) {
                if (e.getID() == 2001) {
                    for (int iter = 0; iter < viewArr.length; ++iter) {
                        if (views.contains(viewArr[iter])) continue;
                        views.add(viewArr[iter]);
                        navigator.addView(viewArr[iter]);
                    }
                } else if (e.getID() == 2002) {
                    for (int iter = 0; iter < viewArr.length; ++iter) {
                        if (!views.contains(viewArr[iter])) continue;
                        views.remove(viewArr[iter]);
                        navigator.removeView(viewArr[iter]);
                    }
                }
            }
        }
    }

    public static final View[] filterViewsByLabel(View[] views, String label) {
        View[] result = null;
        ArrayList<View> filtered = new ArrayList<View>();
        if (views == null) {
            return views;
        }
        for (int iter = 0; iter < views.length; ++iter) {
            View aView = views[iter];
            if (aView == null) continue;
            if (label != null) {
                if (!label.equals(aView.getLabel())) continue;
                filtered.add(aView);
                continue;
            }
            if (aView.getLabel() != null) continue;
            filtered.add(aView);
        }
        if (filtered.size() > 0) {
            result = new View[filtered.size()];
            filtered.toArray(result);
        }
        return result;
    }

    public static final void fireNavigatorEvent(NavigatorEvent event, ListenerManager listeners) {
        Enumeration listenEnum = listeners.getListeners();
        if (listenEnum != null) {
            while (listenEnum.hasMoreElements()) {
                NavigatorListener l = (NavigatorListener)listenEnum.nextElement();
                if (event.getID() == 2000) {
                    l.topicSelected(event);
                    continue;
                }
                l.topicActivated(event);
            }
        }
    }
}

