/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Component;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayModelCache;
import oracle.dbtools.raptor.controls.display.DisplaySimpleChart;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;

public class GraphContextMenuListener
implements ContextMenuListener {
    JMenu reports = null;
    JMenu auto = null;
    private DisplaySimpleChart _display;
    private List<ObjectAction> _actions;
    private static GraphContextMenuListener _instance = null;
    boolean showA;
    private HashMap<String, myMenu> menus = new HashMap();

    private GraphContextMenuListener() {
    }

    public void setDisplay(DisplaySimpleChart displaySimpleChart) {
        this._display = displaySimpleChart;
    }

    public static GraphContextMenuListener getInstance() {
        if (_instance == null) {
            _instance = new GraphContextMenuListener();
        }
        return _instance;
    }

    public void setActions(List<ObjectAction> list) {
        this._actions = list;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        this.reports = contextMenu.createMenu(Messages.getString("DisplaySimpleChart.35"), (float)StringUtils.getMnemonicKeyCode((String)"Reports"));
        this.showA = false;
        if (this._display.getBinds().size() > 0) {
            Object object;
            contextMenu.getContext().setProperty("ObjectAction.EVENT", (Object)contextMenu.getContext().getEvent());
            contextMenu.getContext().setProperty("ObjectAction.TARGET.KEY", (Object)this._display);
            contextMenu.getContext().setProperty("ObjectAction.CONN_NAME", (Object)this._display.getConnName());
            if (this._actions != null) {
                object = this._actions.iterator();
                while (object.hasNext()) {
                    ObjectAction objectAction = (ObjectAction)((Object)object.next());
                    JMenuItem jMenuItem = objectAction.getMenuItem(contextMenu);
                    objectAction.putProperty("CONTEXT", contextMenu.getContext());
                    objectAction.putProperty("ACTION_TYPE", "REPORT");
                    this.reports.add(jMenuItem);
                    this.showA = true;
                }
            }
            if ((object = System.getProperty("sqldev.autoreport")) != null && ((String)object).equals("TRUE")) {
                this.getDrillableReports(contextMenu);
            } else if (this.showA) {
                this.reports.add(this.reports);
                contextMenu.add((Component)this.reports);
            }
        }
    }

    private JMenu processPath(String string) {
        String[] stringArray = string.split("/");
        String string2 = "";
        myMenu myMenu2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = string2;
            myMenu2 = this.menus.get(string2 = string2 + "/" + stringArray[i]);
            if (myMenu2 != null) continue;
            myMenu2 = new myMenu(i, new JMenu(stringArray[i]));
            if (i > 0) {
                this.menus.get(string3).getMenu().add(myMenu2.getMenu());
            }
            this.menus.put(string2, myMenu2);
        }
        return myMenu2.getMenu();
    }

    private void addRootMenus(JMenu jMenu) {
        for (String string : this.menus.keySet()) {
            if (this.menus.get(string).getDepth() != 0) continue;
            jMenu.add(this.menus.get(string).getMenu());
        }
    }

    public void getDrillableReports(ContextMenu contextMenu) {
        ArrayList<String> arrayList = DisplayModelCache.getIds();
        Map<String, Object> map = this._display.getBinds();
        this.auto = contextMenu.createMenu("Auto Reports", (float)StringUtils.getMnemonicKeyCode((String)"Auto Reports"));
        boolean bl = false;
        for (String string : arrayList) {
            DisplayModel displayModel = DisplayModelCache.getDisplayModel(string);
            Query query = displayModel.getQueries() == null ? null : QueryUtils.getQuery((List)displayModel.getQueries(), (ConnectionIdentifier)DefaultConnectionIdentifier.createIdentifier((Connection)this._display.getConnection()));
            if (query == null) continue;
            List list = query.getBinds();
            boolean bl2 = query.getBinds().size() > 0;
            for (Bind bind : list) {
                if (map.containsKey(bind.getName())) continue;
                bl2 = false;
            }
            if (!bl2) continue;
            ObjectAction objectAction = new ObjectAction();
            objectAction.setClassName("oracle.dbtools.raptor.report.addin.DrillReportAction", this.getClass().getClassLoader());
            objectAction.setClassArgs(string);
            objectAction.setTitle(displayModel.getName());
            int n = displayModel.getPath().lastIndexOf(displayModel.getName()) - 1;
            String string2 = displayModel.getPath().substring(0, n);
            JMenu jMenu = this.processPath(string2);
            JMenuItem jMenuItem = objectAction.getMenuItem(contextMenu);
            objectAction.putProperty("CONTEXT", contextMenu.getContext());
            objectAction.putProperty("ACTION_TYPE", "REPORT");
            jMenu.add(jMenuItem);
            bl = true;
        }
        if (bl) {
            this.addRootMenus(this.auto);
            this.reports.add(this.auto);
        }
        if (this.showA || bl) {
            contextMenu.add((Component)this.reports);
        }
    }

    private class myMenu {
        int _depth;
        JMenu _menu;

        public myMenu(int n, JMenu jMenu) {
            this._menu = jMenu;
            this._depth = n;
        }

        public JMenu getMenu() {
            return this._menu;
        }

        public int getDepth() {
            return this._depth;
        }
    }
}

