/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.util.BitSet;
import java.util.HashMap;
import oracle.dbtools.raptor.controls.display.chart.ChartArb;
import oracle.dbtools.raptor.controls.display.chart.EnumProperty;

public enum ChartType implements EnumProperty
{
    BAR_VERT_CLUST(ChartArb.getString("CHART_TYPE_BAR_VERT_CLUST"), 17),
    BAR_VERT_CLUST2Y(ChartArb.getString("CHART_TYPE_BAR_VERT_CLUST2Y"), 19),
    BAR_VERT_CLUST_SPLIT2Y(ChartArb.getString("CHART_TYPE_BAR_VERT_CLUST_SPLIT2Y"), 21),
    BAR_VERT_PERCENT(ChartArb.getString("CHART_TYPE_BAR_VERT_PERCENT"), 23),
    BAR_VERT_STACK(ChartArb.getString("CHART_TYPE_BAR_VERT_STACK"), 18),
    BAR_VERT_STACK2Y(ChartArb.getString("CHART_TYPE_BAR_VERT_STACK2Y"), 20),
    BAR_VERT_STACK_SPLIT2Y(ChartArb.getString("CHART_TYPE_BAR_VERT_STACK_SPLIT2Y"), 22),
    BAR_VERT_FLOAT_STACK(ChartArb.getString("CHART_TYPE_BAR_VERT_FLOAT_STACK"), 95),
    BAR_HORIZ_CLUST(ChartArb.getString("CHART_TYPE_BAR_HORIZ_CLUST"), 24),
    BAR_HORIZ_CLUST_2Y(ChartArb.getString("CHART_TYPE_BAR_HORIZ_CLUST_2Y"), 26),
    BAR_HORIZ_CLUST_SPLIT2Y(ChartArb.getString("CHART_TYPE_BAR_HORIZ_CLUST_SPLIT2Y"), 28),
    BAR_HORIZ_PERCENT(ChartArb.getString("CHART_TYPE_BAR_HORIZ_PERCENT"), 30),
    BAR_HORIZ_STACK(ChartArb.getString("CHART_TYPE_BAR_HORIZ_STACK"), 25),
    BAR_HORIZ_STACK_2Y(ChartArb.getString("CHART_TYPE_BAR_HORIZ_STACK_2Y"), 27),
    BAR_HORIZ_STACK_SPLIT2Y(ChartArb.getString("CHART_TYPE_BAR_HORIZ_STACK_SPLIT2Y"), 29),
    PIE(ChartArb.getString("CHART_TYPE_PIE"), 55),
    PIE_MULTI(ChartArb.getString("CHART_TYPE_PIE_MULTI"), 57),
    PIE_BAR(ChartArb.getString("CHART_TYPE_PIE_BAR"), 93),
    RING(ChartArb.getString("CHART_TYPE_RING"), 56),
    RING_MULTI(ChartArb.getString("CHART_TYPE_RING_MULTI"), 58),
    RING_BAR(ChartArb.getString("CHART_TYPE_RING_BAR"), 94),
    LINE_VERT_ABS(ChartArb.getString("CHART_TYPE_LINE_VERT_ABS"), 41),
    LINE_VERT_ABS_2Y(ChartArb.getString("CHART_TYPE_LINE_VERT_ABS_2Y"), 43),
    LINE_VERT_ABS_SPLIT2Y(ChartArb.getString("CHART_TYPE_LINE_VERT_ABS_SPLIT2Y"), 45),
    LINE_VERT_PERCENT(ChartArb.getString("CHART_TYPE_LINE_VERT_PERCENT"), 47),
    LINE_VERT_STACK(ChartArb.getString("CHART_TYPE_LINE_VERT_STACK"), 42),
    LINE_VERT_STACK_2Y(ChartArb.getString("CHART_TYPE_LINE_VERT_STACK_2Y"), 44),
    LINE_VERT_STACK_SPLIT2Y(ChartArb.getString("CHART_TYPE_LINE_VERT_STACK_SPLIT2Y"), 46),
    AREA_VERT_ABS(ChartArb.getString("CHART_TYPE_AREA_VERT_ABS"), 31),
    AREA_VERT_STACK(ChartArb.getString("CHART_TYPE_AREA_VERT_STACK"), 32),
    AREA_VERT_PERCENT(ChartArb.getString("CHART_TYPE_AREA_VERT_PERCENT"), 35),
    AREA_VERT_ABS_SPLIT2Y(ChartArb.getString("CHART_TYPE_AREA_VERT_ABS_SPLIT2Y"), 33),
    AREA_VERT_STACK_SPLIT2Y(ChartArb.getString("CHART_TYPE_AREA_VERT_STACK_SPLIT2Y"), 34),
    COMBINATION_VERT_ABS(ChartArb.getString("CHART_TYPE_COMBINATION_VERT_ABS"), 97),
    COMBINATION_VERT_ABS_2Y(ChartArb.getString("CHART_TYPE_COMBINATION_VERT_ABS_2Y"), 98),
    SCATTER(ChartArb.getString("CHART_TYPE_SCATTER"), 61),
    SCATTER_2Y(ChartArb.getString("CHART_TYPE_SCATTER_2Y"), 62),
    BUBBLE(ChartArb.getString("CHART_TYPE_BUBBLE"), 89),
    BUBBLE_2Y(ChartArb.getString("CHART_TYPE_BUBBLE_2Y"), 91),
    STOCK_HLC(ChartArb.getString("CHART_TYPE_STOCK_HLC"), 76),
    STOCK_OHLC(ChartArb.getString("CHART_TYPE_STOCK_OHLC"), 79),
    STOCK_HLC_VOLUME(ChartArb.getString("CHART_TYPE_STOCK_HLC_VOLUME"), 88),
    STOCK_OHLC_VOLUME(ChartArb.getString("CHART_TYPE_STOCK_OHLC_VOLUME"), 83),
    STOCK_OC_CANDLE(ChartArb.getString("CHART_TYPE_STOCK_OC_CANDLE"), 72),
    STOCK_OHLC_CANDLE(ChartArb.getString("CHART_TYPE_STOCK_OHLC_CANDLE"), 70),
    STOCK_OC_CANDLE_VOLUME(ChartArb.getString("CHART_TYPE_STOCK_OC_CANDLE_VOLUME"), 84),
    STOCK_OHLC_CANDLE_VOLUME(ChartArb.getString("CHART_TYPE_STOCK_OHLC_CANDLE_VOLUME"), 71),
    POLAR(ChartArb.getString("CHART_TYPE_POLAR"), 65),
    RADAR(ChartArb.getString("CHART_TYPE_RADAR"), 67),
    PARETO(ChartArb.getString("CHART_TYPE_PARETO"), 96),
    FUNNEL(ChartArb.getString("CHART_TYPE_FUNNEL"), 100),
    THREED_BAR(ChartArb.getString("CHART_TYPE_THREED_BAR"), 0),
    THREED_CUBE(ChartArb.getString("CHART_TYPE_THREED_CUBE"), 4),
    THREED_AREA(ChartArb.getString("CHART_TYPE_THREED_AREA"), 6),
    THREED_RIBBON(ChartArb.getString("CHART_TYPE_THREED_RIBBON"), 7),
    THREED_SURFACE(ChartArb.getString("CHART_TYPE_THREED_SURFACE"), 12);

    private int graphType;
    private String nls;
    private static HashMap<Integer, ChartType> graphTypeLookup;

    private ChartType(String string2, int n2) {
        this.graphType = n2;
        this.nls = string2;
    }

    public int typeNo() {
        return this.ordinal();
    }

    public int graphType() {
        return this.graphType;
    }

    public String nls() {
        return this.nls;
    }

    @Override
    public Object label() {
        return this.nls;
    }

    public boolean isInSet(BitSet bitSet) {
        return bitSet.get(this.typeNo());
    }

    public static int numTypes() {
        return THREED_SURFACE.ordinal() + 1;
    }

    public static int firstVBar() {
        return BAR_VERT_CLUST.ordinal();
    }

    public static int lastVBar() {
        return BAR_VERT_FLOAT_STACK.ordinal();
    }

    public static int firstHBar() {
        return BAR_HORIZ_CLUST.ordinal();
    }

    public static int lastHBar() {
        return BAR_HORIZ_STACK_SPLIT2Y.ordinal();
    }

    public static int firstPie() {
        return PIE.ordinal();
    }

    public static int lastPie() {
        return RING_BAR.ordinal();
    }

    public static int firstLine() {
        return LINE_VERT_ABS.ordinal();
    }

    public static int lastLine() {
        return LINE_VERT_STACK_SPLIT2Y.ordinal();
    }

    public static int firstArea() {
        return AREA_VERT_ABS.ordinal();
    }

    public static int lastArea() {
        return AREA_VERT_STACK_SPLIT2Y.ordinal();
    }

    public static int firstCombination() {
        return COMBINATION_VERT_ABS.ordinal();
    }

    public static int lastCombination() {
        return COMBINATION_VERT_ABS_2Y.ordinal();
    }

    public static int firstScatter() {
        return SCATTER.ordinal();
    }

    public static int lastScatter() {
        return SCATTER_2Y.ordinal();
    }

    public static int firstBubble() {
        return BUBBLE.ordinal();
    }

    public static int lastBubble() {
        return BUBBLE_2Y.ordinal();
    }

    public static int firstStock() {
        return STOCK_HLC.ordinal();
    }

    public static int lastStock() {
        return STOCK_OHLC_CANDLE_VOLUME.ordinal();
    }

    public static int firstPolar() {
        return POLAR.ordinal();
    }

    public static int lastPolar() {
        return POLAR.ordinal();
    }

    public static int firstRadar() {
        return RADAR.ordinal();
    }

    public static int lastRadar() {
        return RADAR.ordinal();
    }

    public static int firstPareto() {
        return PARETO.ordinal();
    }

    public static int lastPareto() {
        return PARETO.ordinal();
    }

    public static int firstFunnel() {
        return FUNNEL.ordinal();
    }

    public static int lastFunnel() {
        return FUNNEL.ordinal();
    }

    public static int firstThreeD() {
        return THREED_BAR.ordinal();
    }

    public static int lastThreeD() {
        return THREED_SURFACE.ordinal();
    }

    public static BitSet all() {
        BitSet bitSet = new BitSet(ChartType.numTypes());
        bitSet.set(0, ChartType.numTypes());
        return bitSet;
    }

    public static BitSet none() {
        BitSet bitSet = new BitSet(ChartType.numTypes());
        return bitSet;
    }

    public static BitSet vBars() {
        BitSet bitSet = new BitSet(ChartType.numTypes());
        bitSet.set(ChartType.firstVBar(), ChartType.lastVBar() + 1);
        return bitSet;
    }

    public static BitSet hBars() {
        BitSet bitSet = new BitSet(ChartType.numTypes());
        bitSet.set(ChartType.firstHBar(), ChartType.lastHBar() + 1);
        return bitSet;
    }

    public static BitSet pies() {
        BitSet bitSet = new BitSet(ChartType.numTypes());
        bitSet.set(ChartType.firstPie(), ChartType.lastPie() + 1);
        return bitSet;
    }

    public static BitSet lines() {
        BitSet bitSet = new BitSet(ChartType.numTypes());
        bitSet.set(ChartType.firstLine(), ChartType.lastLine() + 1);
        return bitSet;
    }

    public static BitSet areas() {
        BitSet bitSet = new BitSet(ChartType.numTypes());
        bitSet.set(ChartType.firstArea(), ChartType.lastArea() + 1);
        return bitSet;
    }

    public static BitSet combinations() {
        BitSet bitSet = new BitSet(ChartType.numTypes());
        bitSet.set(ChartType.firstCombination(), ChartType.lastCombination() + 1);
        return bitSet;
    }

    public static BitSet scatters() {
        BitSet bitSet = new BitSet(ChartType.numTypes());
        bitSet.set(ChartType.firstScatter(), ChartType.lastScatter() + 1);
        return bitSet;
    }

    public static BitSet bubbles() {
        BitSet bitSet = new BitSet(ChartType.numTypes());
        bitSet.set(ChartType.firstBubble(), ChartType.lastBubble() + 1);
        return bitSet;
    }

    public static BitSet stocks() {
        BitSet bitSet = new BitSet(ChartType.numTypes());
        bitSet.set(ChartType.firstStock(), ChartType.lastStock() + 1);
        return bitSet;
    }

    public static BitSet polars() {
        BitSet bitSet = new BitSet(ChartType.numTypes());
        bitSet.set(ChartType.firstPolar(), ChartType.lastPolar() + 1);
        return bitSet;
    }

    public static BitSet radars() {
        BitSet bitSet = new BitSet(ChartType.numTypes());
        bitSet.set(ChartType.firstRadar(), ChartType.lastRadar() + 1);
        return bitSet;
    }

    public static BitSet paretos() {
        BitSet bitSet = new BitSet(ChartType.numTypes());
        bitSet.set(ChartType.firstPareto(), ChartType.lastPareto() + 1);
        return bitSet;
    }

    public static BitSet funnels() {
        BitSet bitSet = new BitSet(ChartType.numTypes());
        bitSet.set(ChartType.firstFunnel(), ChartType.lastFunnel() + 1);
        return bitSet;
    }

    public static BitSet threeDs() {
        BitSet bitSet = new BitSet(ChartType.numTypes());
        bitSet.set(ChartType.firstThreeD(), ChartType.lastThreeD() + 1);
        return bitSet;
    }

    public static BitSet stacked() {
        BitSet bitSet = new BitSet(ChartType.numTypes());
        bitSet.set(BAR_VERT_STACK.ordinal());
        bitSet.set(BAR_VERT_STACK2Y.ordinal());
        bitSet.set(BAR_VERT_STACK_SPLIT2Y.ordinal());
        bitSet.set(BAR_VERT_FLOAT_STACK.ordinal());
        bitSet.set(BAR_HORIZ_STACK.ordinal());
        bitSet.set(BAR_HORIZ_STACK_2Y.ordinal());
        bitSet.set(BAR_HORIZ_STACK_SPLIT2Y.ordinal());
        bitSet.set(LINE_VERT_STACK.ordinal());
        bitSet.set(LINE_VERT_STACK_2Y.ordinal());
        bitSet.set(LINE_VERT_STACK_SPLIT2Y.ordinal());
        bitSet.set(AREA_VERT_STACK.ordinal());
        return bitSet;
    }

    public static BitSet dualYs() {
        BitSet bitSet = new BitSet(ChartType.numTypes());
        bitSet.set(BAR_VERT_CLUST2Y.ordinal());
        bitSet.set(BAR_VERT_CLUST_SPLIT2Y.ordinal());
        bitSet.set(BAR_VERT_STACK2Y.ordinal());
        bitSet.set(BAR_VERT_STACK_SPLIT2Y.ordinal());
        bitSet.set(BAR_HORIZ_CLUST_2Y.ordinal());
        bitSet.set(BAR_HORIZ_CLUST_SPLIT2Y.ordinal());
        bitSet.set(BAR_HORIZ_STACK_2Y.ordinal());
        bitSet.set(BAR_HORIZ_STACK_SPLIT2Y.ordinal());
        bitSet.set(LINE_VERT_ABS_2Y.ordinal());
        bitSet.set(LINE_VERT_ABS_SPLIT2Y.ordinal());
        bitSet.set(LINE_VERT_STACK_2Y.ordinal());
        bitSet.set(LINE_VERT_STACK_SPLIT2Y.ordinal());
        bitSet.set(AREA_VERT_ABS_SPLIT2Y.ordinal());
        bitSet.set(AREA_VERT_STACK_SPLIT2Y.ordinal());
        bitSet.set(COMBINATION_VERT_ABS_2Y.ordinal());
        bitSet.set(SCATTER_2Y.ordinal());
        bitSet.set(BUBBLE_2Y.ordinal());
        return bitSet;
    }

    public static ChartType get(int n) {
        if (graphTypeLookup == null) {
            graphTypeLookup = new HashMap();
            for (ChartType chartType : ChartType.values()) {
                graphTypeLookup.put(chartType.graphType(), chartType);
            }
        }
        return graphTypeLookup.get(n);
    }
}

