/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.core;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.readers.DataReadable;
import oracle.dbtools.raptor.data.readers.DataReaderException;
import oracle.dbtools.raptor.data.readers.DataReaderRegistry;
import oracle.dbtools.raptor.data.ui.ConfigException;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.format.IFormatOptions;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportXMLUtil {
    private static String _term = "\n";
    Boolean _import = false;
    boolean _isLoaded = false;
    private DOMParser _parser;
    boolean _cancel = false;
    private ImportDataFormat _dataFormat;
    GenericTable _table;
    private ImportProperties _iProps;
    private String _rootNodeName;
    private OutputStreamWriter _out;
    private DataReadable _datareader;
    private DataPreviewGizmo _dataGizmo;

    private DOMParser getParser() {
        if (this._parser == null) {
            this._parser = new DOMParser();
        } else {
            this._parser.reset();
        }
        return this._parser;
    }

    public void parseXML(InputStreamReader inputStreamReader, boolean bl, String string) {
        DOMParser dOMParser = this.getParser();
        dOMParser.setPreserveWhitespace(false);
        this._iProps = new ImportProperties();
        try {
            dOMParser.parse((Reader)inputStreamReader);
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        this.processNode((Node)xMLDocument, bl);
        this._isLoaded = true;
    }

    public void parseXML(InputStreamReader inputStreamReader, boolean bl) {
        DOMParser dOMParser = this.getParser();
        dOMParser.setPreserveWhitespace(false);
        this._iProps = new ImportProperties();
        try {
            dOMParser.parse((Reader)inputStreamReader);
            XMLDocument xMLDocument = dOMParser.getDocument();
            this.processNode((Node)xMLDocument, bl);
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        this._isLoaded = true;
    }

    public String getNodeValue(Node node, XML_KEYS xML_KEYS) {
        return XMLHelper.getNodeValue((Node)node, (String)xML_KEYS.toString());
    }

    public String getNodeValue(Node node, ImportKeys importKeys) {
        return XMLHelper.getNodeValue((Node)node, (String)importKeys.toString());
    }

    public ImportProperties getProperties() {
        return this._iProps;
    }

    public String getPropertyValue(ImportKeys importKeys) {
        return (String)this._iProps.get(importKeys);
    }

    public int getPropertyValueInt(ImportKeys importKeys) {
        return (Integer)this._iProps.get(importKeys);
    }

    public boolean getPropertyValueBoolean(ImportKeys importKeys) {
        return (Boolean)this._iProps.get(importKeys);
    }

    public Object getPropertyValueObject(ImportKeys importKeys) {
        return this._iProps.get(importKeys);
    }

    public String getTool() {
        return this._rootNodeName;
    }

    private void processNode(Node node, boolean bl) {
        NodeList nodeList = node.getChildNodes();
        if (this._rootNodeName == null) {
            this._rootNodeName = nodeList.item(0).getNodeName();
            if (!nodeList.item(0).getNodeName().equals(XML_KEYS.IMPORT_TOOL.toString())) {
                return;
            }
        }
        for (int i = 0; i < nodeList.getLength() && !this._cancel; ++i) {
            if (nodeList.item(i).getNodeName().equalsIgnoreCase(ImportKeys.DBOBJECT.toString())) {
                this.processDbObject(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.CONNECTION_SETTINGS.toString())) {
                this.processConnection(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.FILE_SETTINGS.toString())) {
                this.processFileObject(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase(ImportKeys.IMPORT_DATA_FORMAT.toString())) {
                this.processDataFormat(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.FILE_FIELDS.toString())) {
                this.processFileFields(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase(ImportKeys.FILE_COLUMNS.toString())) {
                this.processFileColumns(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase(ImportKeys.TABLE_COLUMNS.toString())) {
                this.processTableColumns(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase(ImportKeys.SELECTED_COLUMNS.toString())) {
                this.processSelectedColumns(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase(ImportKeys.SELECTABLE_COLUMNS.toString())) {
                this.processSelectableColumns(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.LOAD_METHOD_SETTINGS.toString())) {
                this.processLoadMethod(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.MATCH.toString())) {
                this.processMatch(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.EXTERNAL_OPTIONS_SETTINGS.toString())) {
                this.processExternalOptions(nodeList.item(i), bl);
                continue;
            }
            if (!nodeList.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.IMPORT_TOOL.toString())) continue;
            this.processNode(nodeList.item(i), bl);
        }
    }

    private void processConnection(Node node, boolean bl) {
        if (node != null) {
            this._iProps.put(ImportKeys.CONNECTION_NAME, this.notNull(this.getNodeValue(node, ImportKeys.CONNECTION_NAME)));
            this._iProps.put(ImportKeys.CONNECTION_USER, this.notNull(this.getNodeValue(node, ImportKeys.CONNECTION_USER)));
        }
    }

    public void processDbObject(Node node, boolean bl) {
        if (node != null) {
            String string = this.notNull(this.getNodeValue(node, ImportKeys.OBJECT_CONNECTION));
            String string2 = this.notNull(this.getNodeValue(node, ImportKeys.OBJECT_TYPE));
            String string3 = this.notNull(this.getNodeValue(node, ImportKeys.OBJECT_SCHEMA));
            String string4 = this.notNull(this.getNodeValue(node, ImportKeys.OBJECT_NAME));
            URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string, null, string3, string2);
            URL uRL2 = DBURLFormatHelper.getURL(uRL, string4);
            DBObject dBObject = new DBObject(uRL2);
            this._iProps.put(ImportKeys.DBOBJECT, dBObject);
        }
    }

    public void processFileObject(Node node, boolean bl) {
        if (node != null) {
            this._iProps.put(ImportKeys.FILE_PATH, this.notNull(this.getNodeValue(node, ImportKeys.FILE_PATH)));
            LoadFile loadFile = new LoadFile(this.notNull(this.getNodeValue(node, ImportKeys.FILE_PATH)));
            this._iProps.put(ImportKeys.LOAD_FILE, loadFile);
        }
    }

    public void processDataFormat(Node node, boolean bl) {
        if (node != null) {
            this._dataFormat = new ImportDataFormat(BaseDataFormat.IMPORT_WIZARD, this.notNull(this.getNodeValue(node, ImportKeys.DATA_FORMAT)));
            this._dataFormat.setEncoding(this.notNull(this.getNodeValue(node, ImportKeys.ENCODING)));
            this._dataFormat.setUsePreviewLimit(this.convertBoolean(this.getNodeValue(node, ImportKeys.USE_PREVIEW_LIMIT)));
            this._dataFormat.setPreviewLimit(this.convertPosInt(this.getNodeValue(node, ImportKeys.PREVIEW_LIMIT)));
            this._dataFormat.setUseMaxLength(this.convertBoolean(this.getNodeValue(node, ImportKeys.USE_MAX_LENGTH)));
            this._dataFormat.setMaxLength(this.convertPosInt(this.getNodeValue(node, ImportKeys.MAX_LENGTH)));
            this._dataFormat.setPageId(this.convertPosInt(this.getNodeValue(node, ImportKeys.PAGEID)));
            this._dataFormat.setWorksheet(this.notNull(this.getNodeValue(node, ImportKeys.WORKSHEET_NAME)));
            IFormatOptions iFormatOptions = this._dataFormat.getOptions();
            if (iFormatOptions.isHeaderOptionSupported()) {
                this._dataFormat.isHeader(this.convertBoolean(this.getNodeValue(node, ImportKeys.IS_HEADER)));
                this._dataFormat.setHeaderLocation(this.convertPosInt(this.getNodeValue(node, ImportKeys.HEADER_LOCATION)));
            }
            this._dataFormat.setSkipRows(this.convertPosInt(this.getNodeValue(node, ImportKeys.SKIP_ROWS)));
            if (iFormatOptions.isDelimiterSupported() && iFormatOptions.isDelimiterConfigurable()) {
                this._dataFormat.setDelimiter(this.notNull(this.getNodeValue(node, ImportKeys.DELIMITER)));
            }
            if (iFormatOptions.isEnclosuresSupported()) {
                this._dataFormat.setEnclosureLeft(ImportDataFormat.getEnclosureFromConfigValue(this.notNull(this.getNodeValue(node, ImportKeys.ENCLOSURE_LEFT))));
                this._dataFormat.setEnclosureRight(ImportDataFormat.getEnclosureFromConfigValue(this.notNull(this.getNodeValue(node, ImportKeys.ENCLOSURE_RIGHT))));
                this._dataFormat.isEnclosureRightDouble(this.convertBoolean(this.getNodeValue(node, ImportKeys.IS_ENCLOSURE_RIGHT_DOUBLE)));
            }
            if (iFormatOptions.isLineTerminatorSupported()) {
                this._dataFormat.setRecordTerminator(ImportDataFormat.getRecordTerminatorFromConfigValue(this.notNull(this.getNodeValue(node, ImportKeys.RECORD_TERMINATOR))));
            }
            this._iProps.put(ImportKeys.IMPORT_DATA_FORMAT, this._dataFormat);
        }
    }

    public void processFileFields(Node node, boolean bl) {
        ((LoadFile)this._iProps.get(ImportKeys.LOAD_FILE)).setFields(this.getFields(node.getChildNodes()));
    }

    public void processFileColumns(Node node, boolean bl) {
        this._iProps.put(ImportKeys.FILE_COLUMNS, this.getColumns(node.getChildNodes()));
    }

    public void processTableColumns(Node node, boolean bl) {
        this._iProps.put(ImportKeys.TABLE_COLUMNS, this.getColumns(node.getChildNodes()));
    }

    public void processSelectedColumns(Node node, boolean bl) {
        this._iProps.put(ImportKeys.SELECTED_COLUMNS, this.getColumnsFromReference(node.getChildNodes()));
    }

    public void processSelectableColumns(Node node, boolean bl) {
        this._iProps.put(ImportKeys.SELECTABLE_COLUMNS, this.getColumnsFromReference(node.getChildNodes()));
    }

    private LoadField[] getFields(NodeList nodeList) {
        LoadField[] loadFieldArray = new LoadField[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength() && !this._cancel; ++i) {
            if (!nodeList.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.FIELD.toString())) continue;
            LoadField loadField = new LoadField();
            loadField.setName(this.notNull(this.getNodeValue(nodeList.item(i), XML_KEYS.FIELD_NAME)));
            loadField.setLength(Integer.parseInt(this.notNull(this.getNodeValue(nodeList.item(i), XML_KEYS.FIELD_LENGTH))));
            loadFieldArray[i] = loadField;
        }
        return loadFieldArray;
    }

    private Column[] getColumns(NodeList nodeList) {
        Column[] columnArray = new Column[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength() && !this._cancel; ++i) {
            if (!nodeList.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.COLUMN.toString())) continue;
            Column column = new Column();
            column.setName(this.notNull(this.getNodeValue(nodeList.item(i), XML_KEYS.TABLE_COL_NAME)));
            column.setSourceColumnName(this.getNodeValue(nodeList.item(i), XML_KEYS.SOURCE_COL_NAME));
            column.setSourceColID(Integer.parseInt(this.notNull(this.getNodeValue(nodeList.item(i), XML_KEYS.SOURCE_COL_ID))));
            column.setType(this.getNodeValue(nodeList.item(i), XML_KEYS.TYPE));
            column.setPrecision(Integer.parseInt(this.notNull(this.getNodeValue(nodeList.item(i), XML_KEYS.PRECISION))));
            column.setScale(Integer.parseInt(this.notNull(this.getNodeValue(nodeList.item(i), XML_KEYS.SCALE))));
            column.setDefault(this.getNodeValue(nodeList.item(i), XML_KEYS.DEFAULT));
            column.setFormat(this.getNodeValue(nodeList.item(i), XML_KEYS.FORMAT));
            column.setComment(this.getNodeValue(nodeList.item(i), XML_KEYS.COMMENT));
            column.setNullable(Boolean.parseBoolean(this.notNull(this.getNodeValue(nodeList.item(i), XML_KEYS.NULLABLE))));
            columnArray[i] = column;
        }
        return columnArray;
    }

    private Column[] getColumnsFromReference(NodeList nodeList) {
        Column[] columnArray = new Column[nodeList.getLength()];
        block0: for (int i = 0; i < nodeList.getLength() && !this._cancel; ++i) {
            Column[] columnArray2 = (Column[])this.getPropertyValueObject(ImportKeys.FILE_COLUMNS);
            if (!nodeList.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.COLUMN_REFERENCE.toString()) || columnArray2 == null) continue;
            for (Column column : (Column[])this.getPropertyValueObject(ImportKeys.FILE_COLUMNS)) {
                if (!column.getSourceColumnName().equals(this.notNull(this.getNodeValue(nodeList.item(i), XML_KEYS.SOURCE_COL_NAME)))) continue;
                columnArray[i] = column;
                continue block0;
            }
        }
        return columnArray;
    }

    public void processLoadMethod(Node node, boolean bl) {
        if (node != null) {
            this._iProps.put(ImportKeys.LOAD_METHOD, this.convertPosInt(this.getNodeValue(node, ImportKeys.LOAD_METHOD)));
            this._iProps.put(ImportKeys.STAGING_TABLE_NAME, this.notNull(this.getNodeValue(node, ImportKeys.STAGING_TABLE_NAME)));
            this._iProps.put(ImportKeys.DROP_STAGING_TABLE, this.convertBoolean(this.getNodeValue(node, ImportKeys.DROP_STAGING_TABLE)));
            this._iProps.put(ImportKeys.IS_EXISTING_TABLE, this.convertBoolean(this.getNodeValue(node, ImportKeys.IS_EXISTING_TABLE)));
            this._iProps.put(ImportKeys.TABLE_NAME, this.notNull(this.getNodeValue(node, ImportKeys.TABLE_NAME)));
            this._iProps.put(ImportKeys.USE_LOAD_LIMIT, this.convertBoolean(this.getNodeValue(node, ImportKeys.USE_LOAD_LIMIT)));
            this._iProps.put(ImportKeys.LOAD_LIMIT, this.convertPosInt(this.getNodeValue(node, ImportKeys.LOAD_LIMIT)));
            this._iProps.put(ImportKeys.SEND_TO_WORKSHEET, this.convertBoolean(this.getNodeValue(node, ImportKeys.SEND_TO_WORKSHEET)));
        }
    }

    public void processMatch(Node node, boolean bl) {
        if (node != null) {
            this._iProps.put(ImportKeys.MATCH_BY_TYPE, this.convertPosInt(this.getNodeValue(node, ImportKeys.MATCH_BY_TYPE)));
        }
    }

    private void processExternalOptions(Node node, boolean bl) {
        this._iProps.put(ImportKeys.DIRPATH, this.notNull(this.getNodeValue(node, ImportKeys.DIRPATH)));
        this._iProps.put(ImportKeys.ORADIRNAME, this.notNull(this.getNodeValue(node, ImportKeys.ORADIRNAME)));
        this._iProps.put(ImportKeys.USEBADFILE, this.convertBoolean(this.getNodeValue(node, ImportKeys.USEBADFILE)));
        this._iProps.put(ImportKeys.ORABADDIRNAME, this.notNull(this.getNodeValue(node, ImportKeys.ORABADDIRNAME)));
        this._iProps.put(ImportKeys.USELOGFILE, this.convertBoolean(this.getNodeValue(node, ImportKeys.USELOGFILE)));
        this._iProps.put(ImportKeys.ORALOGDIRNAME, this.notNull(this.getNodeValue(node, ImportKeys.ORALOGDIRNAME)));
        this._iProps.put(ImportKeys.USEDISCARDFILE, this.convertBoolean(this.getNodeValue(node, ImportKeys.USEDISCARDFILE)));
        this._iProps.put(ImportKeys.ORADISCARDDIRNAME, this.notNull(this.getNodeValue(node, ImportKeys.ORADISCARDDIRNAME)));
        this._iProps.put(ImportKeys.BADDIRNAME, this.notNull(this.getNodeValue(node, ImportKeys.BADDIRNAME)));
        this._iProps.put(ImportKeys.LOGDIRNAME, this.notNull(this.getNodeValue(node, ImportKeys.LOGDIRNAME)));
        this._iProps.put(ImportKeys.USEGENDIR, this.convertBoolean(this.getNodeValue(node, ImportKeys.USEGENDIR)));
        this._iProps.put(ImportKeys.GENDIR, this.notNull(this.getNodeValue(node, ImportKeys.GENDIR)));
        this._iProps.put(ImportKeys.FILEOUTNEWLINE, this.notNull(this.getNodeValue(node, ImportKeys.FILEOUTNEWLINE)));
        this._iProps.put(ImportKeys.CHARNUMCHARACTERS, this.getNodeValue(node, ImportKeys.CHARNUMCHARACTERS));
        this._iProps.put(ImportKeys.CHARSETVAL, this.notNull(this.getNodeValue(node, ImportKeys.CHARSETVAL)));
    }

    public String notNull(String string) {
        if (string == null || string.equals("null")) {
            return "";
        }
        return string;
    }

    public String notNullBoolean(String string) {
        if (string == null || string.equals("null") || string.equals("false")) {
            return "false";
        }
        return "true";
    }

    public boolean convertBoolean(String string) {
        return string != null && !string.equals("null") && !string.equals("false");
    }

    public int convertPosInt(String string) {
        if (string == null || string.equals("null")) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public void setImport(Boolean bl) {
        this._import = bl;
    }

    public void parseXML(InputStreamReader inputStreamReader, boolean bl, String string, XLIFFHelper xLIFFHelper) {
        this.parseXML(inputStreamReader, bl, string);
    }

    public void saveConfigOptions(File file, ImportProperties importProperties) {
        try {
            String string = "UTF-8";
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            this._out = new OutputStreamWriter((OutputStream)bufferedOutputStream, string);
            this._out.write("<?xml version=\"1.0\" encoding=\"" + string + "\" ?>" + _term);
            this.outStartGroup(XML_KEYS.IMPORT_TOOL.toString(), 0);
            LoadFile loadFile = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
            this.outStartGroup(XML_KEYS.FILE_SETTINGS.toString(), 0);
            this.outString(ImportKeys.FILE_PATH.toString(), loadFile.getName(), 1);
            this.outEndGroup(XML_KEYS.FILE_SETTINGS.toString(), 0);
            this.outStartGroup(XML_KEYS.CONNECTION_SETTINGS.toString(), 0);
            this.outString(ImportKeys.CONNECTION_NAME.toString(), (String)importProperties.get(ImportKeys.CONNECTION_NAME), 1);
            this.outEndGroup(XML_KEYS.CONNECTION_SETTINGS.toString(), 0);
            DBObject dBObject = (DBObject)importProperties.get(ImportKeys.DBOBJECT);
            this.outStartGroup(ImportKeys.DBOBJECT.toString(), 0);
            this.outString(ImportKeys.OBJECT_CONNECTION.toString(), dBObject.getConnectionName(), 1);
            this.outString(ImportKeys.OBJECT_TYPE.toString(), dBObject.getObjectType(), 1);
            this.outString(ImportKeys.OBJECT_SCHEMA.toString(), dBObject.getSchemaName(), 1);
            this.outString(ImportKeys.OBJECT_NAME.toString(), dBObject.getObjectName(), 1);
            this.outEndGroup(ImportKeys.DBOBJECT.toString(), 0);
            ImportDataFormat importDataFormat = (ImportDataFormat)importProperties.get(ImportKeys.IMPORT_DATA_FORMAT);
            this.outStartGroup(ImportKeys.IMPORT_DATA_FORMAT.toString(), 0);
            this.outString(ImportKeys.DATA_FORMAT.toString(), importDataFormat.getFormat(), 1);
            this.outString(ImportKeys.ENCODING.toString(), importDataFormat.getEncoding(), 1);
            this.outBool(ImportKeys.USE_PREVIEW_LIMIT.toString(), importDataFormat.getUsePreviewLimit(), 1);
            this.outInt(ImportKeys.PREVIEW_LIMIT.toString(), importDataFormat.getPreviewLimit(), 1);
            this.outBool(ImportKeys.USE_MAX_LENGTH.toString(), importDataFormat.getUseMaxLength(), 1);
            this.outInt(ImportKeys.MAX_LENGTH.toString(), importDataFormat.getMaxLength(), 1);
            this.outInt(ImportKeys.PAGEID.toString(), importDataFormat.getPageId(), 1);
            this.outString(ImportKeys.WORKSHEET_NAME.toString(), importDataFormat.getWorksneet(), 1);
            IFormatOptions iFormatOptions = importDataFormat.getOptions();
            if (iFormatOptions.isHeaderOptionSupported()) {
                this.outBool(ImportKeys.IS_HEADER.toString(), importDataFormat.isHeader(), 1);
                this.outInt(ImportKeys.HEADER_LOCATION.toString(), importDataFormat.getHeaderLocation(), 2);
            }
            this.outInt(ImportKeys.SKIP_ROWS.toString(), importDataFormat.getSkipRows(), 1);
            if (iFormatOptions.isDelimiterSupported() && iFormatOptions.isDelimiterConfigurable()) {
                this.outString(ImportKeys.DELIMITER.toString(), ImportDataFormat.getDelimiterForConfigValue(importDataFormat.getDelimiter()), 1);
            }
            if (iFormatOptions.isEnclosuresSupported()) {
                this.outString(ImportKeys.ENCLOSURE_LEFT.toString(), ImportDataFormat.getEnclosureForConfigValue(importDataFormat.getEnclosureLeftValue()), 1);
                this.outString(ImportKeys.ENCLOSURE_RIGHT.toString(), ImportDataFormat.getEnclosureForConfigValue(importDataFormat.getEnclosureRightValue()), 1);
                this.outBool(ImportKeys.IS_ENCLOSURE_RIGHT_DOUBLE.toString(), importDataFormat.isEnclosureRightDouble(), 1);
            }
            if (iFormatOptions.isLineTerminatorSupported()) {
                this.outString(ImportKeys.RECORD_TERMINATOR.toString(), ImportDataFormat.getRecordTerminatorForConfigValue(importDataFormat.getRecordTerminator()), 1);
            }
            this.outEndGroup(ImportKeys.IMPORT_DATA_FORMAT.toString(), 0);
            Locale locale = (Locale)importProperties.get(ImportKeys.LOCALE);
            this.outStartGroup(XML_KEYS.LOCALE.toString(), 0);
            this.outString(ImportKeys.LANGUAGE.toString(), locale.getLanguage(), 1);
            this.outString(ImportKeys.COUNTRY.toString(), locale.getCountry(), 1);
            this.outString(ImportKeys.VARIANT.toString(), locale.getVariant(), 1);
            this.outEndGroup(XML_KEYS.LOCALE.toString(), 0);
            this.outStartGroup(XML_KEYS.FILE_FIELDS.toString(), 0);
            this.outFields((LoadFile)importProperties.get(ImportKeys.LOAD_FILE), 1);
            this.outEndGroup(XML_KEYS.FILE_FIELDS.toString(), 0);
            this.outStartGroup(ImportKeys.FILE_COLUMNS.toString(), 0);
            this.outColumns((Column[])importProperties.get(ImportKeys.FILE_COLUMNS), 1);
            this.outEndGroup(ImportKeys.FILE_COLUMNS.toString(), 0);
            this.outStartGroup(ImportKeys.TABLE_COLUMNS.toString(), 0);
            this.outColumns(((GenericTable)importProperties.get(ImportKeys.TABLE)).getColumns(), 1);
            this.outEndGroup(ImportKeys.TABLE_COLUMNS.toString(), 0);
            this.outStartGroup(ImportKeys.SELECTABLE_COLUMNS.toString(), 0);
            this.outColumnReference((Column[])importProperties.get(ImportKeys.SELECTABLE_COLUMNS), 1);
            this.outEndGroup(ImportKeys.SELECTABLE_COLUMNS.toString(), 0);
            this.outStartGroup(ImportKeys.SELECTED_COLUMNS.toString(), 0);
            this.outColumnReference((Column[])importProperties.get(ImportKeys.SELECTED_COLUMNS), 1);
            this.outEndGroup(ImportKeys.SELECTED_COLUMNS.toString(), 0);
            this.outStartGroup(XML_KEYS.LOAD_METHOD_SETTINGS.toString(), 0);
            int n = (Integer)importProperties.get(ImportKeys.LOAD_METHOD);
            this.outInt(ImportKeys.LOAD_METHOD.toString(), n, 1);
            if (n == 3) {
                this.outString(ImportKeys.STAGING_TABLE_NAME.toString(), (String)importProperties.get(ImportKeys.STAGING_TABLE_NAME), 1);
                this.outBool(ImportKeys.DROP_STAGING_TABLE.toString(), (Boolean)importProperties.get(ImportKeys.DROP_STAGING_TABLE), 1);
            }
            this.outBool(ImportKeys.IS_EXISTING_TABLE.toString(), (Boolean)importProperties.get(ImportKeys.IS_EXISTING_TABLE), 1);
            this.outString(ImportKeys.TABLE_NAME.toString(), (String)importProperties.get(ImportKeys.TABLE_NAME), 1);
            Boolean bl = (Boolean)importProperties.get(ImportKeys.USE_LOAD_LIMIT);
            this.outBool(ImportKeys.USE_LOAD_LIMIT.toString(), bl, 1);
            int n2 = (Integer)importProperties.get(ImportKeys.LOAD_LIMIT);
            if (bl.booleanValue()) {
                this.outInt(ImportKeys.LOAD_LIMIT.toString(), n2, 1);
            } else {
                this.outInt(ImportKeys.LOAD_LIMIT.toString(), 0, 1);
            }
            this.outBool(ImportKeys.SEND_TO_WORKSHEET.toString(), (Boolean)importProperties.get(ImportKeys.SEND_TO_WORKSHEET), 1);
            this.outEndGroup(XML_KEYS.LOAD_METHOD_SETTINGS.toString(), 0);
            this.outStartGroup(XML_KEYS.MATCH.toString(), 0);
            this.outInt(ImportKeys.MATCH_BY_TYPE.toString(), importProperties.getValueInteger(ImportKeys.MATCH_BY_TYPE), 1);
            this.outEndGroup(XML_KEYS.MATCH.toString(), 0);
            this.outStartGroup(XML_KEYS.EXTERNAL_OPTIONS_SETTINGS.toString(), 0);
            if (n == 2 || n == 3) {
                this.outString(ImportKeys.DIRPATH.toString(), this.getString(ImportKeys.DIRPATH, importProperties), 1);
                this.outString(ImportKeys.ORADIRNAME.toString(), this.getString(ImportKeys.ORADIRNAME, importProperties), 1);
                this.outBool(ImportKeys.USEBADFILE.toString(), (Boolean)importProperties.get(ImportKeys.USEBADFILE), 1);
                this.outString(ImportKeys.ORABADDIRNAME.toString(), this.getString(ImportKeys.ORABADDIRNAME, importProperties), 1);
                this.outBool(ImportKeys.USELOGFILE.toString(), (Boolean)importProperties.get(ImportKeys.USELOGFILE), 1);
                this.outString(ImportKeys.ORALOGDIRNAME.toString(), this.getString(ImportKeys.ORALOGDIRNAME, importProperties), 1);
                this.outBool(ImportKeys.USEDISCARDFILE.toString(), (Boolean)importProperties.get(ImportKeys.USEDISCARDFILE), 1);
                this.outString(ImportKeys.ORADISCARDDIRNAME.toString(), this.getString(ImportKeys.ORADISCARDDIRNAME, importProperties), 1);
            } else if (n == 4) {
                this.outString(ImportKeys.BADDIRNAME.toString(), this.getString(ImportKeys.BADDIRNAME, importProperties), 1);
                this.outString(ImportKeys.LOGDIRNAME.toString(), this.getString(ImportKeys.LOGDIRNAME, importProperties), 1);
                this.outBool(ImportKeys.USEGENDIR.toString(), (Boolean)importProperties.get(ImportKeys.USEGENDIR), 1);
                this.outString(ImportKeys.GENDIR.toString(), this.getString(ImportKeys.GENDIR, importProperties), 1);
                this.outString(ImportKeys.FILEOUTNEWLINE.toString(), this.getString(ImportKeys.FILEOUTNEWLINE, importProperties), 1);
            }
            this.outString(ImportKeys.CHARNUMCHARACTERS.toString(), this.getString(ImportKeys.CHARNUMCHARACTERS, importProperties), 1);
            this.outString(ImportKeys.CHARSETVAL.toString(), this.getString(ImportKeys.CHARSETVAL, importProperties), 1);
            this.outEndGroup(XML_KEYS.EXTERNAL_OPTIONS_SETTINGS.toString(), 0);
            this.outEndGroup(XML_KEYS.IMPORT_TOOL.toString(), 0);
            this._out.flush();
            this._out.close();
        }
        catch (IOException iOException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString((String)"ReportNavigatorContextMenu.73"), (String)Messages.getString((String)"ReportNavigatorContextMenu.74"), (String)"f1_exportbadfile_html");
        }
    }

    private void outStartGroup(String string, int n) throws IOException {
        if (n > 0) {
            this._out.append(this.getIndent(n));
        }
        this._out.append("<" + string + ">\n");
    }

    private void outInt(String string, int n, int n2) throws IOException {
        this.outString(string, Integer.toString(n), n2);
    }

    private void outBool(String string, boolean bl, int n) throws IOException {
        this.outString(string, bl ? "true" : "false", n);
    }

    private void outString(String string, String string2, int n) throws IOException {
        if (n > 0) {
            this._out.append(this.getIndent(n));
        }
        if (string2 == null) {
            string2 = "";
        }
        this._out.append("<" + string + "><![CDATA[" + string2 + "]]></" + string + ">\n");
    }

    private void outEndGroup(String string, int n) throws IOException {
        if (n > 0) {
            this._out.append(this.getIndent(n));
        }
        this._out.append("</" + string + ">\n");
    }

    private String getIndent(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 9;
        }
        return new String(cArray);
    }

    private void outFields(LoadFile loadFile, int n) throws IOException {
        for (LoadField loadField : loadFile.getFields()) {
            this.outStartGroup(XML_KEYS.FIELD.toString(), n);
            this.outString(XML_KEYS.FIELD_NAME.toString(), loadField.getName(), n + 1);
            this.outInt(XML_KEYS.FIELD_LENGTH.toString(), loadField.getLength(), n + 1);
            this.outEndGroup(XML_KEYS.FIELD.toString(), n);
        }
    }

    private void outColumns(Column[] columnArray, int n) throws IOException {
        for (Column column : columnArray) {
            this.outStartGroup(XML_KEYS.COLUMN.toString(), n);
            this.outString(XML_KEYS.TABLE_COL_NAME.toString(), column.getName(), n + 1);
            this.outString(XML_KEYS.SOURCE_COL_NAME.toString(), column.getSourceColumnName(), n + 1);
            this.outInt(XML_KEYS.SOURCE_COL_ID.toString(), column.getSourceColID(), n + 1);
            this.outString(XML_KEYS.TYPE.toString(), column.getType(), n + 1);
            this.outInt(XML_KEYS.PRECISION.toString(), column.getPrecision(), n + 1);
            this.outInt(XML_KEYS.SCALE.toString(), column.getScale(), n + 1);
            this.outString(XML_KEYS.DEFAULT.toString(), column.getDefault(), n + 1);
            this.outString(XML_KEYS.FORMAT.toString(), column.getFormat(), n + 1);
            this.outString(XML_KEYS.COMMENT.toString(), column.getComment(), n + 1);
            this.outBool(XML_KEYS.NULLABLE.toString(), column.isNullable(), n + 1);
            this.outEndGroup(XML_KEYS.COLUMN.toString(), n);
        }
    }

    private void outColumnReference(Column[] columnArray, int n) throws IOException {
        for (Column column : columnArray) {
            this.outStartGroup(XML_KEYS.COLUMN_REFERENCE.toString(), n);
            this.outString(XML_KEYS.TABLE_COL_NAME.toString(), column.getName(), n + 1);
            this.outString(XML_KEYS.SOURCE_COL_NAME.toString(), column.getSourceColumnName(), n + 1);
            this.outInt(XML_KEYS.SOURCE_COL_ID.toString(), column.getSourceColID(), n + 1);
            this.outEndGroup(XML_KEYS.COLUMN_REFERENCE.toString(), n);
        }
    }

    private String getString(ImportKeys importKeys, ImportProperties importProperties) {
        return importProperties.get(importKeys) == null ? "" : (String)importProperties.get(importKeys);
    }

    public ExitCode reconcileConfig(String string) {
        return this.reconcileConfig(string, (Boolean)this.getPropertyValueObject(ImportKeys.IS_EXISTING_TABLE), this.getPropertyValue(ImportKeys.CONNECTION_NAME), (DBObject)this.getPropertyValueObject(ImportKeys.DBOBJECT), this.getPropertyValue(ImportKeys.FILE_PATH));
    }

    public ExitCode reconcileConfig(String string, boolean bl, String string2, DBObject dBObject, String string3) {
        String string4 = _term;
        StringBuffer stringBuffer = new StringBuffer();
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        try {
            Object object;
            Object object22;
            boolean bl2;
            File file;
            Object object5;
            GenericTable genericTable;
            if (!this._isLoaded) {
                exitCode = ExitCode.EXIT_SEVERE;
                String string5 = DataImportArb.getString("CONFIG_OPEN_ERROR19");
                stringBuffer.append(string5);
                throw new ConfigException(string5, exitCode);
            }
            if (this._rootNodeName == null) {
                exitCode = ExitCode.EXIT_SEVERE;
                String string6 = DataImportArb.format("XML_FILE_ERROR_MESSAGE", string, "\"" + XML_KEYS.IMPORT_TOOL.toString() + "\"", DataImportArb.getString("XML_FILE_NO_KEY"));
                stringBuffer.append(string6);
                throw new ConfigException(string6, exitCode, true);
            }
            if (!this._rootNodeName.equals(XML_KEYS.IMPORT_TOOL.toString())) {
                exitCode = ExitCode.EXIT_SEVERE;
                String string7 = DataImportArb.format("XML_FILE_ERROR_MESSAGE", string, "\"" + XML_KEYS.IMPORT_TOOL.toString() + "\"", this._rootNodeName);
                stringBuffer.append(string7);
                throw new ConfigException(string7, exitCode, true);
            }
            String string8 = this.getPropertyValue(ImportKeys.CONNECTION_NAME);
            boolean bl3 = (Boolean)this.getPropertyValueObject(ImportKeys.IS_EXISTING_TABLE);
            DBObject dBObject2 = (DBObject)this.getPropertyValueObject(ImportKeys.DBOBJECT);
            String string9 = dBObject2.getSchemaName() + (bl3 ? "." + dBObject2.getObjectName() : "");
            String string10 = dBObject.getSchemaName() + (bl ? "." + dBObject.getObjectName() : "");
            if (bl && !bl3) {
                exitCode = ExitCode.EXIT_SEVERE;
                String string11 = DataImportArb.format("CONFIG_OPEN_ERROR0", string10);
                stringBuffer.append(string11);
                throw new ConfigException(string11, exitCode);
            }
            if (bl3 && !bl) {
                String string12 = DataImportArb.format("CONFIG_OPEN_ERROR1", string9);
                stringBuffer.append(string12);
                exitCode = ExitCode.EXIT_SEVERE;
                throw new ConfigException(string12, exitCode);
            }
            if (!string2.equals(string8)) {
                exitCode = ExitCode.EXIT_WARNING;
                stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR2", Connections.getDisplayName(string8), Connections.getDisplayName(string2)) + string4);
            } else {
                stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR27", Connections.getDisplayName(string8)) + string4);
            }
            if (!(!bl || dBObject.getSchemaName().equals(dBObject2.getSchemaName()) && dBObject.getObjectType().equals(dBObject2.getObjectType()) && dBObject.getObjectName().equals(dBObject2.getObjectName()))) {
                exitCode = ExitCode.EXIT_WARNING;
                stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR3", string9, string10) + string4);
            } else if (!bl && !dBObject.getSchemaName().equals(dBObject2.getSchemaName())) {
                exitCode = ExitCode.EXIT_WARNING;
                stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR30", string9, string10) + string4);
            } else {
                stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR26", string9) + string4);
            }
            this._iProps.put(ImportKeys.CONNECTION_NAME, string2);
            this._iProps.put(ImportKeys.DBOBJECT, dBObject);
            GenericTable genericTable2 = null;
            if (bl) {
                genericTable = new GenericTable();
                genericTable.setTableName(this.getPropertyValue(ImportKeys.TABLE_NAME));
                object5 = (Column[])this.getPropertyValueObject(ImportKeys.TABLE_COLUMNS);
                for (int i = 0; i < ((Column[])object5).length; ++i) {
                    genericTable.addColumn(object5[i]);
                }
                try {
                    genericTable2 = new GenericTable(Connections.getInstance().getConnection(string2), dBObject.getSchemaName(), dBObject.getObjectName());
                    if (genericTable2.getTable() == null) {
                        exitCode = ExitCode.EXIT_ERROR;
                        String string13 = DataImportArb.format("CONFIG_OPEN_ERROR24", string10, Connections.getDisplayName(string2));
                        Logger.severe(this.getClass(), (String)string13);
                        stringBuffer.append(string13);
                        throw new ConfigException(string13, exitCode);
                    }
                    this._iProps.put(ImportKeys.TABLE, genericTable2);
                }
                catch (DBException dBException) {
                    exitCode = ExitCode.EXIT_SEVERE;
                    Logger.severe(this.getClass(), (String)dBException.getStackTrace()[0].toString(), (Throwable)dBException);
                    String string14 = DataImportArb.format("CONFIG_OPEN_ERROR8", string10, "" + stringBuffer + dBException.getMessage());
                    stringBuffer.append(string14);
                    throw new ConfigException(string14, exitCode);
                }
                file = null;
                bl2 = false;
                for (Column column : genericTable.getColumns()) {
                    file = genericTable2.getTable().getColumnByName(column.getName());
                    if (file == null) {
                        if (!bl2) {
                            stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR4", new Object[0]) + _term);
                            bl2 = true;
                        }
                        stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR6", column.getName() + _term));
                        exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_WARNING);
                        continue;
                    }
                    if (file.getType().equals(column.getType()) && file.getPrecision() == column.getPrecision() && file.getScale() == column.getScale()) continue;
                    if (!bl2) {
                        stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR4", new Object[0]) + _term);
                        bl2 = true;
                    }
                    stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR5", file.getName() + _term));
                    exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_WARNING);
                }
                Object bl4 = null;
                for (Column column : genericTable2.getColumns()) {
                    Column column2 = genericTable.getTable().getColumnByName(column.getName());
                    if (column2 != null) continue;
                    if (!bl2) {
                        stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR4", new Object[0]) + _term);
                        bl2 = true;
                    }
                    stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR7", column.getName() + _term));
                    exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_WARNING);
                }
                this._iProps.put(ImportKeys.TABLE_NAME, dBObject.getObjectName());
            } else {
                genericTable2 = new GenericTable();
                genericTable2.setTableName(this.getPropertyValue(ImportKeys.TABLE_NAME));
                this._iProps.put(ImportKeys.TABLE_NAME, this.getPropertyValue(ImportKeys.TABLE_NAME));
                genericTable2.setColumns((Column[])this.getPropertyValueObject(ImportKeys.FILE_COLUMNS));
            }
            this._iProps.put(ImportKeys.TABLE, genericTable2);
            genericTable = (LoadFile)this.getPropertyValueObject(ImportKeys.LOAD_FILE);
            object5 = (ArrayList)genericTable.getFields();
            file = new File(genericTable.getName());
            if (file == null || file.isDirectory() || !file.isFile()) {
                stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR10", genericTable.getName() + _term));
                exitCode = ExitCode.EXIT_SEVERE;
            } else if (string3 != null && !string3.equals("") && !string3.equals(genericTable.getName())) {
                stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR28", genericTable.getName(), string3) + _term);
                genericTable = new LoadFile(string3);
                this._iProps.put(ImportKeys.LOAD_FILE, genericTable);
                exitCode = ExitCode.EXIT_WARNING;
            } else {
                stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR31", genericTable.getName()) + _term);
            }
            this._datareader = DataReaderRegistry.getReader(this._dataFormat.getFormat());
            try {
                this._datareader.setFileName(genericTable.getName());
                this._datareader.setPage(this._dataFormat.getPageId());
            }
            catch (DataReaderException dataReaderException) {
                String string5 = DataImportArb.format("OPEN_FILE_ERROR", genericTable.getName(), dataReaderException.getMessage());
                stringBuffer.append(string5);
                exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_ERROR);
                throw new ConfigException(string5, exitCode);
            }
            this._dataGizmo = new DataPreviewGizmo(this._datareader);
            this._dataGizmo.setDataFormat(this._dataFormat);
            this._dataGizmo.initTable();
            this._dataGizmo.populateDataTable();
            this._dataGizmo.createFields((LoadFile)genericTable);
            if (genericTable.getFieldCount() != ((ArrayList)object5).size()) {
                stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR11", new Object[]{Integer.toString(genericTable.getFieldCount()), Integer.toString(((ArrayList)object5).size())} + _term));
                exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_ERROR);
            }
            bl2 = false;
            boolean bl4 = false;
            Iterator iterator = ((ArrayList)object5).iterator();
            while (iterator.hasNext()) {
                boolean bl5;
                LoadField loadField = (LoadField)iterator.next();
                for (LoadField loadField2 : genericTable.getFields()) {
                    if (!loadField2.getName().equals(loadField.getName())) continue;
                    if (loadField2.getLength() < loadField.getLength()) {
                        if (!bl5) {
                            stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR18", new Object[0]) + _term);
                            bl5 = true;
                        }
                        stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR12", loadField2.getName()) + _term);
                        exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_WARNING);
                    }
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    if (!bl5) {
                        stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR18", new Object[0]) + _term);
                        bl5 = true;
                    }
                    stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR11", loadField.getName()) + _term);
                    exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_ERROR);
                    continue;
                }
                bl2 = false;
            }
            int n = 0;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Column[] columnArray = (Column[])this.getPropertyValueObject(ImportKeys.FILE_COLUMNS);
            for (Object object22 : genericTable.getFields()) {
                object = ((ArrayList)object5).iterator();
                while (object.hasNext()) {
                    LoadField loadField = (LoadField)object.next();
                    if (!object22.getName().equals(loadField.getName())) continue;
                    bl2 = true;
                    ++n;
                    Column column = this.getColumnBySource(object22.getName(), columnArray);
                    if (column != null) {
                        arrayList.add(column);
                        object22.setColumn(column);
                        break;
                    }
                    Column column3 = new Column();
                    column3.setSourceColumnName(object22.getName());
                    column3.setName("");
                    column3.setSourceColID(n++);
                    column3.setPrecision(object22.getLength());
                    column3.setType("VARCHAR2");
                    column3.setScale(0);
                    column3.setNullable(true);
                    arrayList.add(column3);
                    object22.setColumn(column3);
                    break;
                }
                if (!bl2) {
                    boolean bl6;
                    object = new Column();
                    object.setSourceColumnName(object22.getName());
                    object.setName("");
                    object.setSourceColID(n++);
                    object.setPrecision(object22.getLength());
                    object.setType("VARCHAR2");
                    object.setScale(0);
                    object.setNullable(true);
                    arrayList.add(object);
                    object22.setColumn((Column)object);
                    if (!bl6) {
                        stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR18", new Object[0]) + _term);
                        bl6 = true;
                    }
                    stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR15", object22.getName()) + _term);
                    exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_ERROR);
                    continue;
                }
                bl2 = false;
            }
            this._iProps.put(ImportKeys.FILE_COLUMNS, arrayList.toArray(new Column[arrayList.size()]));
            Column[] columnArray2 = (Column[])this.getPropertyValueObject(ImportKeys.SELECTED_COLUMNS);
            object22 = new ArrayList();
            if (columnArray2 != null) {
                for (Column column : columnArray2) {
                    boolean bl7;
                    Column column4 = genericTable2.getTable().getColumnByName(column.getName());
                    if (column4 != null) {
                        ((ArrayList)object22).add(column);
                        column4.setFormat(column.getFormat());
                        continue;
                    }
                    if (!bl7) {
                        stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR18", new Object[0]) + _term);
                        bl7 = true;
                    }
                    stringBuffer.append(DataImportArb.format("CONFIG_OPEN_ERROR25", column.getSourceColumnName(), column.getName(), string10) + _term);
                    exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_ERROR);
                }
            }
            object = new ArrayList();
            if (!((ArrayList)object22).isEmpty()) {
                this._iProps.put(ImportKeys.SELECTED_COLUMNS, ((ArrayList)object22).toArray(new Column[((ArrayList)object22).size()]));
            } else {
                this._iProps.put(ImportKeys.SELECTED_COLUMNS, new Column[0]);
            }
            boolean bl8 = this._iProps.getValueBoolean(ImportKeys.IS_EXISTING_TABLE);
            for (Column column : arrayList) {
                if (this.getColumnBySource(column.getSourceColumnName(), (Iterable<Column>)object22) != null) continue;
                column.setName(bl8 ? "" : column.getSourceColumnName());
                ((ArrayList)object).add(column);
            }
            if (!((ArrayList)object).isEmpty()) {
                this._iProps.put(ImportKeys.SELECTABLE_COLUMNS, ((ArrayList)object).toArray(new Column[((ArrayList)object).size()]));
            } else {
                this._iProps.put(ImportKeys.SELECTABLE_COLUMNS, new Column[0]);
            }
            exitCode.setMessage(stringBuffer.toString());
        }
        catch (ConfigException configException) {
            configException.getExitCode().setMessage(stringBuffer.toString());
            configException.getExitCode().setShortMessage(configException.getMessage());
        }
        return exitCode;
    }

    public ExitCode reconcileConfigForShow(String string) {
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        try {
            if (!this._isLoaded) {
                exitCode = ExitCode.EXIT_SEVERE;
                throw new ConfigException(DataImportArb.getString("CONFIG_OPEN_ERROR19"), exitCode);
            }
            if (this._rootNodeName == null) {
                exitCode = ExitCode.EXIT_SEVERE;
                throw new ConfigException(DataImportArb.format("XML_FILE_ERROR_MESSAGE", string, "\"" + XML_KEYS.IMPORT_TOOL.toString() + "\"", DataImportArb.getString("XML_FILE_NO_KEY")), exitCode, true);
            }
            if (!this._rootNodeName.equals(XML_KEYS.IMPORT_TOOL.toString())) {
                exitCode = ExitCode.EXIT_SEVERE;
                throw new ConfigException(DataImportArb.format("XML_FILE_ERROR_MESSAGE", string, "\"" + XML_KEYS.IMPORT_TOOL.toString() + "\"", this._rootNodeName), exitCode, true);
            }
            boolean bl = (Boolean)this.getPropertyValueObject(ImportKeys.IS_EXISTING_TABLE);
            GenericTable genericTable = new GenericTable();
            genericTable.setTableName(this.getPropertyValue(ImportKeys.TABLE_NAME));
            if (bl) {
                genericTable.setTableName(this.getPropertyValue(ImportKeys.TABLE_NAME));
                Column[] columnArray = (Column[])this.getPropertyValueObject(ImportKeys.TABLE_COLUMNS);
                for (int i = 0; i < columnArray.length; ++i) {
                    genericTable.addColumn(columnArray[i]);
                }
            } else {
                genericTable.setColumns((Column[])this.getPropertyValueObject(ImportKeys.FILE_COLUMNS));
            }
            this._iProps.put(ImportKeys.TABLE, genericTable);
        }
        catch (ConfigException configException) {
            configException.getExitCode().setMessage(configException.getMessage());
        }
        return exitCode;
    }

    private Column getColumnBySource(String string, Column[] columnArray) {
        for (Column column : columnArray) {
            if (!column.getSourceColumnName().equals(string)) continue;
            return column;
        }
        return null;
    }

    private Column getColumnBySource(String string, Iterable<Column> iterable) {
        for (Column column : iterable) {
            if (!column.getSourceColumnName().equals(string)) continue;
            return column;
        }
        return null;
    }

    public DataReadable getDataReader() {
        return this._datareader;
    }

    public DataPreviewGizmo getDataGizmo() {
        return this._dataGizmo;
    }

    private ExitCode getExitCodeHighest(ExitCode exitCode, ExitCode exitCode2) {
        return exitCode2.getSeverity() > exitCode.getSeverity() ? exitCode2 : exitCode;
    }

    private static enum XML_KEYS {
        COLUMN,
        COLUMN_REFERENCE,
        COMMENT,
        CONNECTION_SETTINGS,
        DEFAULT,
        EXTERNAL_OPTIONS_SETTINGS,
        FIELD,
        FIELD_LENGTH,
        FIELD_NAME,
        FILE_COLUMNS,
        FILE_FIELDS,
        FILE_SETTINGS,
        FORMAT,
        IMPORT_TOOL,
        LOAD_METHOD_SETTINGS,
        LOCALE,
        MATCH,
        NULLABLE,
        PRECISION,
        SCALE,
        SOURCE_COL_ID,
        SOURCE_COL_NAME,
        TABLE_COL_NAME,
        TYPE;

    }
}

