/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableColumnModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.NonUserConfigOptions;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.core.ImportXMLUtil;
import oracle.dbtools.raptor.data.headless.ImportHeadlessResources;
import oracle.dbtools.raptor.data.readers.DataReadable;
import oracle.dbtools.raptor.data.readers.DataReaderEvent;
import oracle.dbtools.raptor.data.readers.DataReaderException;
import oracle.dbtools.raptor.data.readers.DataReaderListener;
import oracle.dbtools.raptor.data.readers.DataReaderRegistry;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.data.ui.ImportFormatOptionsPanel;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class DataPreviewPage
extends DefaultTraversablePanel
implements DataReaderListener,
CommitListener {
    private static final long serialVersionUID = -5525219439802104748L;
    protected ImportFormatOptionsPanel _formatOptions;
    protected ImportDataFormat _dataFormat;
    private DataPreviewGizmo _dataGizmo;
    private JPanel _formatPanel;
    private JComboBox _format;
    private JPanel _filePanel;
    private JPanel _configPanel;
    private final FileNameExtensionFilter _configFilter = new FileNameExtensionFilter(DataImportArb.getString("CONFIG_FILE_TYPE"), "sdimp");
    protected URLFileChooser _configChooser;
    private File _configFile;
    private boolean _isConfigUsed = false;
    private ExitCode _exitCode;
    private URLFileChooser.URLFileChooserPanel _dataChooser;
    private String _defaultFileDir;
    protected LoadFile _loadFile;
    private URL _lastURL;
    private DataPreviewPage _previewPage = this;
    protected DataReadable _datareader;
    private int pages;
    boolean _isExistingTable = false;
    private boolean resetData;
    private boolean initUI = false;
    private boolean _isShowConfigPanel = true;
    private boolean _isBackEnabled = false;
    private TraversableContext m_ctx;
    private ImportProperties _iProps;
    private ActionListener _dataFileListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (URLFileChooser.URL_SELECTED == actionEvent.getActionCommand()) {
                DataPreviewPage.this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(DataPreviewPage.this._isBackEnabled), Boolean.valueOf(false), Boolean.valueOf(false));
                this.dataFileChanged();
                SwingUtilities.invokeLater(() -> DataPreviewPage.this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(DataPreviewPage.this._isBackEnabled), Boolean.valueOf(DataPreviewPage.this._dataGizmo.isEnabled()), Boolean.valueOf(false)));
            }
        }

        void dataFileChanged() {
            try {
                File file = DataPreviewPage.this._dataChooser.getSelectedFile();
                if (file != null && file.isFile() && !file.isDirectory()) {
                    boolean bl;
                    String string = file.getAbsolutePath();
                    if (DataPreviewPage.this._loadFile.getName().equals(string)) {
                        return;
                    }
                    LoadFile loadFile = new LoadFile(string);
                    if (DataPreviewPage.this._loadFile.getType() != loadFile.getType() && DataPreviewPage.this._isShowConfigPanel && DataPreviewPage.this._isConfigUsed && !DataPreviewPage.this._dataFormat.isCompatible(loadFile.getType()) && !(bl = MessageDialog.confirm((Component)((Object)DataPreviewPage.this._previewPage), (Object)DataImportArb.getString("XML_FILE_COMPATIBILITY"), (String)DataImportArb.getString("TASK_SHORT_NAME"), null))) {
                        DataPreviewPage.this._filePanel.remove(DataPreviewPage.this._dataChooser);
                        DataPreviewPage.this.initDataChooser(DataPreviewPage.this._loadFile.getURL());
                        DataPreviewPage.this._filePanel.add((Component)DataPreviewPage.this._dataChooser, "Center");
                        DataPreviewPage.this.newFileInit(DataPreviewPage.this._loadFile.getType());
                        return;
                    }
                    DataPreviewPage.this._isConfigUsed = false;
                    DataPreviewPage.this._loadFile = new LoadFile(string);
                    if (DataPreviewPage.this._datareader != null) {
                        DataPreviewPage.this._datareader.closeFile();
                    }
                    DataPreviewPage.this._formatOptions = new ImportFormatOptionsPanel(BaseDataFormat.IMPORT_WIZARD, DataPreviewPage.this._loadFile.getType());
                    DataPreviewPage.this.newFileInit(DataPreviewPage.this._loadFile.getType());
                    DataPreviewPage.this._iProps.put(ImportKeys.SELECTED_COLUMNS, null);
                    DataPreviewPage.this._iProps.put(ImportKeys.SELECTABLE_COLUMNS, null);
                } else {
                    this.resetUI();
                }
            }
            catch (Exception exception) {
                Logger.warn(this.getClass(), (Throwable)exception);
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataImportArb.format("OPEN_FILE_ERROR", DataPreviewPage.this._loadFile.getName(), exception.getMessage()), (String)DataImportArb.getString("OPEN_FILE_ERROR_TITLE"), (String)"IMPORT_OPEN_FILE_ERROR");
                DataPreviewPage.this._dataChooser.setText("");
                this.resetUI();
            }
        }

        private void resetUI() {
            DataPreviewPage.this.removeAll();
            DataPreviewPage.this._loadFile = new LoadFile("");
            DataPreviewPage.this.initUI();
            DataPreviewPage.this.repaint();
            DataPreviewPage.this.getParent().validate();
        }
    };
    private DocumentListener _enclosureRightTextListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.enclosureRightChanged(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.enclosureRightChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.enclosureRightChanged(documentEvent);
        }

        void enclosureRightChanged(DocumentEvent documentEvent) {
            String string = "";
            try {
                string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (DataPreviewPage.this.isValid(string)) {
                DataPreviewPage.this._dataFormat.setEnclosureRight(string);
                DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
            }
        }
    };
    private DocumentListener _enclosureLeftTextListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.enclosureLeftChanged(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.enclosureLeftChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.enclosureLeftChanged(documentEvent);
        }

        void enclosureLeftChanged(DocumentEvent documentEvent) {
            String string = "";
            try {
                string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (DataPreviewPage.this.isValid(string)) {
                DataPreviewPage.this._dataFormat.setEnclosureLeft(string);
                String string2 = DataPreviewPage.this._dataFormat.getEnclosureRightFromLeft(string);
                if (string2 != null) {
                    ((JTextField)DataPreviewPage.this._formatOptions.getEnclosuresRightComponent().getEditor().getEditorComponent()).getDocument().removeDocumentListener(DataPreviewPage.this._enclosureRightTextListener);
                    DataPreviewPage.this._formatOptions.getEnclosuresRightComponent().setSelectedItem(string2);
                    DataPreviewPage.this._dataFormat.setEnclosureRight(string2);
                    ((JTextField)DataPreviewPage.this._formatOptions.getEnclosuresRightComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(DataPreviewPage.this._enclosureRightTextListener);
                }
                DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
            }
        }
    };
    private DocumentListener _delimiterTextListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.delimiterValueChanged(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.delimiterValueChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.delimiterValueChanged(documentEvent);
        }

        void delimiterValueChanged(DocumentEvent documentEvent) {
            String string = "";
            try {
                string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (DataPreviewPage.this.isValid(string)) {
                DataPreviewPage.this._dataFormat.setDelimiter(string);
                DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
                DataPreviewPage.this.resetData = true;
            }
        }
    };
    ItemListener _delimiterItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            String string;
            if (itemEvent.getStateChange() == 1 && !(string = (String)((JComboBox)itemEvent.getSource()).getSelectedItem()).equals(DataPreviewPage.this._dataFormat.getDelimiter())) {
                DataPreviewPage.this._dataFormat.setDelimiter(string);
                DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
                DataPreviewPage.this.resetData = true;
            }
        }
    };
    private ChangeListener _skipRowsChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            DataPreviewPage.this._dataFormat.setSkipRows(((NumericSpinBox)changeEvent.getSource()).getIntValue());
            DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
            DataPreviewPage.this.resetData = true;
        }
    };
    private ActionListener _headerLocationActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataPreviewPage.this._dataFormat.setHeaderLocation(((JComboBox)actionEvent.getSource()).getSelectedIndex());
            DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
            DataPreviewPage.this.resetData = true;
        }
    };
    private DocumentListener _terminatorTextListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.terminatorValueChanged(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.terminatorValueChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.terminatorValueChanged(documentEvent);
        }

        void terminatorValueChanged(DocumentEvent documentEvent) {
            String string = "";
            try {
                string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (DataPreviewPage.this.isValid(string)) {
                ((JTextField)DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().removeDocumentListener(DataPreviewPage.this._terminatorTextListener);
                DataPreviewPage.this._dataFormat.setRecordTerminator(string);
                DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
                ((JTextField)DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(DataPreviewPage.this._terminatorTextListener);
            }
        }
    };
    ItemListener _terminatorItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().removeItemListener(DataPreviewPage.this._terminatorItemListener);
                ((JTextField)DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().removeDocumentListener(DataPreviewPage.this._terminatorTextListener);
                DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().setSelectedItem(DataPreviewPage.this._dataFormat.getRecordTerminator());
                DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().addItemListener(DataPreviewPage.this._terminatorItemListener);
                ((JTextField)DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(DataPreviewPage.this._terminatorTextListener);
            }
        }
    };
    KeyAdapter _keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                keyEvent.consume();
            }
        }
    };
    ChangeListener previewLimitChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
        }
    };
    ItemListener _formatListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (DataPreviewPage.this._dataFormat.isHeaderLocationSupported()) {
                    DataPreviewPage.this._formatOptions.getHeaderLocationComponent().removeActionListener(DataPreviewPage.this._headerLocationActionListener);
                }
                if (!DataPreviewPage.this._dataFormat.isExcel() && !DataPreviewPage.this._dataFormat.isExcelX()) {
                    DataPreviewPage.this._format.removeItemListener(DataPreviewPage.this._formatListener);
                    DataPreviewPage.this._formatOptions.getDelimiterComponent().removeItemListener(DataPreviewPage.this._delimiterItemListener);
                    ((JTextField)DataPreviewPage.this._formatOptions.getDelimiterComponent().getEditor().getEditorComponent()).getDocument().removeDocumentListener(DataPreviewPage.this._delimiterTextListener);
                    DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().removeItemListener(DataPreviewPage.this._terminatorItemListener);
                    ((JTextField)DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().removeDocumentListener(DataPreviewPage.this._terminatorTextListener);
                    DataPreviewPage.this._formatOptions.getSkipRowsComponent().removeChangeListener(DataPreviewPage.this._skipRowsChangeListener);
                }
                DataPreviewPage.this._dataFormat.setFormat((String)DataPreviewPage.this._format.getSelectedItem());
                DataPreviewPage.this._formatPanel.removeAll();
                DataPreviewPage.this._formatOptions.setOptions(DataPreviewPage.this._dataFormat.getOptions());
                DataPreviewPage.this._formatPanel = DataPreviewPage.this._formatOptions.getFormatPanel();
                DataPreviewPage.this._formatPanel.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("FILE_FORMAT")));
                DataPreviewPage.this._format = DataPreviewPage.this._formatOptions.getFormatComponent();
                DataPreviewPage.this._format.setSelectedItem(DataPreviewPage.this._dataFormat.getFormat());
                if (!DataPreviewPage.this._dataFormat.isExcel() && !DataPreviewPage.this._dataFormat.isExcelX()) {
                    DataPreviewPage.this._format.addItemListener(DataPreviewPage.this._formatListener);
                    DataPreviewPage.this._formatOptions.getDelimiterComponent().addItemListener(DataPreviewPage.this._delimiterItemListener);
                    ((JTextField)DataPreviewPage.this._formatOptions.getDelimiterComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(DataPreviewPage.this._delimiterTextListener);
                    DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().addItemListener(DataPreviewPage.this._terminatorItemListener);
                    ((JTextField)DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(DataPreviewPage.this._terminatorTextListener);
                    DataPreviewPage.this._formatOptions.getSkipRowsComponent().addChangeListener(DataPreviewPage.this._skipRowsChangeListener);
                }
                if (DataPreviewPage.this._dataFormat.isHeaderLocationSupported()) {
                    DataPreviewPage.this._formatOptions.getHeaderLocationComponent().addActionListener(DataPreviewPage.this._headerLocationActionListener);
                }
                DataPreviewPage.this._formatPanel.revalidate();
                DataPreviewPage.this._formatPanel.repaint();
                DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
            }
        }
    };

    protected JPanel getDataChooser() {
        return this._dataChooser;
    }

    protected void setDataChooserText(String string) {
        this._dataChooser.setText(string);
    }

    protected String getDataChooserText() {
        return this._dataChooser.getText();
    }

    protected void initDataChooser() {
        this.initDataChooser(null);
    }

    protected String getDefaultFileType() {
        return "dsv";
    }

    protected void resetData(boolean bl) {
        this.resetData = bl;
    }

    private void addListeners() {
        if (this._formatOptions.getEncodingsComponent() != null) {
            this._formatOptions.getEncodingsComponent().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    String string;
                    if (itemEvent.getStateChange() == 1 && !(string = (String)((JComboBox)itemEvent.getSource()).getSelectedItem()).equals(DataPreviewPage.this._dataFormat.getEncoding())) {
                        DataPreviewPage.this._dataFormat.setEncoding(string);
                        DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
                        DataPreviewPage.this.resetData = true;
                    }
                }
            });
        }
        this._formatOptions.getHeaderComponent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataPreviewPage.this._dataFormat.isHeader(((JCheckBox)actionEvent.getSource()).isSelected());
                DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
            }
        });
        this._formatOptions.getUsePreviewLimitComponent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataPreviewPage.this._dataFormat.setUsePreviewLimit(((JCheckBox)actionEvent.getSource()).isSelected());
                DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
                DataPreviewPage.this.resetData = true;
            }
        });
        this._formatOptions.getPreviewLimitComponent().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DataPreviewPage.this._dataFormat.setPreviewLimit(((NumericSpinBox)changeEvent.getSource()).getIntValue());
                DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
                DataPreviewPage.this.resetData = true;
            }
        });
        this._formatOptions.getSkipRowsComponent().addChangeListener(this._skipRowsChangeListener);
        if (this._dataFormat.isHeaderLocationSupported()) {
            this._formatOptions.getHeaderLocationComponent().addActionListener(this._headerLocationActionListener);
        }
        this._format = this._formatOptions.getFormatComponent();
        if (this._format != null) {
            this._format.addItemListener(this._formatListener);
        }
        if (!this._dataFormat.isExcel() && !this._dataFormat.isExcelX()) {
            this._formatOptions.getDelimiterComponent().addKeyListener(this._keyListener);
            ((JTextField)this._formatOptions.getDelimiterComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(this._delimiterTextListener);
            this._formatOptions.getDelimiterComponent().addItemListener(this._delimiterItemListener);
            this._formatOptions.getEnclosuresLeftComponent().addKeyListener(this._keyListener);
            ((JTextField)this._formatOptions.getEnclosuresLeftComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(this._enclosureLeftTextListener);
            this._formatOptions.getEnclosuresRightComponent().addKeyListener(this._keyListener);
            ((JTextField)this._formatOptions.getEnclosuresRightComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(this._enclosureRightTextListener);
            this._formatOptions.getRecordTerminatorComponent().addKeyListener(this._keyListener);
            ((JTextField)this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(this._terminatorTextListener);
            this._formatOptions.getRecordTerminatorComponent().addItemListener(this._terminatorItemListener);
        } else if (this.pages > 1) {
            this._formatOptions.getWorksheetComponent().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ((JComboBox)actionEvent.getSource()).getSelectedIndex();
                    DataPreviewPage.this._dataFormat.setPageId(n);
                    DataPreviewPage.this._dataFormat.setWorksheet((String)((JComboBox)actionEvent.getSource()).getSelectedItem());
                    try {
                        DataPreviewPage.this._datareader.setPage(n);
                        DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
                        DataPreviewPage.this.resetData = true;
                    }
                    catch (DataReaderException dataReaderException) {
                        ExceptionHandler.handleException((Throwable)dataReaderException);
                    }
                }
            });
        }
    }

    public DataReadable getDataReader() {
        return this._datareader;
    }

    public void setDataReader(DataReadable dataReadable) {
        this._datareader = dataReadable;
        this.pages = dataReadable.getNosPages();
        String string = this._dataFormat.getRecordTerminator();
        this._dataGizmo.setDataReader(this._datareader);
        if (dataReadable.isLineTerminatorSupported() && string.equals(this._dataFormat.getRecordTerminator()) && this._formatOptions.getRecordTerminatorComponent() != null) {
            this._formatOptions.getRecordTerminatorComponent().setSelectedItem(this._dataFormat.getRecordTerminator());
        }
        this.validate();
        this.resetData = true;
    }

    private void populateDataTable(DataReadable dataReadable) {
        String string = this._dataFormat.getRecordTerminator();
        if (dataReadable.isLineTerminatorSupported() && !this._dataFormat.getRecordTerminator().equals(string)) {
            this._formatOptions.getRecordTerminatorComponent().setSelectedItem(dataReadable.getLineTerminator());
        }
        this._dataGizmo.populateDataTable(dataReadable);
        this._dataGizmo.resetData(true);
    }

    @Override
    public void raiseEvent(DataReaderEvent dataReaderEvent) {
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Serializable serializable;
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        if (this._isShowConfigPanel) {
            this._iProps.put(ImportKeys.IS_CONFIGFILE, this._isConfigUsed);
        }
        this._iProps.put(ImportKeys.IMPORT_DATA_FORMAT, this._dataFormat);
        if (this._dataFormat.getUsePreviewLimit()) {
            serializable = Integer.valueOf(this._dataFormat.getPreviewLimit());
            this._iProps.put(ImportKeys.PREVIEW_LIMIT, ((Integer)serializable).toString());
        }
        this._iProps.put(ImportKeys.PAGEID, this._dataFormat.getPageId());
        this._iProps.put(ImportKeys.LOCALE, Locale.getDefault());
        this._iProps.put(ImportKeys.GIZMO, this._dataGizmo);
        if (!this._isConfigUsed || this.resetData) {
            this._dataGizmo.createFields(this._loadFile);
            this._iProps.put(ImportKeys.LOAD_FILE, this._loadFile);
            this._dataGizmo.onExit(traversableContext);
            serializable = (ArrayList)this._loadFile.getFields();
            JTable jTable = this._dataGizmo.getTable();
            TableColumnModel tableColumnModel = jTable.getTableHeader().getColumnModel();
            ArrayList<Column> arrayList = new ArrayList<Column>();
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                Column column = new Column();
                column.setSourceColumnName(tableColumnModel.getColumn(i).getHeaderValue().toString());
                if (this._isExistingTable) {
                    column.setName("");
                } else {
                    column.setName(column.getSourceColumnName());
                }
                column.setSourceColID(this.getSourceID(column.getSourceColumnName()));
                column.setPrecision(this._datareader.getWidth(i));
                column.setType("VARCHAR2");
                column.setScale(0);
                column.setNullable(true);
                arrayList.add(i, column);
                ((LoadField)((ArrayList)serializable).get(i)).setColumn(column);
            }
            this._iProps.put(ImportKeys.FILE_COLUMNS, arrayList.toArray(new Column[arrayList.size()]));
            if (this._iProps.get(ImportKeys.SELECTABLE_COLUMNS) == null) {
                this._iProps.put(ImportKeys.SELECTED_COLUMNS, this._iProps.get(ImportKeys.FILE_COLUMNS));
                this._iProps.put(ImportKeys.SELECTABLE_COLUMNS, new Column[0]);
            }
            if (this.resetData) {
                this._iProps.put(ImportKeys.SELECTED_COLUMNS, this._iProps.get(ImportKeys.FILE_COLUMNS));
                this._iProps.put(ImportKeys.SELECTABLE_COLUMNS, new Column[0]);
            }
        } else {
            this._iProps.put(ImportKeys.LOAD_FILE, this._loadFile);
            this._dataGizmo.onExit(traversableContext);
        }
        this._iProps.put(ImportKeys.IS_EXISTING_TABLE, this._isExistingTable);
        if (this._datareader != null) {
            this._datareader.closeFile();
        }
    }

    private int getSourceID(String string) {
        int n = -1;
        String[] stringArray = this.getDataReader().getColumnNames();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public void showConfigPanel(boolean bl) {
        this._isShowConfigPanel = bl;
    }

    public void isBackEnabled(boolean bl) {
        this._isBackEnabled = bl;
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        this._iProps = (ImportProperties)this.m_ctx.get("IMPORT_PROPERTIES");
        if (!this.initUI) {
            DBObject dBObject;
            this.initUI = true;
            this._loadFile = new LoadFile("");
            if (this._isShowConfigPanel) {
                this.initConfigPanel();
            }
            this.initDataChooser();
            this.initUI();
            Object object = this._iProps.get(ImportKeys.DBOBJECT);
            if (object != null && object instanceof DBObject && (dBObject = (DBObject)object).getObjectType().equals("TABLE")) {
                this._isExistingTable = true;
            }
            this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(this._isBackEnabled), Boolean.valueOf(false), Boolean.valueOf(false));
        } else {
            this.remove(this._dataGizmo);
            this.add(this._dataGizmo, "Center");
            this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        }
        this.validate();
        if (this._dataGizmo != null) {
            this._dataGizmo.resetData(false);
        }
    }

    private void initUI() {
        this.setLayout(new BorderLayout(0, 16));
        this._filePanel = new JPanel(new BorderLayout(0, 8));
        if (this._isShowConfigPanel) {
            this._filePanel.add((Component)this._configPanel, "North");
        }
        this._filePanel.add((Component)this.getDataChooser(), "Center");
        this._dataFormat = this.getDefaultFormat(BaseDataFormat.IMPORT_WIZARD);
        this._formatOptions = new ImportFormatOptionsPanel(this._dataFormat);
        this._datareader = DataReaderRegistry.getReader(this.getDefaultFileType());
        this._formatOptions.setDataReader(this._datareader);
        this._formatPanel = this._formatOptions.getFormatPanel();
        this._formatPanel.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("FILE_FORMAT")));
        JPanel jPanel = new JPanel(new BorderLayout(0, 8));
        jPanel.add((Component)this._filePanel, "North");
        jPanel.add((Component)this._formatPanel, "South");
        this.add(jPanel, "North");
        this.add(jPanel, "North");
        this._dataGizmo = new DataPreviewGizmo(null);
        this._dataGizmo.initUI();
        this._dataGizmo.setEnabled(false);
        this.add(this._dataGizmo, "Center");
    }

    protected ImportDataFormat getDefaultFormat(int n) {
        return new ImportDataFormat(n, BaseDataFormat.DELIMITED);
    }

    private void initDataChooser(URL uRL) {
        this._dataChooser = URLFileChooser.createURLFileChooserPanel(0, DataImportArb.getString("DATA_FILE"), true, false);
        this._dataChooser.clearChooseableURLFilters();
        if (uRL == null) {
            this._defaultFileDir = DBConfig.getInstance().getString("IMPORTDIR");
            if (this._defaultFileDir == null || this._defaultFileDir.length() == 0) {
                this._defaultFileDir = DBConfig.getInstance().getString("EXPORTDIR");
            }
            File file = null;
            try {
                file = this._defaultFileDir == null || this._defaultFileDir.equals("") ? (NonUserConfigOptions.get("DEFAULT_EXPORT") == null || NonUserConfigOptions.get("DEFAULT_EXPORT").equals("") ? new File(System.getProperty("user.home")) : new File(NonUserConfigOptions.get("DEFAULT_EXPORT"))) : new File(this._defaultFileDir);
                this._lastURL = file.toURI().toURL();
                this._dataChooser.setText(this._defaultFileDir);
            }
            catch (Exception exception) {
                Logger.warn(this.getClass(), (Throwable)exception);
            }
        } else {
            this._dataChooser.setSelectedURL(uRL);
        }
        this._dataChooser.setEnabled(true);
        this._dataChooser.setCheckIfFileExists(false);
        this._dataChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                boolean bl = false;
                if (file != null) {
                    int n;
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = file.getName();
                    String string2 = null;
                    if (string != null && string.trim().length() > 0 && (n = string.lastIndexOf(46)) >= 0) {
                        string2 = string.substring(n + 1);
                    }
                    bl = "csv".equalsIgnoreCase(string2) || "xls".equalsIgnoreCase(string2) || "xlsx".equalsIgnoreCase(string2) || "txt".equalsIgnoreCase(string2) || "tsv".equalsIgnoreCase(string2) || "dsv".equalsIgnoreCase(string2);
                }
                return bl;
            }

            @Override
            public String getDescription() {
                String string = DataImportArb.getString("FILTER_DESCRIPTION");
                return string;
            }
        });
        this._dataChooser.setPathContext("IMPORTDIR");
        this._dataChooser.addActionListener(this._dataFileListener);
    }

    protected void newFileInit(String string) throws DataReaderException {
        try {
            this._datareader = DataReaderRegistry.getReader(string);
        }
        catch (Exception exception) {
            throw new DataReaderException(DataImportArb.format("OPEN_FILE_TYPE_ERROR", string), ExitCode.EXIT_SEVERE, false);
        }
        if (this._datareader == null) {
            throw new DataReaderException(DataImportArb.format("OPEN_FILE_TYPE_ERROR", string), ExitCode.EXIT_SEVERE, false);
        }
        if (this._datareader != null) {
            this._datareader.setFileName(this._loadFile.getName());
            if (this._iProps.get(ImportKeys.PAGEID) != null) {
                this._datareader.setPage((Integer)this._iProps.get(ImportKeys.PAGEID));
            }
            this._dataGizmo = new DataPreviewGizmo(this._datareader);
            this._formatOptions.setDataReader(this._datareader);
            this._formatPanel = this._formatOptions.getFormatPanel();
            this._formatPanel.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("FILE_FORMAT")));
            this._dataFormat = (ImportDataFormat)this._formatOptions.getProperties();
            this._dataGizmo.setDataFormat(this._dataFormat);
            this.pages = this._datareader.getNosPages();
            this.newFileInitUI();
            this.repaint();
            this.getParent().validate();
        }
    }

    protected void newFileInitUI() {
        this._dataGizmo.initUI();
        this.removeAll();
        JPanel jPanel = new JPanel(new BorderLayout(0, 8));
        jPanel.add((Component)this._filePanel, "North");
        jPanel.add((Component)this._formatPanel, "South");
        this.add(jPanel, "North");
        this.add(this._dataGizmo, "Center");
        this.setDataReader(this._datareader);
        this.addListeners();
        this.resetData = false;
    }

    private void initConfigPanel() {
        JButton jButton = new JButton(DataImportArb.getString("CONFIG_RESTORE_STATE"), RaptorImagesArb.getIcon("GEAR"));
        jButton.setToolTipText(DataImportArb.getString("OPEN_CONFIG_TIP"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataPreviewPage.this.openConfig();
            }
        });
        this._configPanel = new JPanel(new BorderLayout());
        this._configPanel.add((Component)jButton, "After");
    }

    private void openConfig() {
        String string = DataImportArb.getString("OPEN_CONFIG_DIALOG_TITLE");
        JPanel jPanel = new JPanel(new GridBagLayout());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_openimportconfig_html");
        this._configChooser = new URLFileChooser();
        this._configChooser.setPathContext(this.getClass().getName() + "_configChooser");
        this._configChooser.clearChooseableURLFilters();
        this._configChooser.setFileFilter(this._configFilter);
        int n = this._configChooser.showOpenDialog((Component)((Object)this), string);
        if (n == 0) {
            this._configFile = this._configChooser.getSelectedFile();
            if (this._configFile == null || this._configFile.isDirectory() || !this._configFile.isFile()) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataImportArb.getString("OPEN_CONFIG_ERROR"), (String)DataImportArb.getString("OPEN_CONFIG_ERROR_TITLE"), (String)"IMPORT_FILE_ERROR");
            } else {
                this.openConfigOptions(this._configFile);
            }
        }
    }

    public void openConfigOptions(File file) {
        try {
            boolean bl;
            this._exitCode = ExitCode.EXIT_SUCCESS;
            ImportXMLUtil importXMLUtil = new ImportXMLUtil();
            importXMLUtil.setImport(true);
            String string = "UTF-8";
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string);
            importXMLUtil.parseXML(inputStreamReader, true);
            inputStreamReader.close();
            ((InputStream)fileInputStream).close();
            String string2 = (String)this._iProps.get(ImportKeys.CONNECTION_NAME);
            DBObject dBObject = (DBObject)this._iProps.get(ImportKeys.DBOBJECT);
            String string3 = dBObject.getSchemaName() + "." + dBObject.getObjectName();
            if (this._loadFile != null && this._loadFile.getName().length() > 0 && !(bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DataImportArb.format("CONFIG_OPEN_ERROR29", this._loadFile.getName()), (String)DataImportArb.getString("CONFIG_WARN_TITLE"), (String)"FILE_OPEN_WARNING"))) {
                return;
            }
            this._exitCode = importXMLUtil.reconcileConfig(file.getName(), this._isExistingTable, string2, dBObject, null);
            String string4 = "";
            switch (this._exitCode) {
                case EXIT_SUCCESS: {
                    String string5 = DataImportArb.getString("EXIT_SUCCESS_LABEL");
                    break;
                }
                case EXIT_WARNING: 
                case EXIT_ERROR: {
                    final String string6 = this._exitCode.getSeverity() == ExitCode.EXIT_WARNING.getSeverity() ? DataImportArb.getString("EXIT_WARNING_LABEL") : DataImportArb.getString("EXIT_ERROR_LABEL");
                    JLabel jLabel = new JLabel(DataImportArb.format("CONFIG_OPEN_ERROR22", string6));
                    if (this._exitCode.getSeverity() == ExitCode.EXIT_ERROR.getSeverity()) {
                        jLabel.setIcon(OracleIcons.getIcon((String)"exception.png"));
                    } else {
                        jLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
                    }
                    JTextArea jTextArea = new JTextArea();
                    jTextArea.setText(DataImportArb.format("CONFIG_OPEN_ERROR14", this._loadFile.getName()) + "\n" + this._exitCode.getShortMessage().toString());
                    jTextArea.setEditable(false);
                    jTextArea.setCaretPosition(0);
                    JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 30);
                    jScrollPane.setPreferredSize(new Dimension(800, 100));
                    JButton jButton = new JButton(DataImportArb.getString("DETAILS"));
                    JPanel jPanel = new JPanel(new BorderLayout(0, 16));
                    jPanel.add((Component)jLabel, "North");
                    jPanel.add((Component)jScrollPane, "Center");
                    JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
                    jPanel2.add((Component)jButton, "East");
                    JPanel jPanel3 = new JPanel(new BorderLayout(0, 16));
                    jPanel3.add((Component)jPanel, "North");
                    jPanel3.add((Component)jPanel2, "South");
                    jButton.setToolTipText(DataImportArb.getString("OPEN_CONFIG_DETAILS_TIP"));
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            JLabel jLabel = new JLabel(DataImportArb.format("CONFIG_OPEN_ERROR22", string6));
                            if (DataPreviewPage.this._exitCode.getSeverity() == ExitCode.EXIT_ERROR.getSeverity()) {
                                jLabel.setIcon(OracleIcons.getIcon((String)"exception.png"));
                            } else {
                                jLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
                            }
                            JTextArea jTextArea = new JTextArea();
                            jTextArea.setText(DataImportArb.format("CONFIG_OPEN_ERROR14", DataPreviewPage.this._loadFile.getName()) + "\n" + DataPreviewPage.this._exitCode.getMessage().toString());
                            jTextArea.setEditable(false);
                            jTextArea.setCaretPosition(0);
                            JScrollPane jScrollPane = new JScrollPane(jTextArea);
                            JPanel jPanel = new JPanel(new BorderLayout(0, 16));
                            jPanel.add((Component)jLabel, "North");
                            jPanel.add((Component)jScrollPane, "Center");
                            HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_idedexporttabledata_html");
                            JEWTDialog jEWTDialog = DataPreviewPage.this.getDialog(jPanel, DataImportArb.getString("RESTORE_STATE_VAL_DETAILS_TITLE"));
                            jEWTDialog.setMinimumSize(new Dimension(300, 120));
                            WizardLauncher.runDialog((JDialog)jEWTDialog);
                        }
                    });
                    HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel3, "f1_idedexporttabledata_html");
                    JEWTDialog jEWTDialog = this.getDialog(jPanel3, DataImportArb.getString("RESTORE_STATE_VAL_TITLE"));
                    jEWTDialog.setMinimumSize(new Dimension(300, 120));
                    WizardLauncher.runDialog((JDialog)jEWTDialog);
                    break;
                }
                default: {
                    String string7 = DataImportArb.getString("EXIT_SEVERE_LABEL");
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)(DataImportArb.format("CONFIG_OPEN_ERROR22", string7) + "\n" + DataImportArb.getString("CONFIG_OPEN_ERROR23") + "\n" + this._exitCode.getMessage().toString()), (String)DataImportArb.getString("XML_FILE_ERROR_TITLE"), (String)"XML_FILE_ERROR_TITLE");
                    string4 = ImportHeadlessResources.format("IMPORT_VALIDATION_COMPLETED", string7) + "\n";
                    Logger.severe(this.getClass(), (String)(string4 + this._exitCode.getMessage()));
                    throw new InvalidCommandArgumentException(string4 + this._exitCode.getMessage());
                }
            }
            this._loadFile = (LoadFile)importXMLUtil.getPropertyValueObject(ImportKeys.LOAD_FILE);
            this._iProps.put(ImportKeys.TABLE, (GenericTable)importXMLUtil.getPropertyValueObject(ImportKeys.TABLE));
            this._iProps.put(ImportKeys.TABLE_NAME, importXMLUtil.getPropertyValue(ImportKeys.TABLE_NAME));
            this._dataFormat = (ImportDataFormat)importXMLUtil.getPropertyValueObject(ImportKeys.IMPORT_DATA_FORMAT);
            this._iProps.put(ImportKeys.PAGEID, this._dataFormat.getPageId());
            this._formatOptions = new ImportFormatOptionsPanel(BaseDataFormat.IMPORT_WIZARD, this._loadFile.getType());
            this._datareader = importXMLUtil.getDataReader();
            this._dataGizmo = importXMLUtil.getDataGizmo();
            this._formatOptions.setDataFormat(this._dataFormat);
            this._formatOptions.setDataReader(this._datareader);
            this._formatPanel = this._formatOptions.getFormatPanel();
            this._formatPanel.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("FILE_FORMAT")));
            this.setDataChooserText(this._loadFile.getName());
            this.newFileInitUI();
            this._iProps.put(ImportKeys.LOAD_METHOD, importXMLUtil.getPropertyValueInt(ImportKeys.LOAD_METHOD));
            this._iProps.put(ImportKeys.STAGING_TABLE_NAME, importXMLUtil.getPropertyValue(ImportKeys.STAGING_TABLE_NAME));
            this._iProps.put(ImportKeys.DROP_STAGING_TABLE, importXMLUtil.getPropertyValueBoolean(ImportKeys.DROP_STAGING_TABLE));
            this._iProps.put(ImportKeys.IS_EXISTING_TABLE, importXMLUtil.getPropertyValueBoolean(ImportKeys.IS_EXISTING_TABLE));
            this._iProps.put(ImportKeys.TABLE_NAME, importXMLUtil.getPropertyValue(ImportKeys.TABLE_NAME));
            this._iProps.put(ImportKeys.USE_LOAD_LIMIT, importXMLUtil.getPropertyValueBoolean(ImportKeys.USE_LOAD_LIMIT));
            this._iProps.put(ImportKeys.LOAD_LIMIT, importXMLUtil.getPropertyValueInt(ImportKeys.LOAD_LIMIT));
            this._iProps.put(ImportKeys.SEND_TO_WORKSHEET, importXMLUtil.getPropertyValueBoolean(ImportKeys.SEND_TO_WORKSHEET));
            this._iProps.put(ImportKeys.FILE_COLUMNS, importXMLUtil.getPropertyValueObject(ImportKeys.FILE_COLUMNS));
            this._iProps.put(ImportKeys.SELECTED_COLUMNS, importXMLUtil.getPropertyValueObject(ImportKeys.SELECTED_COLUMNS));
            this._iProps.put(ImportKeys.SELECTABLE_COLUMNS, importXMLUtil.getPropertyValueObject(ImportKeys.SELECTABLE_COLUMNS));
            this._iProps.put(ImportKeys.MATCH_BY_TYPE, importXMLUtil.getPropertyValueInt(ImportKeys.MATCH_BY_TYPE));
            int n = (Integer)this._iProps.get(ImportKeys.LOAD_METHOD);
            if (n == 2 || n == 3) {
                this._iProps.put(ImportKeys.DIRPATH, importXMLUtil.getPropertyValue(ImportKeys.DIRPATH));
                this._iProps.put(ImportKeys.ORADIRNAME, importXMLUtil.getPropertyValue(ImportKeys.ORADIRNAME));
                this._iProps.put(ImportKeys.USEBADFILE, importXMLUtil.getPropertyValueBoolean(ImportKeys.USEBADFILE));
                this._iProps.put(ImportKeys.ORABADDIRNAME, importXMLUtil.getPropertyValue(ImportKeys.ORABADDIRNAME));
                this._iProps.put(ImportKeys.USELOGFILE, importXMLUtil.getPropertyValueBoolean(ImportKeys.USELOGFILE));
                this._iProps.put(ImportKeys.ORALOGDIRNAME, importXMLUtil.getPropertyValue(ImportKeys.ORALOGDIRNAME));
                this._iProps.put(ImportKeys.USEDISCARDFILE, importXMLUtil.getPropertyValueBoolean(ImportKeys.USEDISCARDFILE));
                this._iProps.put(ImportKeys.ORADISCARDDIRNAME, importXMLUtil.getPropertyValue(ImportKeys.ORADISCARDDIRNAME));
            } else if (n == 4) {
                this._iProps.put(ImportKeys.BADDIRNAME, importXMLUtil.getPropertyValue(ImportKeys.BADDIRNAME));
                this._iProps.put(ImportKeys.LOGDIRNAME, importXMLUtil.getPropertyValue(ImportKeys.LOGDIRNAME));
                this._iProps.put(ImportKeys.USEGENDIR, importXMLUtil.getPropertyValueBoolean(ImportKeys.USEGENDIR));
                this._iProps.put(ImportKeys.GENDIR, importXMLUtil.getPropertyValue(ImportKeys.GENDIR));
                this._iProps.put(ImportKeys.FILEOUTNEWLINE, importXMLUtil.getPropertyValue(ImportKeys.FILEOUTNEWLINE));
            }
            this._iProps.put(ImportKeys.CHARNUMCHARACTERS, importXMLUtil.getPropertyValue(ImportKeys.CHARNUMCHARACTERS));
            this._iProps.put(ImportKeys.CHARSETVAL, importXMLUtil.getPropertyValue(ImportKeys.CHARSETVAL));
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        this._isConfigUsed = true;
    }

    private JEWTDialog getDialog(Component component, String string) {
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)component, null, (String)string, (int)5);
        jEWTDialog.setResizable(true);
        jEWTDialog.setOKButtonEnabled(true);
        return jEWTDialog;
    }

    private ExitCode getExitCodeHighest(ExitCode exitCode, ExitCode exitCode2) {
        return exitCode2.getSeverity() > exitCode.getSeverity() ? exitCode2 : exitCode;
    }

    public void openConfigOptions() {
        URL uRL = this._configChooser.getSelectedURL();
    }

    boolean isValid(String string) {
        if (string.length() == 1 && (string.equals("X") || string.equals("x")) || string.length() > 1 && (string.substring(0, 2).equals("X'") || string.substring(0, 2).equals("x'"))) {
            return string.length() > 3 && string.endsWith("'");
        }
        return string.length() != 0;
    }

    public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
    }

    public void commit(ApplyEvent applyEvent) throws TraversalException {
        if (this._datareader != null) {
            this._datareader.closeFile();
        }
    }

    public void rollback(ApplyEvent applyEvent) {
    }

    public void cancel(ApplyEvent applyEvent) {
        if (this._datareader != null) {
            this._datareader.closeFile();
        }
    }
}

