/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl.oracle;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.ddl.IObjectDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleMetaSetup;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.base.ViewerAddin;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.xml.MetadataManifest;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.ora.OracleDDLGenerator;

public abstract class OracleObjectDDL
implements IObjectDDL {
    protected static final String LIST_OBJECTS = "list_objects";
    protected static final String GRANT_SQL = "grant_sql";
    protected static final String SCRIPT_DDL = "script_ddl";
    protected static final String DDL_KEY = "ddl_key";
    Writer _out = DDLGenerator.getInstance().getWriter();
    DDLFormat _format = DDLGenerator.getInstance().getFormating();
    private String _filter;
    protected String _EOL;
    private static MetadataManifest manifest = null;

    private String getHeaderFmt() {
        String string = this.getTerm();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + "--------------------------------------------------------" + string);
        stringBuilder.append("--  {0} for {1} {2}" + string);
        stringBuilder.append("--------------------------------------------------------" + string);
        return stringBuilder.toString();
    }

    protected final String getHeader(String string, String string2) {
        return MessageFormat.format(this.getHeaderFmt(), "DDL", string, string2);
    }

    protected final String getSubHeader(String string, String string2, String string3) {
        return MessageFormat.format(this.getHeaderFmt(), string3, string, string2);
    }

    protected String getDDLHeader(DBObject dBObject) {
        return "";
    }

    protected String getQueryKey(String string) {
        return DDL_KEY.equals(string) ? SCRIPT_DDL : string;
    }

    protected final String getTerm() {
        if (this._EOL == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this._EOL = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return this._EOL;
    }

    protected String getQueryFile() {
        return this.getDefaultQueryFile();
    }

    private String getDefaultQueryFile() {
        MetadataManifest metadataManifest = OracleObjectDDL.getManifest();
        if (metadataManifest != null) {
            return "META-INF/ddl/oracle/ObjectSql.xml";
        }
        return "/oracle/dbtools/raptor/ddl/oracle/ObjectSql.xml";
    }

    protected final String getQuery(Connection connection, String string) {
        Query query = this.getQueryFromFile(connection, string, this.getQueryFile());
        if (query == null) {
            query = this.getQueryFromFile(connection, string, this.getDefaultQueryFile());
        }
        return query.getSql();
    }

    private Query getQueryFromFile(Connection connection, String string, String string2) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(this.getClass().getClassLoader(), string2));
        Query query = queryXMLSupport.getQuery(string, connection);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doGetDDL(DBObject dBObject) {
        String string;
        String string2 = this.getQuery(dBObject.getConnection(), this.getQueryKey(DDL_KEY));
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("OWNER", dBObject.getSchemaName());
        hashMap.put("NAME", dBObject.getObjectName());
        ResultSet resultSet = null;
        Connection connection = dBObject.getConnection();
        if (Connections.getInstance().lock(connection)) {
            block8: {
                try {
                    string = DBUtil.getInstance((Connection)connection);
                    string.setRaiseError(false);
                    resultSet = string.executeQuery(string2, hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            stringBuilder.append(resultSet.getString(1) + this._EOL);
                        }
                        break block8;
                    }
                    this.generateOldWay(dBObject, stringBuilder);
                }
                catch (SQLException sQLException) {
                    try {
                        stringBuilder = new StringBuilder();
                        this.generateOldWay(dBObject, stringBuilder);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        string = stringBuilder.toString();
        if (!this._format.getSchema()) {
            string = string.replace("\"" + dBObject.getSchemaName() + "\".", "");
        }
        return string;
    }

    @Override
    public String getDDL(DBObject dBObject) throws Exception {
        return this.getDDL(dBObject, "DDL ");
    }

    @Override
    public String getDDL(DBObject dBObject, String string) throws Exception {
        this.getTerm();
        new OracleMetaSetup(dBObject.getConnection(), string);
        return this.doGetDDL(dBObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doGetDDLScript(DBObject dBObject) {
        String string;
        String string2 = this.getQuery(dBObject.getConnection(), this.getQueryKey(SCRIPT_DDL));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("OWNER", dBObject.getSchemaName());
        hashMap.put("NAME", dBObject.getObjectName());
        StringBuilder stringBuilder = new StringBuilder();
        ResultSet resultSet = null;
        Connection connection = dBObject.getConnection();
        if (Connections.getInstance().lock(connection)) {
            block9: {
                try {
                    string = DBUtil.getInstance((Connection)connection);
                    string.setRaiseError(false);
                    resultSet = string.executeQuery(string2, hashMap);
                    if (resultSet != null) {
                        if (resultSet.next()) {
                            stringBuilder.append(this.getDDLHeader(dBObject));
                            do {
                                stringBuilder.append(resultSet.getString(1) + this.getTerm());
                            } while (resultSet.next());
                        }
                        break block9;
                    }
                    this.generateOldWay(dBObject, stringBuilder);
                }
                catch (SQLException sQLException) {
                    try {
                        stringBuilder = new StringBuilder();
                        this.generateOldWay(dBObject, stringBuilder);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        string = stringBuilder.toString();
        if (!this._format.getSchema()) {
            string = string.replace("\"" + dBObject.getSchemaName() + "\".", "");
        }
        return string;
    }

    @Override
    public String getCopyDDL(DBObject dBObject) throws Exception {
        this.getTerm();
        new OracleMetaSetup(dBObject.getConnection(), "COPY");
        return this.doGetDDLScript(dBObject);
    }

    @Override
    public String getScriptDDL(DBObject dBObject) throws Exception {
        this.getTerm();
        new OracleMetaSetup(dBObject.getConnection(), "SCRIPT");
        return this.doGetDDLScript(dBObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getGrantsDDL(DBObject dBObject) throws Exception {
        this.getTerm();
        new OracleMetaSetup(dBObject.getConnection(), "SCRIPT");
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getQuery(dBObject.getConnection(), this.getQueryKey(GRANT_SQL));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER", dBObject.getSchemaName());
        hashMap.put("NAME", dBObject.getObjectName());
        Connection connection = dBObject.getConnection();
        if (Connections.getInstance().lock(connection)) {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(false);
            ResultSet resultSet = dBUtil.executeQuery(string, hashMap);
            try {
                if (resultSet != null) {
                    while (resultSet.next()) {
                        stringBuilder.append(resultSet.getString(1) + this._EOL);
                    }
                } else {
                    stringBuilder.append("");
                }
            }
            catch (Exception exception) {
                stringBuilder.append("");
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
            }
            Connections.getInstance().unlock(connection);
        }
        return stringBuilder.toString();
    }

    protected Map<String, String> getObjectBinds(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER", string);
        hashMap.put("TYPE", string2);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ArrayList<DBObject> getSchemaObjects(Connection connection, String string, String string2) {
        String string3 = this.getQuery(connection, this.getQueryKey(LIST_OBJECTS));
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        URL uRL = null;
        ResultSet resultSet = null;
        Map<String, String> map = this.getObjectBinds(string, string2);
        resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string3, map);
        String string4 = Connections.getInstance().getConnectionName(connection);
        try {
            while (resultSet.next()) {
                URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string4, null, string, string2);
                uRL = DBURLFormatHelper.getURL(uRL2, resultSet.getString(1));
                arrayList.add(new DBObject(uRL));
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            DBUtil.closeResultSet((ResultSet)resultSet);
        }
        return arrayList;
    }

    @Override
    public void setFilter(String string) {
        this._filter = string;
    }

    public String getFilter() {
        return this._filter;
    }

    protected void generateOldWay(DBObject dBObject, StringBuilder stringBuilder) {
        Database database = dBObject.getDatabase();
        try {
            if (database != null && dBObject.getSchemaObject() != null) {
                OracleDDLGenerator oracleDDLGenerator = new OracleDDLGenerator((DBObjectProvider)database);
                Ddl ddl = oracleDDLGenerator.getCreateDDL(dBObject.getSchemaObject(), false, false);
                Set set = ddl.keySet();
                Iterator iterator = set.iterator();
                StringBuilder stringBuilder2 = new StringBuilder();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String string2 = ddl.get(string);
                    stringBuilder2.append(string2);
                }
                if (stringBuilder2.length() > 0) {
                    stringBuilder.append(ExportWizArb.format("DDLUseInternalGen", dBObject.getObjectType(), dBObject.getSchemaName(), dBObject.getObjectName()) + this._EOL);
                    stringBuilder.append(stringBuilder2 + this._EOL);
                }
            }
        }
        catch (Exception exception) {
            stringBuilder.append(ExportWizArb.format("DDLUseInternalGen", dBObject.getObjectType(), dBObject.getSchemaName(), dBObject.getObjectName()) + this._EOL);
        }
    }

    public static MetadataManifest getManifest() {
        ClassLoader classLoader;
        URL uRL;
        if (manifest == null && (uRL = (classLoader = ViewerAddin.class.getClassLoader()).getResource("META-INF/metadata.json")) != null) {
            try (InputStream inputStream = uRL.openStream();){
                manifest = MetadataManifest.createManifest((InputStream)inputStream);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return manifest;
    }
}

