/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.dataobject;

import javafx.beans.DefaultProperty;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.metrics.dataobject.BooleanDataObject;
import oracle.dbtools.raptor.metrics.dataobject.BooleanExpressionDataObject;
import oracle.dbtools.raptor.metrics.engine.DXListenerList;

@DefaultProperty(value="items")
public abstract class BooleanCollectionExpressionDataObject
extends BooleanExpressionDataObject {
    private final ObservableList<BooleanDataObject> items = FXCollections.observableArrayList();
    private ObservableBooleanValue observable;
    private BooleanExpression connected;
    private BooleanExpression available;

    public ObservableList<BooleanDataObject> getItems() {
        return this.items;
    }

    @Override
    public BooleanExpression getConnected() {
        return this.connected;
    }

    @Override
    public BooleanExpression getAvailable() {
        return this.available;
    }

    @Override
    public void initialize() {
        for (BooleanDataObject booleanDataObject : this.items) {
            booleanDataObject.initialize();
            if (this.available == null) {
                this.available = booleanDataObject.getAvailable();
                this.connected = booleanDataObject.getConnected();
                continue;
            }
            this.available = Bindings.and((ObservableBooleanValue)this.available, (ObservableBooleanValue)booleanDataObject.getAvailable());
            this.connected = Bindings.and((ObservableBooleanValue)this.connected, (ObservableBooleanValue)booleanDataObject.getConnected());
        }
        this.observable = this.createObservable(this.items);
    }

    @Override
    public void registerListener(String string, DXListenerList dXListenerList) {
        for (BooleanDataObject booleanDataObject : this.items) {
            booleanDataObject.registerListener(string, dXListenerList);
        }
    }

    @Override
    public void unregisterListener(DXListenerList dXListenerList) {
        for (BooleanDataObject booleanDataObject : this.items) {
            booleanDataObject.unregisterListener(dXListenerList);
        }
    }

    @Override
    public ObservableBooleanValue getObservable() {
        return this.observable;
    }

    protected abstract ObservableBooleanValue createObservable(ObservableList<BooleanDataObject> var1);
}

