/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.dataobject;

import javafx.beans.DefaultProperty;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.metrics.dataobject.DataObject;
import oracle.dbtools.raptor.metrics.dataobject.Formatter;
import oracle.dbtools.raptor.metrics.dataobject.StringExpressionDataObject;
import oracle.dbtools.raptor.metrics.engine.DXListenerList;

@DefaultProperty(value="items")
public class FormattedString
extends StringExpressionDataObject {
    private ObservableStringValue observable;
    private BooleanExpression available;
    private BooleanExpression connected;
    private final StringProperty formatProperty = new SimpleStringProperty((Object)this, "format", "%s");
    private final ObservableList<DataObject> items = FXCollections.observableArrayList();

    public String getFormat() {
        return (String)this.formatProperty.get();
    }

    public void setFormat(String string) {
        this.formatProperty.set((Object)string);
    }

    public StringProperty formatProperty() {
        return this.formatProperty;
    }

    public ObservableList<DataObject> getItems() {
        return this.items;
    }

    @Override
    public ObservableStringValue getObservable() {
        return this.observable;
    }

    @Override
    public BooleanExpression getConnected() {
        return this.connected;
    }

    @Override
    public BooleanExpression getAvailable() {
        return this.available;
    }

    @Override
    public void initialize() {
        String string = this.getFormat();
        ObservableValue[] observableValueArray = new ObservableValue[this.items.size()];
        int n = 0;
        for (DataObject dataObject : this.items) {
            dataObject.initialize();
            observableValueArray[n++] = dataObject.getObservable();
            if (this.available == null) {
                this.available = dataObject.getAvailable();
                this.connected = dataObject.getConnected();
                continue;
            }
            this.available = this.available.and((ObservableBooleanValue)dataObject.getAvailable());
            this.connected = this.connected.and((ObservableBooleanValue)dataObject.getConnected());
        }
        if (string != null) {
            this.observable = this.createBinding(string, observableValueArray);
        }
    }

    @Override
    public void registerListener(String string, DXListenerList dXListenerList) {
        for (DataObject dataObject : this.items) {
            dataObject.registerListener(string, dXListenerList);
        }
    }

    @Override
    public void unregisterListener(DXListenerList dXListenerList) {
        for (DataObject dataObject : this.items) {
            dataObject.unregisterListener(dXListenerList);
        }
    }

    private StringBinding createBinding(final String string, final ObservableValue[] observableValueArray) {
        return new StringBinding(){
            {
                super.bind((Observable[])observableValueArray);
            }

            public void dispose() {
                super.unbind((Observable[])observableValueArray);
            }

            protected String computeValue() {
                Object[] objectArray = new Object[observableValueArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = observableValueArray[i].getValue();
                }
                return Formatter.format(string, objectArray);
            }

            public ObservableList<Observable> getDependencies() {
                return FXCollections.unmodifiableObservableList((ObservableList)FXCollections.observableArrayList((Object[])observableValueArray));
            }
        };
    }
}

