/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.dataobject;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.dataobject.DateTimeFormatter;
import oracle.dbtools.raptor.metrics.dataobject.DefaultFormatter;
import oracle.dbtools.raptor.metrics.dataobject.DurationFormatter;

public abstract class Formatter {
    private static final Map<String, Formatter> registry = new HashMap<String, Formatter>();

    public static String format(String string, Object ... objectArray) {
        Formatter formatter;
        String string2 = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '{') {
                int n = string.indexOf(125, i);
                if (n < 0) {
                    Logger.getLogger(Formatter.class.getName()).log(Level.WARNING, "invalid format string: {0}", string);
                    return string;
                }
                string2 = string.substring(i + 1, n);
                string = string.substring(n + 1);
                break;
            }
            if (!Character.isWhitespace((int)c)) break;
        }
        if (string2 == null) {
            string2 = "Default";
        }
        if ((formatter = registry.get(string2)) == null) {
            Logger.getLogger(Formatter.class.getName()).log(Level.WARNING, "formatter not found: " + string2);
            return string;
        }
        return formatter.formatImpl(string, objectArray);
    }

    protected abstract String formatImpl(String var1, Object ... var2);

    static {
        registry.put("Default", new DefaultFormatter());
        registry.put("Duration", new DurationFormatter());
        registry.put("DateTime", new DateTimeFormatter());
    }
}

