/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.dataobject;

import javafx.beans.DefaultProperty;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableStringValue;
import oracle.dbtools.raptor.metrics.dataobject.NumberDataObject;
import oracle.dbtools.raptor.metrics.dataobject.StringExpressionDataObject;
import oracle.dbtools.raptor.metrics.engine.DXListenerList;

@DefaultProperty(value="item")
public class PrefixFormString
extends StringExpressionDataObject {
    private static final String[] prefixes = new String[]{"k", "M", "G", "T", "P", "E", "Z", "Y"};
    private ObservableStringValue observable;
    private final StringProperty unitProperty = new SimpleStringProperty((Object)this, "unit");
    private final BooleanProperty treatZeroAsNullProperty = new SimpleBooleanProperty((Object)this, "treatZeroAsNull", false);
    private final ObjectProperty<NumberDataObject> itemProperty = new SimpleObjectProperty((Object)this, "items");

    public String getUnit() {
        return (String)this.unitProperty.get();
    }

    public void setUnit(String string) {
        this.unitProperty.set((Object)string);
    }

    public StringProperty unitProperty() {
        return this.unitProperty;
    }

    public boolean isTreatZeroAsNull() {
        return this.treatZeroAsNullProperty.get();
    }

    public void setTreatZeroAsNull(boolean bl) {
        this.treatZeroAsNullProperty.set(bl);
    }

    public BooleanProperty treatZeroAsNullProperty() {
        return this.treatZeroAsNullProperty;
    }

    public NumberDataObject getItem() {
        return (NumberDataObject)this.itemProperty.get();
    }

    public void setItem(NumberDataObject numberDataObject) {
        this.itemProperty.set((Object)numberDataObject);
    }

    public ObjectProperty<NumberDataObject> itemProperty() {
        return this.itemProperty;
    }

    @Override
    public ObservableStringValue getObservable() {
        return this.observable;
    }

    @Override
    public BooleanExpression getConnected() {
        return this.getItem().getConnected();
    }

    @Override
    public BooleanExpression getAvailable() {
        return this.getItem().getAvailable();
    }

    @Override
    public void initialize() {
        this.getItem().initialize();
        this.observable = this.createBinding(this.getItem().getObservable(), this.getUnit());
    }

    @Override
    public void registerListener(String string, DXListenerList dXListenerList) {
        this.getItem().registerListener(string, dXListenerList);
    }

    @Override
    public void unregisterListener(DXListenerList dXListenerList) {
        this.getItem().unregisterListener(dXListenerList);
    }

    private StringBinding createBinding(final ObservableNumberValue observableNumberValue, final String string) {
        return new StringBinding(){
            {
                super.bind(new Observable[]{observableNumberValue});
            }

            protected String computeValue() {
                String string3 = null;
                double d = observableNumberValue.doubleValue();
                if (d == 0.0 && PrefixFormString.this.isTreatZeroAsNull()) {
                    string3 = "";
                } else if (Math.abs(d) < 1024.0) {
                    string3 = string != null ? String.format("%.1f %s", d, string) : String.format("%.1f", d);
                } else {
                    for (String string2 : prefixes) {
                        if (!(Math.abs(d /= 1024.0) < 1024.0)) continue;
                        if (string != null) {
                            string3 = String.format("%.1f %s%s", d, string2, string);
                            break;
                        }
                        string3 = String.format("%.1f %s", d, string2);
                        break;
                    }
                    if (string3 == null) {
                        string3 = string != null ? String.format("%.1f %s%s", d, prefixes[prefixes.length - 1], string) : String.format("%.1f %s", d, prefixes[prefixes.length - 1]);
                    }
                }
                return string3;
            }
        };
    }
}

