/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXMLLoader;
import oracle.dbtools.raptor.metrics.engine.AbstractSource;
import oracle.dbtools.raptor.metrics.engine.SourceType;
import oracle.dbtools.raptor.support.MetaURLReference;

class MergeSet {
    private final URL url;
    private final SourceType sourceType;
    private int usageCount;
    private int runnableCount;

    MergeSet(MetaURLReference metaURLReference) {
        this.url = metaURLReference.getURL();
        SourceType sourceType = null;
        try (InputStream inputStream = metaURLReference.openInputStream();){
            sourceType = this.load(metaURLReference.getReferenceClassLoader(), this.url.toString(), inputStream);
            if (sourceType == null) {
                Logger.getLogger(MergeSet.class.getPackage().getName()).log(Level.WARNING, "no loadable metrics definitions were found in ''{0}''", this.url.toString());
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "unable to load metrics definition file '" + this.url.toString() + "'", iOException);
        }
        this.sourceType = sourceType;
        this.usageCount = 1;
        this.runnableCount = 0;
    }

    URL getURL() {
        return this.url;
    }

    SourceType getSourceType() {
        return this.sourceType;
    }

    void addUse() {
        ++this.usageCount;
    }

    void releaseUse(Runnable runnable) {
        --this.usageCount;
        this.check(runnable);
    }

    void addRunnable() {
        ++this.runnableCount;
    }

    void releaseRunnable(Runnable runnable) {
        --this.runnableCount;
        this.check(runnable);
    }

    private void check(Runnable runnable) {
        if (this.usageCount == 0 && this.runnableCount == 0) {
            runnable.run();
        }
    }

    private SourceType load(ClassLoader classLoader, String string, InputStream inputStream) {
        SourceType sourceType = null;
        FXMLLoader fXMLLoader = new FXMLLoader();
        fXMLLoader.setClassLoader(classLoader);
        try {
            AbstractSource abstractSource = (AbstractSource)fXMLLoader.load(inputStream);
            sourceType = (SourceType)abstractSource.createTypeObject(classLoader);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "fxml load error: {0}: {1}", new Object[]{string, exception});
            throw new IllegalArgumentException("fxmlURL", exception);
        }
        return sourceType;
    }
}

