/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.Tooltip;
import javafx.scene.input.ContextMenuEvent;
import javafx.util.Callback;
import oracle.dbtools.raptor.metrics.dataobject.Formatter;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.AbstractNonfacetObject;
import oracle.dbtools.raptor.metrics.panel.AbstractTableFeatureSet;
import oracle.dbtools.raptor.metrics.panel.AbstractTableMonitor;
import oracle.dbtools.raptor.metrics.panel.CellChangeIndicator;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.TableFeatureSet;
import oracle.dbtools.raptor.metrics.panel.TableFeatureSetHelper;
import oracle.dbtools.raptor.metrics.panel.TableFeatureSetSelector;

public abstract class AbstractCellFactory<C extends TableColumnBase<?, Object>, L extends IndexedCell<?>>
extends AbstractNonfacetObject
implements Callback<C, L> {
    private final StringProperty valueColumnProperty = new SimpleStringProperty((Object)this, "valueColumn");
    private final StringProperty textColumnProperty = new SimpleStringProperty((Object)this, "textColumn");
    private final StringProperty textFormatProperty = new SimpleStringProperty((Object)this, "textFormat", "%s");
    private final StringProperty tooltipColumnProperty = new SimpleStringProperty((Object)this, "tooltipColumn");
    private final StringProperty tooltipFormatProperty = new SimpleStringProperty((Object)this, "tooltipFormat", "%s");
    private final ObjectProperty<ContextMenu> contextMenuProperty = new SimpleObjectProperty((Object)this, "contextMenu");
    private final ObservableList<TableFeatureSetSelector<TableFeatureSet>> featureSetSelectors = FXCollections.observableArrayList();
    private Context context;
    private Control tableView;
    private AbstractTableMonitor monitor;
    private boolean monitorDependenciesInitialized = false;
    private boolean cacheInitialized = false;
    private List<String> cachedTextColumns;
    private String cachedTooltipFormat;
    private List<String> cachedTooltipColumns;
    private TableFeatureSetHelper<AbstractTableFeatureSet> featureSetHelper;
    private boolean translateTextValues;

    public String getValueColumn() {
        return (String)this.valueColumnProperty.get();
    }

    public void setValueColumn(String string) {
        this.valueColumnProperty.set((Object)string);
    }

    public StringProperty valueColumnProperty() {
        return this.valueColumnProperty;
    }

    public String getTextFormat() {
        return (String)this.textFormatProperty.get();
    }

    public void setTextFormat(String string) {
        this.textFormatProperty.set((Object)string);
    }

    public StringProperty textFormatProperty() {
        return this.textFormatProperty;
    }

    public String getTextColumn() {
        return (String)this.textColumnProperty.get();
    }

    public void setTextColumn(String string) {
        this.textColumnProperty.set((Object)string);
    }

    public StringProperty textColumnProperty() {
        return this.textColumnProperty;
    }

    public String getTooltipFormat() {
        return (String)this.tooltipFormatProperty.get();
    }

    public void setTooltipFormat(String string) {
        this.tooltipFormatProperty.set((Object)string);
    }

    public StringProperty tooltipFormatProperty() {
        return this.tooltipFormatProperty;
    }

    public String getTooltipColumn() {
        return (String)this.tooltipColumnProperty.get();
    }

    public void setTooltipColumn(String string) {
        this.tooltipColumnProperty.set((Object)string);
    }

    public StringProperty tooltipColumnProperty() {
        return this.tooltipColumnProperty;
    }

    public ContextMenu getContextMenu() {
        return (ContextMenu)this.contextMenuProperty.get();
    }

    public void setContextMenu(ContextMenu contextMenu) {
        this.contextMenuProperty.set((Object)contextMenu);
    }

    public ObjectProperty<ContextMenu> contextMenuProperty() {
        return this.contextMenuProperty;
    }

    public ObservableList<TableFeatureSetSelector<TableFeatureSet>> getFeatureSetSelectors() {
        return this.featureSetSelectors;
    }

    public L call(C c) {
        final Object l = this.createCell();
        this.ensureCacheInitialized();
        this.ensureTooltipsInitialized(l);
        l.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(){

            public void changed(ObservableValue<? extends Scene> observableValue, Scene scene, Scene scene2) {
                l.sceneProperty().removeListener((ChangeListener)this);
                AbstractCellFactory.this.ensureMonitorDependenciesInitialized(l);
                l.addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, contextMenuEvent -> {
                    AbstractCellFactory.this.showContextMenu(l, contextMenuEvent.getScreenX(), contextMenuEvent.getScreenY());
                    contextMenuEvent.consume();
                });
            }
        });
        CellChangeIndicator cellChangeIndicator = this.context.getFacet(CellChangeIndicator.class, (Map<Object, Object>)this.tableView.getProperties());
        if (cellChangeIndicator != null) {
            l.itemProperty().addListener((observableValue, object, object2) -> cellChangeIndicator.onCellUpdate((IndexedCell<?>)l));
            l.indexProperty().addListener((observableValue, number, number2) -> cellChangeIndicator.onCellUpdate((IndexedCell<?>)l));
        }
        return l;
    }

    public String getValueAsText(L l) {
        String string = null;
        String string2 = this.getTextFormat();
        DXRow dXRow = this.getRow(l);
        if (dXRow != null) {
            Object object;
            ObjectProperty<Comparable> objectProperty = dXRow.get(this.getValueColumn(), Comparable.class);
            Object object2 = object = objectProperty != null ? objectProperty.get() : null;
            if (string2 != null) {
                string = Formatter.format(string2, object);
            } else if (object != null) {
                string = object.toString();
            }
            if (this.translateTextValues) {
                string = this.translateTextValue(dXRow, string);
            }
        }
        return string;
    }

    public String getColumnText(L l) {
        String string = null;
        String string2 = this.getTextFormat();
        DXRow dXRow = this.getRow(l);
        if (dXRow != null && string2 != null && this.cachedTextColumns != null) {
            Object[] objectArray = new Object[this.cachedTextColumns.size()];
            for (int i = 0; i < this.cachedTextColumns.size(); ++i) {
                ObjectProperty<Comparable> objectProperty = dXRow.get(this.cachedTextColumns.get(i), Comparable.class);
                Object object = objectProperty != null ? objectProperty.get() : null;
                objectArray[i] = object != null && object instanceof String && this.translateTextValues ? this.translateTextValue(this.getRow(l), object.toString()) : object;
            }
            string = Formatter.format(string2, objectArray);
        }
        return string;
    }

    public String getTooltipText(L l) {
        String string = null;
        if (this.cachedTooltipFormat != null) {
            Object[] objectArray = new Object[this.cachedTooltipColumns.size()];
            for (int i = 0; i < this.cachedTooltipColumns.size(); ++i) {
                String string2 = this.cachedTooltipColumns.get(i);
                Object object = this.getRow(l).get(string2, Comparable.class).get();
                objectArray[i] = object != null && object instanceof String && this.translateTextValues ? this.translateTextValue(this.getRow(l), object.toString()) : object;
            }
            string = Formatter.format(this.cachedTooltipFormat, objectArray);
        }
        return string;
    }

    @Override
    protected void onInit(Context context) {
        this.context = context;
        this.tableView = context.getContainer(Control.class);
        this.monitor = context.getFacet(AbstractTableMonitor.class, (Map<Object, Object>)this.tableView.getProperties());
        this.featureSetHelper = new TableFeatureSetHelper(new List[]{this.featureSetSelectors, this.monitor.getFeatureSetSelectors()});
        this.translateTextValues = this.featureSetHelper.containsCandidateFeatureSets(abstractTableFeatureSet -> abstractTableFeatureSet.getLabel() != null);
    }

    protected abstract L createCell();

    protected abstract boolean useValueColumnAsDefaultTextColumn();

    protected List<String> getSecondaryChangeColumns() {
        return Collections.EMPTY_LIST;
    }

    protected void updateCellText(L l, boolean bl) {
        if (bl) {
            l.setText(null);
        } else {
            String string = this.getColumnText(l);
            if (string == null && this.useValueColumnAsDefaultTextColumn()) {
                string = this.getValueAsText(l);
            }
            l.setText(string != null ? string.replace('\n', ' ') : null);
        }
    }

    protected void updateCellTooltip(L l, boolean bl) {
        this.ensureTooltipsInitialized(l);
        Tooltip tooltip = l.getTooltip();
        if (tooltip != null) {
            if (bl) {
                l.setTooltip(null);
            } else {
                tooltip.setText(this.getTooltipText(l));
            }
        }
    }

    protected abstract DXRow getRow(L var1);

    private String translateTextValue(DXRow dXRow, String string) {
        AbstractTableFeatureSet abstractTableFeatureSet2 = this.featureSetHelper.find(dXRow, this.getValueColumn(), abstractTableFeatureSet -> abstractTableFeatureSet.getSelectorValue() != null);
        return abstractTableFeatureSet2 != null ? abstractTableFeatureSet2.getLabel() : string;
    }

    private void showContextMenu(L l, double d, double d2) {
        ContextMenu contextMenu;
        AbstractTableFeatureSet abstractTableFeatureSet2 = this.featureSetHelper.find(this.getRow(l), this.getValueColumn(), abstractTableFeatureSet -> abstractTableFeatureSet.getContextMenu() != null);
        if (abstractTableFeatureSet2 != null) {
            contextMenu = abstractTableFeatureSet2.getContextMenu();
        } else {
            contextMenu = this.getContextMenu();
            if (contextMenu == null) {
                contextMenu = this.monitor.getContextMenu();
            }
        }
        if (contextMenu != null) {
            contextMenu.setUserData(l);
            contextMenu.show(l, d, d2);
        }
    }

    private void ensureCacheInitialized() {
        if (!this.cacheInitialized) {
            String string = this.getTextColumn();
            if (string != null) {
                this.cachedTextColumns = Arrays.asList(string.trim().split("\\s*,\\s*"));
            }
            this.cachedTooltipFormat = this.getTooltipFormat();
            if (this.cachedTooltipFormat != null) {
                String string2 = this.getTooltipColumn();
                this.cachedTooltipColumns = string2 != null ? Arrays.asList(string2.trim().split("\\s*,\\s*")) : (this.cachedTextColumns != null ? this.cachedTextColumns : Collections.singletonList(this.getValueColumn()));
            }
            this.cacheInitialized = true;
        }
    }

    private void ensureMonitorDependenciesInitialized(L l) {
        if (!this.monitorDependenciesInitialized) {
            AbstractTableMonitor abstractTableMonitor = null;
            for (Parent parent = l.getParent(); parent != null && abstractTableMonitor == null; parent = parent.getParent()) {
                abstractTableMonitor = this.context.getFacet(AbstractTableMonitor.class, (Map<Object, Object>)parent.getProperties());
            }
            this.monitorDependenciesInitialized = true;
        }
    }

    private void ensureTooltipsInitialized(L l) {
        if (this.cachedTooltipFormat != null && l.getTooltip() == null) {
            Tooltip tooltip = new Tooltip();
            tooltip.setWrapText(true);
            tooltip.setMaxWidth(500.0);
            l.setTooltip(tooltip);
        }
    }
}

