/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.effect.ColorAdjust;
import oracle.dbtools.raptor.metrics.panel.AbstractAugmentorObject;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.ChangeIndicator;
import oracle.dbtools.raptor.metrics.panel.Context;

public class ConnectionIndicator
extends AbstractAugmentorObject {
    private ObservableBooleanValue connectedValue;
    private ChangeListener<Boolean> connectedListener;

    @Override
    protected Class<? extends AbstractContextObject> getBindAsClass() {
        return ConnectionIndicator.class;
    }

    @Override
    protected void onInit(Context context) {
        Node node = context.getContainer(Node.class);
        for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (context.getFacet(ConnectionIndicator.class, (Map<Object, Object>)parent.getProperties()) == null) continue;
            Logger.getLogger(ConnectionIndicator.class.getName()).log(Level.WARNING, "nested connection indicator found");
        }
        Platform.runLater(() -> {
            this.traverseTree(context, node);
            if (this.connectedValue != null) {
                this.onConnected(context);
                this.connectedListener = (observableValue, bl, bl2) -> this.onConnected(context);
                this.connectedValue.addListener(this.connectedListener);
            }
        });
    }

    @Override
    protected void onClose(Context context) {
        if (this.connectedValue != null && this.connectedListener != null) {
            this.connectedValue.removeListener(this.connectedListener);
        }
        this.connectedValue = null;
        this.connectedListener = null;
    }

    private void traverseTree(Context context, Node node) {
        ObservableBooleanValue observableBooleanValue;
        ChangeIndicator changeIndicator = context.getFacet(ChangeIndicator.class, (Map<Object, Object>)node.getProperties());
        if (changeIndicator != null) {
            if (this.connectedValue == null) {
                this.connectedValue = changeIndicator.getConnectedValue();
            } else {
                observableBooleanValue = changeIndicator.getConnectedValue();
                if (observableBooleanValue != null) {
                    this.connectedValue = Bindings.and((ObservableBooleanValue)this.connectedValue, (ObservableBooleanValue)changeIndicator.getConnectedValue());
                }
            }
        }
        if (node instanceof Parent) {
            observableBooleanValue = (Parent)node;
            for (Node node2 : observableBooleanValue.getChildrenUnmodifiable()) {
                this.traverseTree(context, node2);
            }
        }
    }

    private void onConnected(Context context) {
        ColorAdjust colorAdjust = null;
        if (!this.connectedValue.get()) {
            colorAdjust = new ColorAdjust(0.0, 0.0, 0.4, 0.0);
        }
        context.getContainer(Node.class).setEffect(colorAdjust);
    }
}

