/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableMapValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import oracle.dbtools.raptor.metrics.dataobject.DataObject;
import oracle.dbtools.raptor.metrics.dataobject.MapDataObject;
import oracle.dbtools.raptor.metrics.observable.DXKey;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.ChartMonitor;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.NumberAxisProperties;
import oracle.dbtools.raptor.metrics.panel.PointAxisProperties;

@DefaultProperty(value="item")
public class PointChartMonitor
extends ChartMonitor {
    private final ObjectProperty<MapDataObject> itemProperty = new SimpleObjectProperty((Object)this, "item");
    private final StringProperty xColumnProperty = new SimpleStringProperty();
    private final StringProperty yColumnProperty = new SimpleStringProperty();
    private PointAxisProperties xAxisProperties;
    private PointAxisProperties yAxisProperties;
    private final ObjectProperty<ObservableList<XYChart.Series<Number, Number>>> dataProperty = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
    private final Map<Double, XListener> listenerMap = new HashMap<Double, XListener>();
    private ObservableList<XYChart.Data<Number, Number>> dataPoints;

    public MapDataObject getItem() {
        return (MapDataObject)this.itemProperty.get();
    }

    public void setItem(MapDataObject mapDataObject) {
        this.itemProperty.set((Object)mapDataObject);
    }

    public ObjectProperty<MapDataObject> itemProperty() {
        return this.itemProperty;
    }

    public String getXColumn() {
        return (String)this.xColumnProperty.get();
    }

    public void setXColumn(String string) {
        this.xColumnProperty.set((Object)string);
    }

    public StringProperty xColumnProperty() {
        return this.xColumnProperty;
    }

    public String getYColumn() {
        return (String)this.yColumnProperty.get();
    }

    public void setYColumn(String string) {
        this.yColumnProperty.set((Object)string);
    }

    public StringProperty yColumnProperty() {
        return this.yColumnProperty;
    }

    @Override
    protected List<DataObject> getDataObjects(Context context) {
        return Collections.singletonList(this.getItem());
    }

    @Override
    protected void onInit(Context context) {
        XYChart xYChart = context.getContainer(XYChart.class);
        if (xYChart != null) {
            XYChart.Series series = new XYChart.Series();
            this.xAxisProperties = this.findAndInitializeAxisProperties(PointAxisProperties.class, context, (NumberAxis)xYChart.getXAxis(), () -> new NumberAxisProperties());
            this.yAxisProperties = this.findAndInitializeAxisProperties(PointAxisProperties.class, context, (NumberAxis)xYChart.getYAxis(), () -> new NumberAxisProperties());
            ((ObservableList)this.dataProperty.get()).setAll((Object[])new XYChart.Series[]{series});
            this.dataPoints = series.getData();
            String string = this.getXColumn();
            String string2 = this.getYColumn();
            ObservableMapValue<DXKey, DXRow> observableMapValue = this.getItem().getObservable();
            ((ObservableMap)observableMapValue.get()).addListener(change -> {
                if (change.wasAdded()) {
                    DXRow dXRow = (DXRow)change.getValueAdded();
                    this.onPointAdded(this.xAxisProperties.convertValueToDouble(dXRow.get(string, Comparable.class).get()), (ObservableValue<?>)dXRow.get(string2, Comparable.class));
                } else if (change.wasRemoved()) {
                    DXRow dXRow = (DXRow)change.getValueRemoved();
                    this.onPointRemoved(this.xAxisProperties.convertValueToDouble(dXRow.get(string, Comparable.class).get()));
                }
            });
            this.getItem().getUpdating().addListener((observableValue, bl, bl2) -> {
                if (!bl2.booleanValue()) {
                    this.updateBounds();
                }
            });
            xYChart.dataProperty().bind(this.dataProperty);
        }
    }

    @Override
    protected void onClose(Context context) {
        XYChart xYChart = context.getContainer(XYChart.class);
        if (xYChart != null) {
            xYChart.dataProperty().unbind();
        }
    }

    private void onPointAdded(double d, ObservableValue<?> observableValue) {
        double d2 = this.yAxisProperties.convertValueToDouble(observableValue.getValue());
        XYChart.Data data = new XYChart.Data((Object)d, (Object)d2);
        this.listenForSequence(d, observableValue);
        int n = this.findInsertionIndex(d);
        if (n < this.dataPoints.size() && (double)((Number)((XYChart.Data)this.dataPoints.get(n)).getXValue()).longValue() == d) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "duplicate map entry detected for {0}", d);
        } else {
            this.dataPoints.add(n, (Object)data);
        }
    }

    private void onPointRemoved(double d) {
        int n = this.findIndex(d);
        if (n >= 0) {
            this.unlistenForSequence(d);
            this.dataPoints.remove(n);
        }
    }

    private void onValueChanged(double d, ObservableValue<?> observableValue) {
        int n = this.findIndex(d);
        boolean bl = false;
        if (n > 0) {
            XYChart.Data data = (XYChart.Data)this.dataPoints.get(n);
            double d2 = this.yAxisProperties.convertValueToDouble(observableValue.getValue());
            data.setYValue((Object)d2);
            bl = true;
        }
        if (!bl) {
            this.onPointRemoved(d);
            this.onPointAdded(d, observableValue);
        }
    }

    private int findInsertionIndex(double d) {
        XYChart.Data data;
        int n = 0;
        Iterator iterator = this.dataPoints.iterator();
        while (iterator.hasNext() && !(((Number)(data = (XYChart.Data)iterator.next()).getXValue()).doubleValue() >= d)) {
            ++n;
        }
        return n;
    }

    private int findIndex(double d) {
        int n = -1;
        int n2 = 0;
        for (XYChart.Data data : this.dataPoints) {
            if (((Number)data.getXValue()).doubleValue() == d) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    private void listenForSequence(double d, ObservableValue<?> observableValue) {
        XListener xListener = new XListener(d, observableValue);
        this.listenerMap.put(d, xListener);
        xListener.listen();
    }

    private void unlistenForSequence(double d) {
        XListener xListener = this.listenerMap.remove(d);
        if (xListener != null) {
            xListener.unlisten();
        }
    }

    private void updateBounds() {
        int n = this.dataPoints.size();
        if (n > 0) {
            double d = ((Number)((XYChart.Data)this.dataPoints.get(0)).getXValue()).doubleValue();
            double d2 = ((Number)((XYChart.Data)this.dataPoints.get(n - 1)).getXValue()).doubleValue();
            double d3 = Double.MAX_VALUE;
            double d4 = Double.MIN_VALUE;
            for (int i = 0; i < n; ++i) {
                double d5 = ((Number)((XYChart.Data)this.dataPoints.get(i)).getYValue()).doubleValue();
                if (d5 > d4) {
                    d4 = d5;
                }
                if (!(d5 < d3)) continue;
                d3 = d5;
            }
            this.xAxisProperties.update(d, d2);
            this.yAxisProperties.update(d3, d4);
        }
    }

    private class XListener
    implements ChangeListener<Object> {
        private final double x;
        private final ObservableValue<?> yValue;

        XListener(double d, ObservableValue<?> observableValue) {
            this.x = d;
            this.yValue = observableValue;
        }

        void listen() {
            this.yValue.addListener((ChangeListener)this);
        }

        void unlisten() {
            this.yValue.removeListener((ChangeListener)this);
        }

        public void changed(ObservableValue<?> observableValue, Object object, Object object2) {
            PointChartMonitor.this.onValueChanged(this.x, this.yValue);
        }
    }
}

