/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.stage.Screen;
import oracle.dbtools.raptor.metrics.panel.AbstractMonitorObject;
import oracle.dbtools.raptor.metrics.panel.Context;

public class ZoomPanMonitor
extends AbstractMonitorObject {
    private final DoubleProperty defaultScaleProperty = new SimpleDoubleProperty((Object)this, "defaultScale", 1.0);
    private ScrollPane scrollPane;
    private Node managedPanel;
    private double resetScale;
    private Node scrollPaneViewport;
    private boolean panZoomMode;
    private boolean zooming;
    private double currentZoom;
    private double dragZoomInitial;
    private int dragInitial;
    private int deltaDrag;
    private int deltaDragThreshold;
    private double scale;
    private EventHandler<MouseEvent> dragDetectedHandler;
    private EventHandler<MouseEvent> mouseDraggedHandler;
    private EventHandler<MouseEvent> mouseReleasedHandler;

    public double getDefaultScale() {
        return this.defaultScaleProperty.get();
    }

    public void setDefaultScale(double d) {
        this.defaultScaleProperty.set(d);
    }

    public DoubleProperty defaultScaleProperty() {
        return this.defaultScaleProperty;
    }

    public ScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void panLeft() {
        double d = this.scrollPane.getHvalue();
        d = d < 0.9 ? (d += 0.1) : 1.0;
        this.scrollPane.setHvalue(d);
    }

    public void panRight() {
        double d = this.scrollPane.getHvalue();
        d = d > 0.1 ? (d -= 0.1) : 0.0;
        this.scrollPane.setHvalue(d);
    }

    public void panUp() {
        double d = this.scrollPane.getVvalue();
        d = d < 0.9 ? (d += 0.1) : 1.0;
        this.scrollPane.setVvalue(d);
    }

    public void panDown() {
        double d = this.scrollPane.getVvalue();
        d = d > 0.1 ? (d -= 0.1) : 0.0;
        this.scrollPane.setVvalue(d);
    }

    public void zoomIn() {
        this.currentZoom += this.getZoomIncrement();
        this.scale = Math.pow(10.0, this.currentZoom);
        this.applyTransforms();
    }

    public void zoomOut() {
        this.currentZoom -= this.getZoomIncrement();
        this.scale = Math.pow(10.0, this.currentZoom);
        this.applyTransforms();
    }

    public void zoomActual() {
        this.currentZoom = Math.log10(this.resetScale);
        this.scale = this.resetScale;
        this.applyTransforms();
    }

    public void zoomToSize(double d, double d2) {
        this.currentZoom = this.getZoomToSize(this.scrollPane.getWidth(), this.scrollPane.getHeight());
        this.scale = Math.pow(10.0, this.currentZoom);
        this.applyTransforms();
    }

    public void toggleMousePanZoom() {
        this.panZoomMode = !this.panZoomMode;
        this.scrollPane.setPannable(this.panZoomMode);
        this.scrollPane.getContent().setMouseTransparent(this.panZoomMode);
        if (this.scrollPaneViewport == null) {
            this.scrollPaneViewport = this.scrollPane.lookup(".viewport");
        }
        if (this.panZoomMode) {
            this.scrollPaneViewport.setCursor(Cursor.MOVE);
        } else {
            this.scrollPaneViewport.setCursor(Cursor.DEFAULT);
        }
    }

    public void open(ScrollPane scrollPane) {
        if (this.scrollPane == null) {
            this.scrollPane = scrollPane;
            this.managedPanel = scrollPane.getContent();
            scrollPane.setContent((Node)new ManagerGroup(this.managedPanel));
            this.scale = this.getDefaultScale();
            this.currentZoom = Math.log10(this.scale);
            this.resetScale = this.scale;
            this.applyTransforms();
            this.addZoomHandlers();
            Parent parent = scrollPane.getScene().getRoot();
            ObservableMap observableMap = parent.getProperties();
            if (observableMap.get(ZoomPanMonitor.class) != null) {
                Logger.getLogger(ZoomPanMonitor.class.getName()).log(Level.WARNING, "scene may only contain a single ZoomPanMonitor");
            } else {
                observableMap.put(ZoomPanMonitor.class, this);
            }
        }
    }

    public void close() {
        if (this.scrollPane != null) {
            this.removeZoomHandlers();
            Parent parent = this.scrollPane.getScene().getRoot();
            ObservableMap observableMap = parent.getProperties();
            if (observableMap.get(ZoomPanMonitor.class) == this) {
                observableMap.remove(ZoomPanMonitor.class);
            }
        }
    }

    @Override
    protected Class<? extends Node> getBindToClass() {
        return ScrollPane.class;
    }

    @Override
    protected void onInit(Context context) {
        this.open(context.getContainer(ScrollPane.class));
    }

    @Override
    protected void onClose(Context context) {
        this.close();
    }

    private void addZoomHandlers() {
        this.dragDetectedHandler = mouseEvent -> {
            if (this.panZoomMode && mouseEvent.isControlDown()) {
                this.zooming = true;
                this.beginZoom((int)mouseEvent.getScreenX());
                mouseEvent.consume();
            }
        };
        this.mouseDraggedHandler = mouseEvent -> {
            if (this.panZoomMode && this.zooming) {
                this.zoom((int)mouseEvent.getScreenX());
                mouseEvent.consume();
            }
        };
        this.mouseReleasedHandler = mouseEvent -> {
            if (this.panZoomMode && this.zooming) {
                this.zooming = false;
                mouseEvent.consume();
            }
        };
        this.scrollPane.addEventFilter(MouseEvent.DRAG_DETECTED, this.dragDetectedHandler);
        this.scrollPane.addEventFilter(MouseEvent.MOUSE_DRAGGED, this.mouseDraggedHandler);
        this.scrollPane.addEventFilter(MouseEvent.MOUSE_RELEASED, this.mouseReleasedHandler);
    }

    private void removeZoomHandlers() {
        this.scrollPane.removeEventFilter(MouseEvent.DRAG_DETECTED, this.dragDetectedHandler);
        this.scrollPane.removeEventFilter(MouseEvent.MOUSE_DRAGGED, this.mouseDraggedHandler);
        this.scrollPane.removeEventFilter(MouseEvent.MOUSE_RELEASED, this.mouseReleasedHandler);
        this.dragDetectedHandler = null;
        this.mouseDraggedHandler = null;
        this.mouseReleasedHandler = null;
    }

    private void applyTransforms() {
        Scale scale = Transform.scale((double)this.scale, (double)this.scale, (double)0.0, (double)0.0);
        this.managedPanel.getTransforms().setAll((Object[])new Transform[]{scale});
    }

    private void beginZoom(int n) {
        if (this.deltaDragThreshold == 0) {
            this.deltaDragThreshold = (int)Screen.getPrimary().getVisualBounds().getWidth() / 2;
        }
        this.dragInitial = n;
        this.dragZoomInitial = this.currentZoom;
    }

    private void zoom(int n) {
        int n2 = n - this.dragInitial;
        if (n2 != this.deltaDrag) {
            this.deltaDrag = n2;
            this.currentZoom = this.dragZoomInitial + (double)this.deltaDrag / (double)this.deltaDragThreshold;
            this.scale = Math.pow(10.0, this.currentZoom);
            this.applyTransforms();
        }
    }

    private double getZoomToSize(double d, double d2) {
        double d3 = this.managedPanel.prefWidth(-1.0) + 4.0;
        double d4 = d2 / d;
        double d5 = this.managedPanel.prefHeight(-1.0) + 4.0;
        double d6 = d5 / d3;
        return Math.log10(d4 > d6 ? d / d3 : d2 / d5);
    }

    private double getZoomIncrement() {
        return 0.05;
    }

    private static class ManagerGroup
    extends Parent {
        ManagerGroup(Node ... nodeArray) {
            this.getChildren().addAll((Object[])nodeArray);
        }
    }
}

