/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.sqlsource;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.metrics.engine.AbstractOperation;
import oracle.dbtools.raptor.metrics.sqlsource.Query;
import oracle.dbtools.raptor.metrics.sqlsource.SQLJobType;
import oracle.dbtools.raptor.metrics.sqlsource.SQLOperationType;
import oracle.dbtools.raptor.metrics.sqlsource.SQLSourceType;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SQLOperation
extends AbstractOperation<SQLOperationType, SQLSourceType, SQLJobType> {
    private final ObservableList<Query> queries = FXCollections.observableArrayList();

    public ObservableList<Query> getQueries() {
        return this.queries;
    }

    @Override
    public SQLOperationType createTypeObject(ClassLoader classLoader, SQLSourceType sQLSourceType) {
        SQLOperationType sQLOperationType = new SQLOperationType(sQLSourceType);
        this.initializeTypeObject(classLoader, sQLOperationType);
        return sQLOperationType;
    }

    @Override
    protected void initializeTypeObject(ClassLoader classLoader, SQLOperationType sQLOperationType) {
        super.initializeTypeObject(classLoader, sQLOperationType);
        sQLOperationType.setObjectQueries(this.createObjectQueries());
    }

    private ObjectQueries createObjectQueries() {
        XMLDocument xMLDocument = new XMLDocument();
        Element element = xMLDocument.createElement("queries");
        xMLDocument.appendChild((Node)element);
        for (Query query : this.queries) {
            Element element2 = xMLDocument.createElement("query");
            element2.setAttribute("minversion", query.getMinVersion());
            element2.setAttribute("maxversion", query.getMaxVersion());
            Element element3 = xMLDocument.createElement("sql");
            element3.setTextContent(this.resolveLibraryRefs(query.getSql()));
            element2.appendChild(element3);
            element.appendChild(element2);
        }
        return new ObjectQueries((XMLNode)element);
    }
}

