/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.viewer;

import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.metrics.viewer.MetricsDisplay;
import oracle.dbtools.raptor.oviewer.xmleditor.XMLBasedEditor;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;

public abstract class AbstractMetricsPanelController
implements Controller {
    private boolean acceleratorsSetup;

    public boolean handleEvent(IdeAction ideAction, Context context) {
        String string;
        MetricsDisplay metricsDisplay = this.findDisplay();
        if (metricsDisplay != null && (string = Ide.findCmdName((int)ideAction.getCommandId())) != null) {
            DisplayModel displayModel;
            boolean bl = this.handleEvent(metricsDisplay, string);
            if (bl && (displayModel = metricsDisplay.getDisplayModel()) != null) {
                Logger.fine(this.getClass(), (String)(this.getClass().getSimpleName() + " handled toolbar action for " + displayModel.getObjectType()));
            }
            return bl;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        MetricsDisplay metricsDisplay = this.findDisplay();
        if (metricsDisplay != null) {
            this.setupAccelerators(metricsDisplay);
            String string = Ide.findCmdName((int)ideAction.getCommandId());
            if (string != null) {
                return this.update(string);
            }
        }
        return false;
    }

    protected abstract boolean handleEvent(MetricsDisplay var1, String var2);

    protected abstract boolean update(String var1);

    protected abstract String getLocalAcceleratorsFile();

    private MetricsDisplay findDisplay() {
        IDisplay iDisplay;
        MetricsDisplay metricsDisplay = null;
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor instanceof XMLBasedEditor && (iDisplay = ((XMLBasedEditor)editor).getMainUI()) instanceof MetricsDisplay) {
            metricsDisplay = (MetricsDisplay)iDisplay;
        }
        return metricsDisplay;
    }

    private void setupAccelerators(MetricsDisplay metricsDisplay) {
        if (!this.acceleratorsSetup) {
            try {
                JComponent jComponent = metricsDisplay.getUI();
                Toolbar toolbar = metricsDisplay.getToolbar();
                String string = this.getLocalAcceleratorsFile();
                InputMap inputMap = jComponent.getInputMap(1);
                KeyStroke keyStroke = KeyStroke.getKeyStroke(80, 192, false);
                Object object = inputMap.get(keyStroke);
                InputMap inputMap2 = new InputMap();
                inputMap2.put(keyStroke, object);
                UIUtils.addIdeKeyBindings((JComponent)jComponent, (int)1, (String)string, (InputMap)inputMap2);
                UIUtils.setupAccelerators((Toolbar)toolbar, (String)string);
                this.acceleratorsSetup = true;
            }
            catch (Exception exception) {
                Logger.warn(this.getClass(), (Throwable)exception);
            }
        }
    }
}

