/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.viewer;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.BoxLayout;
import oracle.dbtools.raptor.metrics.console.ConsoleModel;
import oracle.dbtools.raptor.metrics.console.ConsolePane;
import oracle.dbtools.raptor.metrics.engine.DXListenerList;
import oracle.dbtools.raptor.metrics.engine.DXService;
import oracle.dbtools.raptor.metrics.viewer.AbstractPanelAdapter;
import oracle.dbtools.raptor.metrics.viewer.MetricsPanelAdapter;

public class MetricsConsoleViewer
extends AbstractPanelAdapter {
    private static MetricsConsoleViewer viewer = null;
    private volatile JFXPanel fxPanel;
    private ConsolePane consolePane;
    private ConsoleModel consoleModel;
    private Scene scene;
    private DXListenerList listeners;
    private boolean uiInitialized;

    public static synchronized MetricsConsoleViewer getInstance() {
        if (viewer == null) {
            viewer = new MetricsConsoleViewer();
        }
        return viewer;
    }

    private MetricsConsoleViewer() {
        this.setLayout(new BoxLayout(this, 1));
        this.fxPanel = new JFXPanel();
        this.add((Component)this.fxPanel);
    }

    public void start() {
        Platform.runLater(() -> {
            try {
                this.initUI();
                DXService.registerListeners(this.listeners);
            }
            catch (RuntimeException runtimeException) {
                Logger.getLogger(MetricsPanelAdapter.class.getName()).log(Level.SEVERE, "error creating FX viewer UI", runtimeException);
            }
        });
    }

    public void stop() {
        Platform.runLater(() -> {
            try {
                DXService.unregisterListeners(this.listeners);
            }
            catch (RuntimeException runtimeException) {
                Logger.getLogger(MetricsPanelAdapter.class.getName()).log(Level.SEVERE, "error creating FX viewer UI", runtimeException);
            }
        });
    }

    private void initUI() {
        if (!this.uiInitialized) {
            this.consoleModel = new ConsoleModel();
            this.consolePane = new ConsolePane(this.consoleModel);
            this.listeners = new DXListenerList();
            this.consoleModel.addActivityListener(this.listeners);
            this.scene = new Scene((Parent)this.consolePane);
            this.fxPanel.setScene(this.scene);
            this.uiInitialized = true;
        }
    }
}

