/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.viewer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.metrics.panel.MetricsPanel;
import oracle.dbtools.raptor.metrics.viewer.MetricsPanelAdapter;
import oracle.dbtools.raptor.metrics.viewer.MetricsToolbar;
import oracle.dbtools.raptor.metrics.viewer.MetricsToolbarAdapter;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.ide.model.Node;
import oracle.ide.view.View;

public class MetricsDisplay
extends DisplayAdapter
implements IDisplay {
    private volatile MetricsPanelAdapter metricsPanel;
    private volatile MetricsToolbarAdapter toolbarAdapter;

    @Override
    public JComponent getUI() {
        if (this.metricsPanel == null) {
            String string;
            Map<String, String> map = this.getExtValues();
            String string2 = map.get("FXML");
            String string3 = map.get("BUNDLE");
            if (string3 == null || string3.isEmpty()) {
                string3 = this.getRoot(string2);
            }
            if ((string = map.get("CSS")) == null || string.isEmpty()) {
                string = this.getRoot(string2) + ".css";
            }
            String string4 = map.get("PROPERTY_VISITOR");
            this.metricsPanel = new MetricsPanelAdapter(this.getDisplayModel().getCl(), string2, string3, string, string4, this.getConnName());
            if (map.containsKey("TOOLBAR")) {
                map.put("ToolbarExtra", MetricsToolbar.class.getName());
                String string5 = map.get("TOOLBAR");
                this.toolbarAdapter = new MetricsToolbarAdapter(this.getDisplayModel().getCl(), string2, string5, string3, string, this.getConnName());
                MetricsToolbar.setAdapter(this.toolbarAdapter);
            }
        }
        return this.metricsPanel;
    }

    @Override
    public void close() {
        this.metricsPanel.close();
        if (this.toolbarAdapter != null) {
            this.toolbarAdapter.closeToolbarUI();
        }
        super.close();
    }

    @Override
    public void refresh(boolean bl) {
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : this.getExtValues().keySet()) {
            object = this.getExtValues().get(string);
            if (object == null) continue;
            hashMap.put(string, object);
        }
        for (String string : this.getBindMap().keySet()) {
            object = this.getBindMap().get(string);
            if (object == null) continue;
            hashMap.put(string, object);
        }
        this.metricsPanel.open(hashMap);
    }

    @Override
    public void setView(View view) {
        Node node;
        super.setView(view);
        if (view != null && (node = view.getContext().getNode()) instanceof ViewerNode) {
            ViewerNode viewerNode = (ViewerNode)node;
            viewerNode.setPinned(true);
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public void addActions(List<ObjectAction> list) {
    }

    @Override
    public boolean isUseEditorScrollPane() {
        return false;
    }

    @Override
    public boolean isUseScrollableUI() {
        return false;
    }

    public MetricsPanel getPanel() {
        return this.metricsPanel.getPanel();
    }

    public double getDisplayWidth() {
        return this.metricsPanel.getWidth();
    }

    public double getDisplayHeight() {
        return this.metricsPanel.getWidth();
    }

    public void saveSnapshot() {
        if (this.metricsPanel != null) {
            this.metricsPanel.saveSnapshot();
        }
    }

    private String getRoot(String string) {
        int n = string.lastIndexOf(46);
        return n < 0 ? string : string.substring(0, n);
    }
}

