/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.viewer;

import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.ObservableMap;
import oracle.dbtools.raptor.metrics.panel.MetricsPanel;
import oracle.dbtools.raptor.metrics.panel.ZoomPanMonitor;
import oracle.dbtools.raptor.metrics.viewer.AbstractMetricsPanelController;
import oracle.dbtools.raptor.metrics.viewer.MetricsDisplay;

public class MetricsPanelController
extends AbstractMetricsPanelController {
    @Override
    protected boolean handleEvent(MetricsDisplay metricsDisplay, String string) {
        switch (string) {
            case "Metrics.MOUSE_PAN_ZOOM": {
                this.toggleMousePanZoom(metricsDisplay);
                return true;
            }
            case "Metrics.ZOOM_IN": {
                this.zoomIn(metricsDisplay);
                return true;
            }
            case "Metrics.ZOOM_OUT": {
                this.zoomOut(metricsDisplay);
                return true;
            }
            case "Metrics.ZOOM_TO_FIT": {
                this.zoomToFit(metricsDisplay);
                return true;
            }
            case "Metrics.ZOOM_ACTUAL": {
                this.zoomActual(metricsDisplay);
                return true;
            }
            case "Metrics.PAN_LEFT": {
                this.panLeft(metricsDisplay);
                return true;
            }
            case "Metrics.PAN_RIGHT": {
                this.panRight(metricsDisplay);
                return true;
            }
            case "Metrics.PAN_UP": {
                this.panUp(metricsDisplay);
                return true;
            }
            case "Metrics.PAN_DOWN": {
                this.panDown(metricsDisplay);
                return true;
            }
            case "Metrics.SAVE_SNAPSHOT": {
                this.saveSnapshot(metricsDisplay);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean update(String string) {
        switch (string) {
            case "Metrics.MOUSE_PAN_ZOOM": 
            case "Metrics.ZOOM_IN": 
            case "Metrics.ZOOM_OUT": 
            case "Metrics.ZOOM_TO_FIT": 
            case "Metrics.ZOOM_ACTUAL": 
            case "Metrics.PAN_LEFT": 
            case "Metrics.PAN_RIGHT": 
            case "Metrics.PAN_UP": 
            case "Metrics.PAN_DOWN": 
            case "Metrics.SAVE_SNAPSHOT": {
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getLocalAcceleratorsFile() {
        return "oracle/dbtools/raptor/metrics/viewer/accelerators.xml";
    }

    private void panUp(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> {
            ZoomPanMonitor zoomPanMonitor = this.getZoomPanMonitor(metricsDisplay);
            if (zoomPanMonitor != null) {
                zoomPanMonitor.panUp();
            }
        });
    }

    private void panDown(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> {
            ZoomPanMonitor zoomPanMonitor = this.getZoomPanMonitor(metricsDisplay);
            if (zoomPanMonitor != null) {
                zoomPanMonitor.panDown();
            }
        });
    }

    private void panLeft(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> {
            ZoomPanMonitor zoomPanMonitor = this.getZoomPanMonitor(metricsDisplay);
            if (zoomPanMonitor != null) {
                zoomPanMonitor.panLeft();
            }
        });
    }

    private void panRight(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> {
            ZoomPanMonitor zoomPanMonitor = this.getZoomPanMonitor(metricsDisplay);
            if (zoomPanMonitor != null) {
                zoomPanMonitor.panRight();
            }
        });
    }

    private void toggleMousePanZoom(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> {
            ZoomPanMonitor zoomPanMonitor = this.getZoomPanMonitor(metricsDisplay);
            if (zoomPanMonitor != null) {
                zoomPanMonitor.toggleMousePanZoom();
            }
        });
    }

    private void zoomIn(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> {
            ZoomPanMonitor zoomPanMonitor = this.getZoomPanMonitor(metricsDisplay);
            if (zoomPanMonitor != null) {
                zoomPanMonitor.zoomIn();
            }
        });
    }

    private void zoomOut(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> {
            ZoomPanMonitor zoomPanMonitor = this.getZoomPanMonitor(metricsDisplay);
            if (zoomPanMonitor != null) {
                zoomPanMonitor.zoomOut();
            }
        });
    }

    private void zoomToFit(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> {
            ZoomPanMonitor zoomPanMonitor = this.getZoomPanMonitor(metricsDisplay);
            if (zoomPanMonitor != null) {
                zoomPanMonitor.zoomToSize(metricsDisplay.getDisplayWidth(), metricsDisplay.getDisplayHeight());
            }
        });
    }

    private void zoomActual(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> {
            ZoomPanMonitor zoomPanMonitor = this.getZoomPanMonitor(metricsDisplay);
            if (zoomPanMonitor != null) {
                zoomPanMonitor.zoomActual();
            }
        });
    }

    private void saveSnapshot(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> metricsDisplay.saveSnapshot());
    }

    private ZoomPanMonitor getZoomPanMonitor(MetricsDisplay metricsDisplay) {
        MetricsPanel metricsPanel = metricsDisplay.getPanel();
        ObservableMap observableMap = metricsPanel.getScene().getRoot().getProperties();
        ZoomPanMonitor zoomPanMonitor = (ZoomPanMonitor)observableMap.get(ZoomPanMonitor.class);
        if (zoomPanMonitor == null) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "no ZoomPanMonitor has been specified");
        }
        return zoomPanMonitor;
    }
}

