/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.mimeeditor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.mimeeditor.MimeEditorArb;
import oracle.dbtools.raptor.mimeeditor.WinRegistry;
import oracle.dbtools.raptor.utils.ExceptionHandler;

public class OSProperties {
    private static String nameOS = "os.name";
    private static String versionOS = "os.version";
    private static String architectureOS = "os.arch";
    public static String osWindows = "windows";
    public static String osMac = "mac";
    public static String osUnix = "unix";
    public static String osUnknown = "unknown";

    public void getOSProperties() {
    }

    public String getUnixCommandLine(String string) {
        String string2 = null;
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(string).getInputStream()));
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            ExceptionHandler.handleException((Throwable)iOException);
        }
        return string2;
    }

    public String getWindowsCommandLine(String string) {
        String string2 = null;
        if (string == null || string.equals("")) {
            return MimeEditorArb.getString("WINDOWS_EXEC_COMMAND");
        }
        try {
            string2 = WinRegistry.readString(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\" + string, "");
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, invocationTargetException.getStackTrace()[0].toString(), invocationTargetException);
            ExceptionHandler.handleException((Throwable)invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, illegalAccessException.getStackTrace()[0].toString(), illegalAccessException);
            ExceptionHandler.handleException((Throwable)illegalAccessException);
        }
        return string2;
    }

    public String getMacCommandLine(String string) {
        String string2 = null;
        if (string == null || string.equals("")) {
            return MimeEditorArb.getString("MAC_EXEC_COMMAND");
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(string).getInputStream()));
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            ExceptionHandler.handleException((Throwable)iOException);
        }
        return string2;
    }

    public String getOSVersion() {
        return System.getProperty(versionOS);
    }

    public String getOSArchitecture() {
        return System.getProperty(architectureOS);
    }

    public String getOSName() {
        if (OSProperties.isWindows()) {
            return osWindows;
        }
        if (OSProperties.isMac()) {
            return osMac;
        }
        if (OSProperties.isUnix()) {
            return osUnix;
        }
        return osUnknown;
    }

    public static boolean isWindows() {
        String string = System.getProperty(nameOS).toLowerCase();
        return string.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        String string = System.getProperty(nameOS).toLowerCase();
        return string.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        String string = System.getProperty(nameOS).toLowerCase();
        return string.indexOf("nix") >= 0 || string.indexOf("nux") >= 0 || string.indexOf("sun") >= 0 || string.indexOf("sol") >= 0;
    }
}

