/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.AccessCache;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.raptor.navigator.ConnectionInfo;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.model.BaseElement;
import oracle.dbtools.raptor.navigator.db.model.Catalogs;
import oracle.dbtools.raptor.navigator.db.model.CategoryInstance;
import oracle.dbtools.raptor.navigator.db.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.db.model.DBCatalogsInstance;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemas;
import oracle.dbtools.raptor.navigator.db.model.DBSchemasInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.db.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.db.model.ObjectCategory;
import oracle.dbtools.raptor.navigator.db.model.ObjectType;
import oracle.dbtools.raptor.navigator.db.xml.AbstractItemInstance;
import oracle.dbtools.raptor.navigator.db.xml.AbstractNodeInstance;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.db.xml.QueryFactory;
import oracle.dbtools.raptor.navigator.db.xml.XmlCatalogImpl;
import oracle.dbtools.raptor.navigator.db.xml.XmlCatalogInstance;
import oracle.dbtools.raptor.navigator.db.xml.XmlCatalogsImpl;
import oracle.dbtools.raptor.navigator.db.xml.XmlCatalogsInstance;
import oracle.dbtools.raptor.navigator.db.xml.XmlCategoryInstance;
import oracle.dbtools.raptor.navigator.db.xml.XmlCategoryType;
import oracle.dbtools.raptor.navigator.db.xml.XmlChildImpl;
import oracle.dbtools.raptor.navigator.db.xml.XmlChildInstance;
import oracle.dbtools.raptor.navigator.db.xml.XmlDBObject;
import oracle.dbtools.raptor.navigator.db.xml.XmlFolderImpl;
import oracle.dbtools.raptor.navigator.db.xml.XmlFolderInstance;
import oracle.dbtools.raptor.navigator.db.xml.XmlNodeImpl;
import oracle.dbtools.raptor.navigator.db.xml.XmlNodeInstance;
import oracle.dbtools.raptor.navigator.db.xml.XmlSchemaImpl;
import oracle.dbtools.raptor.navigator.db.xml.XmlSchemaInstance;
import oracle.dbtools.raptor.navigator.db.xml.XmlSchemasImpl;
import oracle.dbtools.raptor.navigator.db.xml.XmlSchemasInstance;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryProgressListener;
import oracle.dbtools.raptor.utils.DatabaseFeatureRegistry;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;

public class XmlObjectFactory
extends ObjectFactory {
    private QueryFactory m_queryFactory;

    public XmlObjectFactory(ConnectionInfo connectionInfo, ConnectionType connectionType) {
        super(connectionInfo, connectionType);
    }

    @Override
    public DBFolderInstance createFolderInstance(String string, DatabaseFolder databaseFolder) {
        AbstractItemInstance abstractItemInstance = null;
        if (databaseFolder instanceof XmlFolderImpl) {
            XmlFolderImpl xmlFolderImpl = (XmlFolderImpl)databaseFolder;
            Query query = xmlFolderImpl.getQueries().getQuery(this.getConnectionID(), true);
            if (query != null) {
                abstractItemInstance = new XmlFolderInstance(this, xmlFolderImpl, query);
            }
        } else {
            abstractItemInstance = new DummyFolderInstance(this, databaseFolder, string);
        }
        if (abstractItemInstance != null) {
            abstractItemInstance.setProperty("TYPE", string);
            abstractItemInstance.setProperty("ConnectionType", this.getConnectionType());
        }
        return abstractItemInstance;
    }

    @Override
    public DBObjectInstance createNodeInstance(String string) {
        ObjectType objectType = this.getObjectType(string);
        if (objectType == null) {
            return null;
        }
        DBItemInstance dBItemInstance = null;
        XmlDBObject xmlDBObject = (XmlDBObject)objectType.getNode();
        Class<? extends DBObjectInstance> clazz = xmlDBObject.getDBObjectInstanceClass();
        if (clazz != null) {
            assert (AbstractNodeInstance.class.isAssignableFrom(clazz));
            try {
                Constructor<? extends DBObjectInstance> constructor = clazz.getConstructor(ObjectFactory.class);
                AbstractNodeInstance abstractNodeInstance = (AbstractNodeInstance)constructor.newInstance(this);
                abstractNodeInstance.setDescriptor(xmlDBObject);
                abstractNodeInstance.setInstanceDelegate(new XmlNodeInstance(string, this, xmlDBObject));
                dBItemInstance = abstractNodeInstance;
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
        }
        if (dBItemInstance == null) {
            dBItemInstance = new XmlNodeInstance(string, this, xmlDBObject);
        }
        dBItemInstance.setProperty("ConnectionType", this.getConnectionType());
        return dBItemInstance;
    }

    private synchronized QueryFactory getQueryFactory() {
        if (this.m_queryFactory == null) {
            this.m_queryFactory = QueryFactory.getFactory(this.getNavigatorType(), this.getConnectionType());
        }
        return this.m_queryFactory;
    }

    @Override
    public ObjectType getObjectType(String string) {
        QueryFactory queryFactory = this.getQueryFactory();
        ObjectType objectType = queryFactory.getObjectType(string);
        return objectType;
    }

    @Override
    public DBChildInstance createChildInstance(String string, String string2) {
        DBChildInstance dBChildInstance = null;
        ObjectType objectType = this.getObjectType(string);
        XmlNodeImpl xmlNodeImpl = (XmlNodeImpl)objectType.getNode();
        XmlChildImpl xmlChildImpl = (XmlChildImpl)xmlNodeImpl.getChildType(string2);
        String string3 = xmlChildImpl.getNodeType();
        if (string3 != null) {
            dBChildInstance = this.createNodeInstance(string3);
        }
        if (dBChildInstance == null) {
            dBChildInstance = new XmlChildInstance(this, xmlChildImpl);
        }
        return dBChildInstance;
    }

    @Override
    public ObjectType[] listTypes() {
        QueryFactory queryFactory = this.getQueryFactory();
        return this.checkSupportedTypes(queryFactory.listTypes());
    }

    @Override
    protected ObjectType[] listTypesImpl(String string) {
        QueryFactory queryFactory = this.getQueryFactory();
        return this.checkSupportedTypes(queryFactory.listTypes(string));
    }

    private ObjectType[] checkSupportedTypes(ObjectType[] objectTypeArray) {
        String[] stringArray = this.getConnectionInfo().getSupportedTypesForConnection();
        if (stringArray != null) {
            HashSet hashSet = new HashSet();
            Collections.addAll(hashSet, stringArray);
            BaseElement[] baseElementArray = new BaseElement[objectTypeArray.length];
            int n = 0;
            for (ObjectType objectType : objectTypeArray) {
                if (!hashSet.contains(objectType.getType())) continue;
                baseElementArray[n++] = objectType;
            }
            if (n < baseElementArray.length) {
                objectTypeArray = new ObjectType[n];
                System.arraycopy(baseElementArray, 0, objectTypeArray, 0, n);
            }
        }
        return objectTypeArray;
    }

    @Override
    public ObjectCategory[] listCategories(String string) {
        QueryFactory queryFactory = this.getQueryFactory();
        ObjectCategory[] objectCategoryArray = queryFactory.listCategories(string);
        return objectCategoryArray;
    }

    @Override
    public CategoryInstance createCategoryInstance(ObjectCategory objectCategory) {
        XmlCategoryType xmlCategoryType = (XmlCategoryType)objectCategory;
        if (RaptorVersionTracker.checkVersion(this.getConnection(), xmlCategoryType.getMaximumVersion(), xmlCategoryType.getMinimumVersion()) && this.hasRequiredObjects(xmlCategoryType) && this.hasRequiredFeatures(xmlCategoryType)) {
            return new XmlCategoryInstance(this, (XmlCategoryType)objectCategory);
        }
        return null;
    }

    private boolean hasRequiredObjects(XmlCategoryType xmlCategoryType) {
        for (String string : xmlCategoryType.getRequiredObjects()) {
            if (AccessCache.hasAccess((ConnectionIdentifier)this.getConnectionID(), (String)string)) continue;
            return false;
        }
        return true;
    }

    private boolean hasRequiredFeatures(XmlCategoryType xmlCategoryType) {
        ConnectionIdentifier connectionIdentifier = DefaultConnectionIdentifier.createIdentifier((Connection)this.getConnection());
        for (String string : xmlCategoryType.getRequiredFeatures()) {
            if (XmlObjectFactory.hasRequiredFeature(connectionIdentifier, string)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasRequiredFeature(ConnectionIdentifier connectionIdentifier, String string) {
        boolean bl = (string = string.trim()).startsWith("!");
        if (bl) {
            string = string.substring(1);
        }
        return string.length() == 0 || bl ^ DatabaseFeatureRegistry.isFeatureEnabled((ConnectionIdentifier)connectionIdentifier, (String)string);
    }

    @Override
    public DBSchemasInstance getSchemasInstance(DBCatalogInstance dBCatalogInstance) {
        QueryFactory queryFactory = this.getQueryFactory();
        DBSchemas dBSchemas = queryFactory.getSchemas();
        XmlSchemasInstance xmlSchemasInstance = new XmlSchemasInstance(this, (XmlSchemasImpl)dBSchemas, dBCatalogInstance);
        if (dBCatalogInstance == null) {
            this.updateWithInitialContext(xmlSchemasInstance);
        } else {
            this.updateFromParent(xmlSchemasInstance, dBCatalogInstance);
        }
        xmlSchemasInstance.setProperty("ConnectionType", this.getConnectionType());
        return xmlSchemasInstance;
    }

    @Override
    public DBSchemaInstance createSchemaInstance(String string) {
        QueryFactory queryFactory = this.getQueryFactory();
        DBSchemas dBSchemas = queryFactory.getSchemas();
        XmlSchemaInstance xmlSchemaInstance = new XmlSchemaInstance(this, (XmlSchemaImpl)(dBSchemas != null ? dBSchemas.getDBSchema() : null));
        xmlSchemaInstance.setProperty("SCHEMA", string);
        this.updateWithInitialContext(xmlSchemaInstance);
        xmlSchemaInstance.setProperty("ConnectionType", this.getConnectionType());
        return xmlSchemaInstance;
    }

    @Override
    public DBCatalogInstance createCatalogInstance(String string) {
        QueryFactory queryFactory = this.getQueryFactory();
        XmlCatalogsImpl xmlCatalogsImpl = (XmlCatalogsImpl)queryFactory.getCatalogs();
        XmlCatalogInstance xmlCatalogInstance = new XmlCatalogInstance(this, (XmlCatalogImpl)xmlCatalogsImpl.getDBSchema());
        xmlCatalogInstance.setProperty("CATALOG", string);
        this.updateWithInitialContext(xmlCatalogInstance);
        xmlCatalogInstance.setProperty("ConnectionType", this.getConnectionType());
        return xmlCatalogInstance;
    }

    @Override
    public DBCatalogsInstance getCatalogsInstance() {
        QueryFactory queryFactory = this.getQueryFactory();
        Catalogs catalogs = queryFactory.getCatalogs();
        XmlCatalogsInstance xmlCatalogsInstance = new XmlCatalogsInstance(this, (XmlCatalogsImpl)catalogs);
        this.updateWithInitialContext(xmlCatalogsInstance);
        xmlCatalogsInstance.setProperty("ConnectionType", this.getConnectionType());
        return xmlCatalogsInstance;
    }

    @Override
    public DatabaseObject getObjectDescriptor(String string) {
        ObjectType objectType = this.getObjectType(string);
        return objectType != null ? objectType.getNode() : null;
    }

    private void updateWithInitialContext(DBItemInstance dBItemInstance) {
        Map<String, Object> map = this.getConnectionInfo().getInitialContext();
        if (map != null) {
            this.updateProperties(dBItemInstance, map);
        }
    }

    @Override
    public ObjectCategory getParentCategoryForType(String string) {
        QueryFactory queryFactory = this.getQueryFactory();
        return queryFactory.getCategoryForType(string);
    }

    @Override
    public ObjectCategory getParentCategoryForCategory(String string) {
        QueryFactory queryFactory = this.getQueryFactory();
        return queryFactory.getCategoryForCategory(string);
    }

    private void updateProperties(DBItemInstance dBItemInstance, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            dBItemInstance.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private void updateFromParent(DBItemInstance dBItemInstance, DBItemInstance dBItemInstance2) {
        for (String string : dBItemInstance2.getPropertyKeys()) {
            dBItemInstance.setProperty(string, dBItemInstance2.getProperty(string));
        }
    }

    private static class DummyFolderInstance
    extends AbstractItemInstance
    implements DBFolderInstance {
        private String m_type;

        private DummyFolderInstance(ObjectFactory objectFactory, DatabaseFolder databaseFolder, String string) {
            super(objectFactory);
            this.setDescriptor(databaseFolder);
            this.m_type = string;
        }

        public List<DBObjectInstance> getChildren(String[] stringArray, boolean bl) {
            return Collections.emptyList();
        }

        @Override
        public String getType() {
            return this.m_type;
        }

        public List<DBChildInstance> listChildren() {
            return this.listChildren(null);
        }

        public List<DBChildInstance> listChildren(QueryProgressListener queryProgressListener) {
            return Collections.emptyList();
        }

        @Override
        public boolean promptForFilter() {
            return false;
        }

        @Override
        public boolean isFiltered() {
            return false;
        }

        @Override
        public void clearFilter() {
        }

        @Override
        public boolean canHaveFilter() {
            return false;
        }

        @Override
        public boolean canLoadChildren() {
            return true;
        }
    }
}

