/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.plsql.structure.ArboriPanel;
import oracle.javatools.icons.OracleIcons;

public class ArboriToolbar
extends JToolBar {
    ArboriPanel context;

    public ArboriToolbar(ArboriPanel arboriPanel) {
        this.context = arboriPanel;
        JButton jButton = new JButton(OracleIcons.getIcon((String)"run.png"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArboriToolbar.this.run();
            }
        });
        this.add(jButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() {
        try {
            Program.debug = false;
            String string = this.context.code.getText();
            SqlProgram sqlProgram = new SqlProgram(string);
            Map map = sqlProgram.run(this.context.context.parser.text);
            LinkedList linkedList = sqlProgram.querySequence();
            String string2 = (String)linkedList.getLast();
            final MaterializedPredicate materializedPredicate = (MaterializedPredicate)map.get(string2);
            final ParseNode[][] parseNodeArray = new ParseNode[materializedPredicate.cardinality()][materializedPredicate.arity()];
            int n = -1;
            for (Tuple tuple : materializedPredicate.getTuples()) {
                ++n;
                for (int i = 0; i < materializedPredicate.arity(); ++i) {
                    ParseNode parseNode;
                    parseNodeArray[n][i] = parseNode = materializedPredicate.getAttribute(tuple, materializedPredicate.getAttribute(i));
                }
            }
            this.context.tbl.setModel(new DefaultTableModel(){

                @Override
                public int getRowCount() {
                    return materializedPredicate.cardinality();
                }

                @Override
                public int getColumnCount() {
                    return materializedPredicate.arity();
                }

                @Override
                public String getColumnName(int n) {
                    return materializedPredicate.getAttribute(n);
                }

                @Override
                public Class<?> getColumnClass(int n) {
                    return ParseNode.class;
                }

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }

                @Override
                public Object getValueAt(int n, int n2) {
                    return parseNodeArray[n][n2];
                }
            });
        }
        catch (SyntaxError syntaxError) {
            this.context.tbl.setModel(new DefaultTableModel(){

                @Override
                public int getRowCount() {
                    return 1;
                }

                @Override
                public int getColumnCount() {
                    return 1;
                }

                @Override
                public String getColumnName(int n) {
                    return "Arbori syntax error";
                }

                @Override
                public Class<?> getColumnClass(int n) {
                    return String.class;
                }

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }

                @Override
                public Object getValueAt(int n, int n2) {
                    return syntaxError.getMessage();
                }
            });
        }
        catch (AssertionError assertionError) {
            this.context.tbl.setModel(new DefaultTableModel(){

                @Override
                public int getRowCount() {
                    return 1;
                }

                @Override
                public int getColumnCount() {
                    return 1;
                }

                @Override
                public String getColumnName(int n) {
                    return "AssertionError";
                }

                @Override
                public Class<?> getColumnClass(int n) {
                    return String.class;
                }

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }

                @Override
                public Object getValueAt(int n, int n2) {
                    return ((Throwable)((Object)assertionError)).getMessage();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

