/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.Replacements;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.IdentifiersDb;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.refactor.Messages;
import oracle.dbtools.raptor.refactor.UndoableRefactoring;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public class Inliner
extends UndoableRefactoring {
    static final String path = "/oracle/dbtools/raptor/refactor/";
    static IProgram program = null;

    public Inliner(Context context) {
        super(context);
    }

    @Override
    protected Replacements runProgram(int n) {
        return this.runProgram(n, this.text, this.src, this.p, true);
    }

    Replacements runProgram(int n, String string, List<LexerToken> list, BasicEditorPane basicEditorPane, boolean bl) {
        long l = System.currentTimeMillis();
        try {
            Object object;
            TextBuffer textBuffer2;
            int n2;
            int n3;
            Object object2;
            Tuple tuple32;
            Parsed parsed = new Parsed(string, list, (Earley)SqlEarley.getInstance(), "sql_statement");
            if (program == null) {
                program = new IProgram();
                Program.debug = false;
            }
            Inliner.program.offset = LexerToken.scanner2parserOffset(list, (int)n);
            LexerToken lexerToken = list.get(Inliner.program.offset);
            if (basicEditorPane != null) {
                int n4;
                int n5 = basicEditorPane.getLineFromOffset(n);
                if (n5 < (n4 = basicEditorPane.getLineFromOffset(lexerToken.begin))) {
                    --Inliner.program.offset;
                }
                lexerToken = list.get(Inliner.program.offset);
                n4 = basicEditorPane.getLineFromOffset(lexerToken.begin);
                if (n5 < n4) {
                    --Inliner.program.offset;
                }
            }
            String string2 = lexerToken.content;
            Map map = null;
            try {
                map = program.eval(parsed);
            }
            catch (AssertionError assertionError) {
                if (((Throwable)((Object)assertionError)).getMessage().contains("syntactically invalid")) {
                    String string3 = Messages.getString("SyntaxErrorMsg");
                    SyntaxError syntaxError = parsed.getSyntaxError();
                    if (syntaxError != null) {
                        string3 = syntaxError.getDetailedMessage();
                    }
                    MessageDialog.information(null, (Object)string3, (String)Messages.getString("ErrorTitle"), null);
                }
                System.out.println("Refactoring aborted due to " + ((Throwable)((Object)assertionError)).getMessage());
                return null;
            }
            ParseNode parseNode = null;
            ParseNode parseNode2 = null;
            boolean bl2 = false;
            MaterializedPredicate materializedPredicate = (MaterializedPredicate)map.get("\"prm val\"");
            MaterializedPredicate materializedPredicate2 = (MaterializedPredicate)map.get("\"prm decl\"");
            MaterializedPredicate materializedPredicate3 = (MaterializedPredicate)map.get("\"all calls\"");
            if (materializedPredicate3.cardinality() == 0) {
                MaterializedPredicate materializedPredicate4 = (MaterializedPredicate)map.get("\"proc@offset\"");
                Iterator iterator2 = materializedPredicate4.getTuples().iterator();
                if (iterator2.hasNext()) {
                    Tuple tuple2 = (Tuple)iterator2.next();
                    ParseNode parseNode3 = materializedPredicate4.getAttribute(tuple2, "id");
                    string2 = parseNode3.content(list);
                }
                iterator2 = Messages.getString("NoCalls") + " " + string2;
                MessageDialog.information(null, (Object)iterator2, (String)Messages.getString("ErrorTitle"), null);
                return null;
            }
            int n6 = materializedPredicate2.cardinality();
            TreeMap treeMap = new TreeMap();
            MaterializedPredicate materializedPredicate5 = (MaterializedPredicate)map.get("\"all calls+fml\"");
            for (Tuple tuple32 : materializedPredicate3.getTuples()) {
                ParseNode parseNode4 = materializedPredicate3.getAttribute(tuple32, "call");
                string2 = parseNode4.content(list);
                parseNode = materializedPredicate3.getAttribute(tuple32, "body");
                bl2 = materializedPredicate3.getAttribute(tuple32, "f").contains(SqlEarley.getInstance().getSymbol("'FUNCTION'"));
                if (bl2) {
                    MessageDialog.information(null, (Object)Messages.getString("CantInlineFunction"), (String)Messages.getString("ErrorTitle"), null);
                    return null;
                }
                if (parseNode.from <= parseNode4.from && parseNode4.to <= parseNode.to) {
                    MessageDialog.information(null, (Object)Messages.getString("RecursiveInvocationMsg"), (String)Messages.getString("ErrorTitle"), null);
                    return null;
                }
                if (parseNode4.from <= Inliner.program.offset && Inliner.program.offset <= parseNode4.to) {
                    parseNode2 = parseNode4;
                }
                TreeMap<Object, ParseNode> treeMap2 = new TreeMap<Object, ParseNode>();
                ParseNode parseNode5 = null;
                for (Tuple tuple4 : materializedPredicate5.getTuples()) {
                    object2 = materializedPredicate5.getAttribute(tuple4, "call");
                    if (parseNode4.from != ((ParseNode)object2).from || parseNode4.to != ((ParseNode)object2).to) continue;
                    parseNode5 = materializedPredicate5.getAttribute(tuple4, "paren_expr_list");
                    break;
                }
                if (parseNode5 != null) {
                    for (Tuple tuple4 : materializedPredicate.getTuples()) {
                        object2 = materializedPredicate.getAttribute(tuple4, "arg");
                        if (parseNode5.from > ((ParseNode)object2).from || ((ParseNode)object2).to > parseNode5.to) continue;
                        ParseNode parseNode6 = materializedPredicate2.getAttribute(null, "prm_spec");
                        treeMap2.put(object2, parseNode6);
                    }
                }
                treeMap.put(parseNode4, treeMap2);
            }
            System.out.println("Inline time = " + (System.currentTimeMillis() - l));
            int n7 = treeMap.size();
            if (bl && !MessageDialog.confirm(null, (Object)MessageFormat.format(Messages.getString("Replace"), n7, list.get((int)(parseNode.from + 1)).content), (String)Messages.getString("InlineProcedure"), null)) {
                return null;
            }
            tuple32 = new Replacements(string);
            int n8 = list.get((int)parseNode.from).begin;
            int n9 = string.substring(0, n8).lastIndexOf(10) + 1;
            if (n9 < 0) {
                n9 = 0;
            }
            if ((n3 = (n2 = list.get((int)(parseNode.to - 1)).end) + string.substring(n2).indexOf(10) + 1) < 0) {
                n3 = n2;
            }
            if (this.notPublic(string2)) {
                tuple32.put(n9, n3, "");
            } else if (this.notUsedOutsideBody(string2)) {
                boolean bl3 = false;
                object2 = this.getPkgNode();
                if (object2 != null) {
                    for (Member iterator3 : ((PlSqlNode)object2).parseMembers()) {
                        if (!iterator3.name.equals(string2)) continue;
                        textBuffer2 = object2.tryAcquireTextBuffer();
                        try {
                            textBuffer2.beginEdit();
                            object = ((PlSqlNode)object2).getParser().src;
                            textBuffer2.remove(object.get((int)iterator3.from).begin, object.get((int)iterator3.to).begin - ((LexerToken)object.get((int)iterator3.from)).begin);
                            textBuffer2.endEdit();
                            bl3 = true;
                        }
                        catch (Exception exception) {
                            System.err.println("Failed to delete member from package declaration");
                        }
                        break;
                    }
                }
                if (bl3) {
                    tuple32.put(n9, n3, "");
                }
            }
            int n10 = n8 - n9;
            object2 = new StringBuffer();
            for (int i = 0; i < n10; ++i) {
                ((StringBuffer)object2).append(' ');
            }
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = parseNode.children().iterator();
            while (iterator.hasNext() && !(textBuffer2 = (ParseNode)iterator.next()).contains(IdentifiersDb.instance.decl_id)) {
                if (textBuffer2.contains(IdentifiersDb.instance.subprg_spec) || textBuffer2.contains(SqlEarley.getInstance().getSymbol("'IS'")) || textBuffer2.contains(SqlEarley.getInstance().getSymbol("'AS'"))) continue;
                if (stringBuilder.length() == 0) {
                    stringBuilder.append(Inliner.padFromNL2Pos(list.get((int)textBuffer2.from).begin, string));
                }
                stringBuilder.append(string.substring(list.get((int)textBuffer2.from).begin, list.get((int)textBuffer2.to).begin));
            }
            stringBuilder.append(";");
            for (TextBuffer textBuffer2 : treeMap.keySet()) {
                int n4;
                object = (Map)treeMap.get(textBuffer2);
                String string3 = object2 + "declare\n" + stringBuilder.toString();
                for (ParseNode parseNode3 : object.keySet()) {
                    ParseNode parseNode4 = (ParseNode)object.get(parseNode3);
                    String string4 = list.get((int)parseNode4.from).content;
                    String string5 = list.get((int)parseNode3.from).content;
                    string3 = string3.replace(string4, string5);
                }
                ParseNode parseNode5 = textBuffer2.parent();
                if (!parseNode5.contains(SqlEarley.getInstance().getSymbol("stmt"))) {
                    parseNode5 = parseNode5.parent();
                }
                if ((n4 = string.substring(0, n8 = list.get((int)parseNode5.from).begin).lastIndexOf(10) + 1) < 0) {
                    n4 = 0;
                }
                tuple32.put(n4, list.get((int)(parseNode5.to - 1)).end, Inliner.indentLines(n8 - n4 - n10, string3));
            }
            return tuple32;
        }
        catch (Exception exception) {
            System.err.println("Exception caught during inline: ");
            exception.printStackTrace();
            return null;
        }
    }

    private boolean notPublic(String string) {
        if (this.plsNode == null) {
            return true;
        }
        PlSqlNode plSqlNode = this.getPkgNode();
        if (plSqlNode == null) {
            return true;
        }
        for (Member member : plSqlNode.parseMembers()) {
            if (!member.name.equals(string)) continue;
            return false;
        }
        return true;
    }

    private boolean notUsedOutsideBody(String string) {
        if (this.plsNode == null) {
            return true;
        }
        String string2 = this.plsNode.getConnectionName();
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(string2, true);
        }
        catch (DBException dBException) {
            return true;
        }
        String string3 = DBUtil.getInstance((Connection)connection).executeReturnOneCol("select * from sys.all_identifiers where rownum <= 5 \nand name ='" + string + "'  and usage ='CALL' and object_name != '" + this.plsNode.getObjectName() + "' --and owner ='SCOTT';");
        return string3 == null;
    }

    public static String indentLines(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().intern();
            stringBuffer2.append(string2);
            if (!"\n".equals(string2)) continue;
            stringBuffer2.append(stringBuffer);
        }
        return stringBuffer2.toString();
    }

    private static String padFromNL2Pos(int n, String string) {
        int n2 = string.substring(0, n).lastIndexOf(10) + 1;
        if (n2 < 0) {
            n2 = 0;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n - n2; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private PlSqlNode getPkgNode() {
        URL uRL = this.plsNode.getURL();
        String string = DBURLFormatHelper.getBaseType(uRL);
        URL uRL2 = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL), "", DBURLFormatHelper.getSchema(uRL), string.substring(0, string.indexOf(32))), DBURLFormatHelper.getName(uRL));
        return PlSqlNode.find(uRL2);
    }

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile(Inliner.class, (String)"testInline.sql");
        Parsed parsed = new Parsed(string, (Earley)SqlEarley.getInstance(), "sql_statements");
        parsed.getRoot().printTree();
        int n = parsed.getInput().indexOf("--^");
        Replacements replacements = new Inliner(null).runProgram(n, parsed.getInput(), parsed.getSrc(), null, true);
        if (replacements == null) {
            return;
        }
        System.out.println(replacements.toString());
    }

    static class IProgram
    extends SqlProgram {
        int offset = -1;

        public IProgram() throws IOException {
            super(Service.readFile(Inliner.class, (String)"/oracle/dbtools/raptor/refactor/inline.prg"));
        }
    }
}

