/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.List;
import oracle.dbtools.app.Obfuscator;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.dbtools.raptor.refactor.CaseConverter;
import oracle.dbtools.raptor.refactor.Inliner;
import oracle.dbtools.raptor.refactor.Messages;
import oracle.dbtools.raptor.refactor.ProcedureExtractor;
import oracle.dbtools.raptor.refactor.RefactorMenu;
import oracle.dbtools.raptor.refactor.Renamer;
import oracle.dbtools.raptor.refactor.Surrounder;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Node;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;

public class RefactorController
implements Controller {
    private ProcedureExtractor procExtractor = null;
    private Surrounder surrounder = null;

    private boolean submitCommand(Command command) {
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        try {
            if (commandProcessor.invoke(command) == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (RefactorMenu._cmdULI == n) {
            CaseConverter.convert(context);
            return true;
        }
        if (RefactorMenu._cmdEP == n) {
            if (this.procExtractor == null) {
                this.procExtractor = new ProcedureExtractor();
            }
            this.procExtractor.extract(context);
            return true;
        }
        if (RefactorMenu._cmdRN == n) {
            return this.submitCommand(new Renamer(context));
        }
        if (RefactorMenu._cmdOB == n) {
            this.obfuscate(context);
            return true;
        }
        if (RefactorMenu._cmdINL == n) {
            return this.submitCommand(new Inliner(context));
        }
        if (RefactorMenu.cmdFOR == n || RefactorMenu.cmdWHILE == n || RefactorMenu.cmdBLOCK == n || RefactorMenu.cmdIF == n) {
            if (this.surrounder == null) {
                this.surrounder = new Surrounder();
            }
            this.surrounder.surround(context, n);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    private boolean obfuscate(Context context) {
        Object object;
        String string = null;
        List<LexerToken> list = null;
        Node node = context.getNode();
        View view = context.getView();
        BasicEditorPane basicEditorPane = ((BasicEditorPaneContainer)view).getFocusedEditorPane();
        if (node instanceof PlSqlNode) {
            object = (PlSqlNode)node;
            list = ((PlSqlNode)object).getParser().src;
            string = ((PlSqlNode)object).getParser().text;
            if (!this.save((PlSqlNode)object)) {
                return false;
            }
        } else if (view instanceof BasicEditorPaneContainer && view instanceof EquippedWithParser) {
            object = ((EquippedWithParser)view).getParser();
            list = ((BackgroundParser)object).src;
            string = ((BackgroundParser)object).text;
        }
        object = new Obfuscator(null);
        String string2 = null;
        try {
            string2 = object.transform(string, list, null);
        }
        catch (SyntaxError syntaxError) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)syntaxError.getMessage(), (String)syntaxError.getTitle(), null);
        }
        if (string2 == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)"output == null", null, null);
            return false;
        }
        basicEditorPane.setSelectionStart(0);
        basicEditorPane.setSelectionEnd(string.length());
        basicEditorPane.replaceSelection(string2);
        return true;
    }

    private boolean save(PlSqlNode plSqlNode) {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.clearChooseableURLFilters();
        String string = Messages.getString("PlsSrcFile");
        String string2 = Messages.getString("SaveNonOfuscatedCode");
        WildcardURLFilter wildcardURLFilter = new WildcardURLFilter("*.pls", false, string);
        uRLFileChooser.addChooseableURLFilter((URLFilter)wildcardURLFilter);
        wildcardURLFilter = new WildcardURLFilter("*.plb", false, string);
        uRLFileChooser.addChooseableURLFilter((URLFilter)wildcardURLFilter);
        uRLFileChooser.setFileNameURL(plSqlNode.getObjectName());
        int n = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow(), string2);
        if (n != 0) {
            return false;
        }
        URL uRL = uRLFileChooser.getSelectedURL();
        String string3 = uRL.getPath();
        if (string3.lastIndexOf(46) <= string3.lastIndexOf(File.separator)) {
            string3 = string3 + ".pls";
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            String string4 = IdeUtil.getIdeEncoding();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, string4);
            outputStreamWriter.write(plSqlNode.getParser().text);
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)Messages.getString("FailedToSave"), null);
            return false;
        }
        return true;
    }
}

