/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.service.impl;

import java.awt.Component;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public abstract class AbstractService {
    protected void runTask(final String string, final Consumer<Connection> consumer) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(CommonArb.getString("SERVICE_CONNECTING"), false, IRaptorTaskRunMode.MODAL_OPTIONAL){

            protected Void doWork() throws TaskException {
                try {
                    Connection connection = Connections.getInstance().getConnection(string);
                    if (connection != null) {
                        try {
                            consumer.accept(connection);
                        }
                        catch (RuntimeException runtimeException) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "unable to perform action", runtimeException);
                        }
                    } else {
                        SwingUtilities.invokeLater(() -> MessageDialog.error((Component)Ide.getMainWindow(), (Object)CommonArb.format("SERVICE_CONNECTION_DOESNT_EXIST", Connections.getDisplayName(string)), (String)CommonArb.getString("SERVICE_ERROR"), null));
                    }
                }
                catch (DBException dBException) {
                    SwingUtilities.invokeLater(() -> MessageDialog.error((Component)Ide.getMainWindow(), (Object)CommonArb.format("SERVICE_UNABLE_TO_CONNECT", Connections.getDisplayName(string), dBException.getLocalizedMessage()), (String)CommonArb.getString("SERVICE_ERROR"), null));
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getUserName(Connection connection) {
        String string = null;
        if (Connections.getInstance().lock(connection)) {
            try {
                try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT USER FROM DUAL");){
                    ResultSet resultSet = preparedStatement.executeQuery();
                    resultSet.next();
                    string = resultSet.getString("USER");
                }
                catch (SQLException sQLException) {
                    string = null;
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return string;
    }
}

