/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2.layouts;

import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import oracle.ide.palette2.layouts.PaletteLayout;
import oracle.ideimpl.palette2.PaletteGroupUI;
import oracle.ideimpl.palette2.PaletteItemUI;
import oracle.ideimpl.palette2.PaletteSectionUI;

public class ListLayout
extends PaletteLayout<MigLayout> {
    private static final String LAYOUT_CONSTRAINTS = "flowy, fillx";
    private static final String CELL_CONSTRAINTS = "fill, align leading";
    private static final String ROW_CONSTRAINTS = "[]5[]";
    private static final String SEPARATOR_CONSTRAINTS = "growx, height 18";
    private static final String ITEM_CONSTRAINTS = "growx";

    public ListLayout() {
        super(new MigLayout(LAYOUT_CONSTRAINTS, CELL_CONSTRAINTS, ROW_CONSTRAINTS));
    }

    @Override
    public void configurePaletteItemUI(PaletteItemUI itemUI) {
        String name = itemUI.getItemName();
        String pageName = itemUI.getPageName();
        String groupName = itemUI.getGroupName();
        if (pageName != null && pageName.length() > 0) {
            String appendText = String.format(" (%s.%s)", String.valueOf(pageName), String.valueOf(groupName));
            name = name + appendText;
        }
        JLabel label = itemUI.getGUI();
        label.setHorizontalAlignment(10);
        label.setVerticalAlignment(0);
        label.setHorizontalTextPosition(11);
        label.setVerticalTextPosition(0);
        label.setPreferredSize(null);
        label.setText(name);
    }

    @Override
    public void configurePaletteSectionUI(PaletteSectionUI sectionUI) {
    }

    @Override
    public void layoutContainer(Container parent) {
        if (!(parent instanceof JComponent)) {
            return;
        }
        PaletteGroupUI groupUI = this.getGroupUI((JComponent)parent);
        List<PaletteSectionUI> sectionUIs = groupUI.getAllPaletteSectionUIs();
        for (PaletteSectionUI sectionUI : sectionUIs) {
            Component separator = sectionUI.getSeparator();
            if (null != separator) {
                ((MigLayout)this.impl).setComponentConstraints(separator, (Object)SEPARATOR_CONSTRAINTS);
            }
            List<PaletteItemUI> itemUIs = sectionUI.getPaletteItems();
            for (PaletteItemUI itemUI : itemUIs) {
                ((MigLayout)this.impl).setComponentConstraints((Component)itemUI, (Object)ITEM_CONSTRAINTS);
            }
        }
        super.layoutContainer(parent);
    }

    @Override
    protected PaletteItemUI getItemAbove(PaletteItemUI current) {
        return super.getItemBefore(current);
    }

    @Override
    protected PaletteItemUI getItemBelow(PaletteItemUI current) {
        return super.getItemAfter(current);
    }

    @Override
    protected PaletteItemUI getItemBefore(PaletteItemUI current) {
        return current;
    }

    @Override
    protected PaletteItemUI getItemAfter(PaletteItemUI current) {
        return current;
    }
}

