/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.cache;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFilter;
import oracle.javatools.util.Maps;

public class WeakNodeCache {
    private static final Map<URL, Node> _cache = new Maps.WeakHashMap();

    private WeakNodeCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Node find(URL url) {
        Map<URL, Node> map = _cache;
        synchronized (map) {
            return _cache.get(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Map<URL, Node> find(URL[] urls) {
        Map<URL, Node> map = _cache;
        synchronized (map) {
            HashMap<URL, Node> found = new HashMap<URL, Node>(urls.length);
            for (URL url : urls) {
                Node node = _cache.get(url);
                if (node == null) continue;
                found.put(url, node);
            }
            return found;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Map<URL, Node> find(URLFilter filter) {
        Map<URL, Node> map = _cache;
        synchronized (map) {
            HashMap<URL, Node> found = new HashMap<URL, Node>();
            for (Map.Entry<URL, Node> entry : _cache.entrySet()) {
                if (!filter.accept(entry.getKey())) continue;
                found.put(entry.getKey(), entry.getValue());
            }
            return found;
        }
    }

    static {
        NodeFactory.attach((Observer)new Observer(){

            public final void update(Object observed, UpdateMessage change) {
                if (change.getMessageID() == NodeFactory.NODE_CACHED) {
                    Node node = (Node)observed;
                    _cache.put(node.getURL(), node);
                }
                if (change.getMessageID() == NodeFactory.NODE_UNCACHED) {
                    _cache.remove(((Node)observed).getURL());
                }
            }
        }, Node.class);
        Iterator itr = NodeFactory.getCachedNodes();
        while (itr.hasNext()) {
            Node node = (Node)itr.next();
            _cache.put(node.getURL(), node);
        }
    }
}

