/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Observable;

public class VCSRecentCommentsModel
extends Observable {
    private static final int DEFAULT_MAXIMUM_SIZE = 50;
    private final LinkedList<Object> _comments = new LinkedList();
    private int _maximumSize = 50;

    public void setMaximumSize(int maximumSize) {
        if (maximumSize <= 0) {
            throw new IllegalArgumentException();
        }
        this._maximumSize = maximumSize;
        this.trimToSize();
    }

    public void addComment(Object comment) {
        if (comment.equals("")) {
            return;
        }
        int i = this.indexOfIgnoreCase(comment);
        if (i >= 0) {
            this._comments.remove(i);
        }
        this._comments.addFirst(comment);
        this.trimToSize();
        this.setChanged();
        this.notifyObservers();
    }

    public void clearComments() {
        this._comments.clear();
        this.setChanged();
        this.notifyObservers();
    }

    public Object[] getMatches(Object s) {
        ArrayList<Object> matches = new ArrayList<Object>();
        for (int i = 0; i < this._comments.size(); ++i) {
            if (!this._comments.get(i).toString().toLowerCase().startsWith(s.toString().toLowerCase())) continue;
            matches.add(this._comments.get(i));
        }
        return matches.toArray();
    }

    public Object[] toArray() {
        return this._comments.toArray();
    }

    private int indexOfIgnoreCase(Object comment) {
        for (int i = 0; i < this._comments.size(); ++i) {
            if (!this._comments.get(i).toString().equalsIgnoreCase(comment.toString())) continue;
            return i;
        }
        return -1;
    }

    private void trimToSize() {
        while (this._comments.size() > this._maximumSize) {
            this._comments.removeLast();
        }
    }
}

