/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs;

import java.awt.Component;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Observable;
import javax.ide.extension.Extension;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.vcs.VCS;
import oracle.ide.vcs.VCSRegistry;
import oracle.ideimpl.vcscore.VersioningBaseMenuUpdater;
import oracle.ideimpl.vcscore.VersioningMenuBuilder;
import oracle.ideimpl.vcscore.VersioningRegistrations;
import oracle.ideri.util.Product;
import oracle.jdeveloper.history.CustomFilterSubstitution;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.vcs.share.ShareApplicationCommand;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSHistoryProvider;
import oracle.jdeveloper.vcs.util.VCSMenuUtils;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryCommand;

public final class SystemMenuUpdater
extends VersioningBaseMenuUpdater {
    private static final float SYSTEM_MENU_SECTION = 2.0f;
    private static final String VCS_NAVIGATOR = "VCS.VersioningNavigator";

    protected boolean isArgumentHandled(Object arg) {
        return arg instanceof VCSExtension;
    }

    protected final void runClosure(Observable o, Object arg, JMenu versioningMenu) {
        JMenuItem menuItem;
        VCSExtension argExtension = (VCSExtension)arg;
        this.installVersionHistory(argExtension);
        Ide.getMenubar().resolveMnemonicsForMenuItemsInSection(versioningMenu, 2.0f);
        VersioningMenuBuilder menuBuilder = new VersioningMenuBuilder(versioningMenu, ((Object)((Object)this)).getClass().getName());
        menuBuilder.purge();
        JMenu submenu = MenuManager.getJMenu((String)("VERSIONING_MENU." + argExtension.getId()));
        if (submenu != null) {
            for (Component component : submenu.getMenuComponents()) {
                if (component instanceof JComponent) continue;
                FeedbackManager.reportException((Throwable)new IllegalStateException("Menu components must be JComponent derivative for extension: " + argExtension.getId()));
            }
            submenu.setMnemonic(submenu.getText().charAt(0));
            VCSHistoryProvider historyProvider = argExtension.getHistoryProvider();
            if (historyProvider != null) {
                if (historyProvider.getVersionHistoryAction() != null) {
                    IdeAction versionHistoryAction = historyProvider.getVersionHistoryAction();
                    VCSMenuUtils.installVersionHistoryMenuItem(submenu, versionHistoryAction != null ? versionHistoryAction.getCommandId() : VersionHistoryCommand.VERSION_HISTORY_CMD_ID);
                }
                if (historyProvider.getVersionTreeAction() != null) {
                    IdeAction versionTreeAction = historyProvider.getVersionTreeAction();
                    VCSMenuUtils.installVersionHistoryMenuItem(submenu, versionTreeAction.getCommandId());
                }
            }
            if (this.countVersioningExtensions() == 1 && !this.isALMPresent()) {
                float section = 2.01f;
                Float currentMenuWeight = null;
                for (Component c : submenu.getMenuComponents()) {
                    JComponent jc = (JComponent)c;
                    Float menuWeight = (Float)jc.getClientProperty("menu-section-id");
                    if (menuWeight != null && !menuWeight.equals(currentMenuWeight)) {
                        currentMenuWeight = menuWeight;
                        section += 0.01f;
                    }
                    jc.putClientProperty("fixedMnemonic", true);
                    menuBuilder.add(jc, section);
                }
            } else {
                ArrayList<JMenu> itemsToAdd = new ArrayList<JMenu>();
                for (String string : VCSRegistry.keySet()) {
                    JMenu currentSubmenu;
                    VCS vcs = VCSRegistry.lookup((String)string);
                    if (!(vcs instanceof VCSExtension) || (currentSubmenu = MenuManager.getJMenu((String)("VERSIONING_MENU." + string))) == null) continue;
                    itemsToAdd.add(currentSubmenu);
                }
                Collections.sort(itemsToAdd, new Comparator<JMenuItem>(){

                    @Override
                    public int compare(JMenuItem o1, JMenuItem o2) {
                        return Collator.getInstance().compare(o1.getText(), o2.getText());
                    }
                });
                for (JMenuItem jMenuItem : itemsToAdd) {
                    menuBuilder.add((JComponent)jMenuItem, 2.0f);
                }
            }
        }
        if (submenu != null) {
            menuItem = Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((String)VCS_NAVIGATOR));
            menuBuilder.add((JComponent)menuItem, 1.9f);
        }
        if (!Product.isRaptor()) {
            menuItem = Ide.getMenubar().createMenuItem((ToggleAction)ShareApplicationCommand.getShareApplicationAction());
            menuBuilder.add((JComponent)menuItem, 1.9f);
        }
        VCSControlCache.getInstance().fireControlStateChanged(null);
    }

    private final void installVersionHistory(VCSExtension extension) {
        VCSHistoryProvider historyProvider = extension.getHistoryProvider();
        HistoryManager historyManager = HistoryManager.getHistoryManager();
        if (historyProvider == null || historyManager == null) {
            return;
        }
        if (historyProvider.getHistoryProvider() != null) {
            historyManager.registerProvider(historyProvider.getHistoryProvider());
        }
        if (historyProvider.getVersioningUserSubstitution() != null) {
            historyManager.getCustomFilterManager().registerSubstitution((CustomFilterSubstitution)historyProvider.getVersioningUserSubstitution());
        }
    }

    private final int countVersioningExtensions() {
        return VersioningRegistrations.getInstance().getRegistrations().size();
    }

    private boolean isALMPresent() {
        Extension ext = ExtensionRegistry.getExtensionRegistry().findExtension("oracle.teamproductivitycenter");
        return ext != null;
    }
}

