/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.Identifiable;
import javax.ide.util.MetaClass;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.net.URLFilter;
import oracle.jdevimpl.vcs.generic.profile.FileSystemHelperInfo;
import oracle.jdevimpl.vcs.generic.profile.InitializableProfileObject;
import oracle.jdevimpl.vcs.generic.profile.ProfileInfo;
import oracle.jdevimpl.vcs.generic.profile.StatusesInfo;

public final class FileSystemInfo
implements InitializableProfileObject {
    private ProfileInfo _profileInfo;
    private Map _urlFilters;
    private Collection<MetaClass<URLFilter>> _urlFilterClasses;
    private final List _fsHelpers = new ArrayList(5);
    private StatusesInfo _statuses;

    public void addUrlFilter(MetaClass<URLFilter> dc) {
        if (this._urlFilterClasses == null) {
            this._urlFilterClasses = new ArrayList<MetaClass<URLFilter>>();
        }
        this._urlFilterClasses.add(dc);
    }

    private final void addUrlFilter(URLFilter filter) {
        if (filter instanceof Identifiable) {
            String id = ((Identifiable)filter).getID();
            if (id == null || id.equals("")) {
                id = "oracle.jdeveloper.vcs.filters.url.DEFAULT";
            }
            this._urlFilters.put(id, filter);
        } else {
            this._urlFilters.put(filter.getClass().getName(), filter);
        }
    }

    public URLFilter getURLFilter(String id) {
        if (this._urlFilters == null) {
            this._urlFilters = new HashMap(5);
            if (this._urlFilterClasses != null) {
                try {
                    for (MetaClass<URLFilter> dc : this._urlFilterClasses) {
                        this.addUrlFilter((URLFilter)dc.newInstance());
                    }
                }
                catch (Exception e) {
                    FeedbackManager.reportException((Throwable)e);
                }
                this._urlFilterClasses = null;
            }
        }
        return (URLFilter)this._urlFilters.get(id);
    }

    public void addHelper(Object o) {
        if (!(o instanceof FileSystemHelperInfo)) {
            throw new IllegalArgumentException();
        }
        this._fsHelpers.add(o);
    }

    public List getHelpers() {
        return Collections.unmodifiableList(this._fsHelpers);
    }

    public void setStatuses(Object o) {
        if (!(o instanceof StatusesInfo)) {
            throw new IllegalArgumentException();
        }
        this._statuses = (StatusesInfo)o;
    }

    public StatusesInfo getStatuses() {
        return this._statuses;
    }

    @Override
    public void preInitialize(Object parent) {
        if (!(parent instanceof ProfileInfo)) {
            throw new IllegalArgumentException();
        }
        this._profileInfo = (ProfileInfo)parent;
    }

    @Override
    public void postInitialize() {
    }

    protected ProfileInfo getProfileInfo() {
        return this._profileInfo;
    }
}

