/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util.browser;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.ideimpl.editor.DeclarativeEditorAddin;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdevimpl.vcs.ClassUtil;
import oracle.jdevimpl.vcs.util.browser.AbstractFlatEditorDecorator;
import oracle.jdevimpl.vcs.util.browser.Browsable;
import oracle.jdevimpl.vcs.util.browser.BrowsableCache;
import oracle.jdevimpl.vcs.util.browser.DefaultBrowsable;

public class BrowsableViewer
extends AbstractFlatEditorDecorator {
    private URL _tempUrl;
    private ContextMenuListener _contextMenuListener;
    private static final URLFilter[] EXCLUDED_NODE_FILTERS = new URLFilter[0];
    private static final URLFilter[] DEFAULT_TEXT_VIEWER_FILTERS = new URLFilter[]{VCSURLFilters.createFileSuffixFilter(".jws"), VCSURLFilters.createFileSuffixFilter(".jpr")};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Node createDelegateNode() {
        Node contextNode = this.getContext().getNode();
        if (!(contextNode instanceof Browsable)) {
            return null;
        }
        URL url = contextNode.getURL();
        if (BrowsableViewer.isExcludedNodeURL(url)) {
            return null;
        }
        this._tempUrl = null;
        OutputStream outputStream = null;
        try {
            Browsable browsable = (Browsable)contextNode;
            URL tempUrl = URLFileSystem.createTempFile((String)"jdevbrowser", (String)browsable.getFileSuffix(), null);
            outputStream = URLFileSystem.openOutputStream((URL)tempUrl);
            browsable.writeFileContents(outputStream);
            this._tempUrl = tempUrl;
            outputStream.close();
            outputStream = null;
            BrowsableCache.cache(this._tempUrl, browsable);
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
            this.setOpenException(contextNode, ioe);
            Node node = null;
            return node;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this._tempUrl == null) {
            return null;
        }
        URLFileSystem.setReadOnly((URL)this._tempUrl, (boolean)true);
        new File(URLFileSystem.getPlatformPathName((URL)this._tempUrl)).deleteOnExit();
        try {
            Node node = NodeFactory.findOrCreate((URL)this._tempUrl);
            node.getAttributes().unset(ElementAttributes.BUILDABLE);
            node.getAttributes().unset(ElementAttributes.DEPLOYABLE);
            node.getAttributes().set(ElementAttributes.NON_HISTORIED);
            return node;
        }
        catch (InstantiationException ie) {
            Assert.printStackTrace((Throwable)ie);
            this.setOpenException(contextNode, ie);
            return null;
        }
        catch (IllegalAccessException iae) {
            Assert.printStackTrace((Throwable)iae);
            this.setOpenException(contextNode, iae);
            return null;
        }
    }

    private final void setOpenException(Node contextNode, Exception e) {
        if (contextNode instanceof DefaultBrowsable) {
            ((DefaultBrowsable)contextNode).setOpenException(e);
        }
    }

    @Override
    protected Editor createDelegateEditor(Node delegateNode) {
        if (BrowsableViewer.isDefaultTextViewerURL(delegateNode.getURL())) {
            return null;
        }
        EditorAddin editorAddin = EditorManager.getEditorManager().getBestEditorAddin(delegateNode);
        if (editorAddin == null) {
            return null;
        }
        if (editorAddin.isMultifile()) {
            return null;
        }
        try {
            if (editorAddin instanceof DeclarativeEditorAddin) {
                return (Editor)((DeclarativeEditorAddin)editorAddin).getEditorMetaClass().newInstance();
            }
            return (Editor)ClassUtil.newInstance(editorAddin.getEditorClass());
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            return null;
        }
    }

    @Override
    protected void initializeDelegateEditor(Editor delegateEditor) {
        CodeEditor codeEditor;
        Component o;
        ContextMenu contextMenu = delegateEditor.getContextMenu();
        if (contextMenu != null) {
            this._contextMenuListener = new ContextMenuListener(){

                public void menuWillShow(ContextMenu popup) {
                    if (BrowsableViewer.this._tempUrl == null) {
                        return;
                    }
                    Node node = popup.getContext().getNode();
                    if (node == null) {
                        return;
                    }
                    URL nodeUrl = node.getURL();
                    if (nodeUrl == null || !nodeUrl.equals(BrowsableViewer.this._tempUrl)) {
                        return;
                    }
                    popup.removeAll();
                    float section = 1.0f;
                    popup.add(this.createMenuItem(18), section);
                    popup.add(this.createMenuItem(22), section);
                    popup.add(this.createMenuItem(23), section += 1.0f);
                }

                public void menuWillHide(ContextMenu popup) {
                }

                public boolean handleDefaultAction(Context context) {
                    return false;
                }

                private Component createMenuItem(int actionId) {
                    return Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)actionId));
                }
            };
            contextMenu.addContextMenuListener(this._contextMenuListener);
        }
        if (delegateEditor instanceof CodeEditor && (o = (codeEditor = (CodeEditor)delegateEditor).getGUI()) instanceof BasicEditorPane) {
            BasicEditorPane editorPane = (BasicEditorPane)o;
            editorPane.putBooleanProperty("caret-enable-blink", false);
            editorPane.putBooleanProperty("brace-matching-auto", false);
        }
    }

    @Override
    protected void releaseDelegateData(Editor delegateEditor) {
        ContextMenu contextMenu = delegateEditor.getContextMenu();
        if (contextMenu != null && this._contextMenuListener != null) {
            contextMenu.removeContextMenuListener(this._contextMenuListener);
        }
        if (this._tempUrl != null) {
            URLFileSystem.delete((URL)this._tempUrl);
            this._tempUrl = null;
            BrowsableCache.uncache(this._tempUrl);
        }
    }

    private static final boolean isExcludedNodeURL(URL url) {
        return VCSURLFilters.createChainedORFilter(EXCLUDED_NODE_FILTERS).accept(url);
    }

    public static final boolean isDefaultTextViewerURL(URL url) {
        return VCSURLFilters.createChainedORFilter(DEFAULT_TEXT_VIEWER_FILTERS).accept(url);
    }
}

