/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.logging.Level;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.diff.AbstractPropertyFilter;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyManager;

public class DefaultPropertyValueFilter
extends AbstractPropertyFilter {
    private final PropertyManager m_source;
    private final PropertyManager m_target;
    private final boolean m_singleProvider;

    public DefaultPropertyValueFilter(DBObjectProvider pro) {
        this.m_target = this.m_source = pro.getPropertyManager();
        this.m_singleProvider = true;
    }

    public DefaultPropertyValueFilter(DBObjectProvider source, DBObjectProvider target) {
        this(source.getPropertyManager(), target.getPropertyManager());
    }

    public DefaultPropertyValueFilter(PropertyManager source, PropertyManager target) {
        this.m_source = source;
        this.m_target = target;
        this.m_singleProvider = false;
    }

    @Override
    protected boolean isFilteredProperty(Difference diff, DBObject original, DBObject updated, String prop) {
        Object newValue;
        boolean retval = false;
        Object origValue = diff.getOriginalObject();
        if (origValue == null ^ (newValue = diff.getUpdatedObject()) == null) {
            DBObject targetObj;
            DBObject sourceObj = updated == null ? original : updated;
            DBObject dBObject = targetObj = original == null ? updated : original;
            if (newValue == null) {
                retval = this.isNullValueFiltered(sourceObj, this.m_source, prop, targetObj, origValue, this.m_target);
            } else if (origValue == null) {
                retval = this.isNullValueFiltered(targetObj, this.m_target, prop, sourceObj, newValue, this.m_source);
            }
        }
        return retval;
    }

    private boolean isNullValueFiltered(DBObject objWithNull, PropertyManager propMgrWithNull, String prop, DBObject otherObj, Object otherValue, PropertyManager otherPropMgr) {
        Nullable.NullBehaviour otherBehaviour;
        Nullable.NullBehaviour behaviour = this.getNullBehaviour((DBObject)(this.m_singleProvider ? objWithNull : null), objWithNull, prop, propMgrWithNull);
        boolean retval = Nullable.NullBehaviour.NULL_MEANS_NOT_SPECIFIED_AND_IGNORE.equals((Object)behaviour) ? true : (Nullable.NullBehaviour.NULL_MEANS_NOT_SPECIFIED.equals((Object)behaviour) ? (this.m_singleProvider ? true : (otherBehaviour = this.getNullBehaviour(otherObj, otherObj, prop, otherPropMgr)) != Nullable.NullBehaviour.NULL_MEANS_NOT_SPECIFIED) : this.isImplicitDefaultValue(otherValue, otherObj, prop, otherPropMgr));
        return retval;
    }

    private Nullable.NullBehaviour getNullBehaviour(DBObject originalObject, DBObject updatedObject, String property, PropertyManager propMgr) {
        Nullable.NullBehaviour retval = Nullable.NullBehaviour.NOT_NULLABLE;
        if (updatedObject instanceof DataTypeUsage) {
            String[] properties;
            if (!(propMgr instanceof DDLGenerator) && (properties = Property.getProperties((String)property)).length == 2 && "attributeValues".equals(properties[0])) {
                String dtaName = properties[1];
                try {
                    DataTypeAttribute dta;
                    DataType dt = DataTypeHelper.getDataType((DataTypeUsage)((DataTypeUsage)updatedObject), (boolean)false);
                    if (dt != null && (dta = dt.getDataTypeAttribute(dtaName)) != null && !dta.isMandatory()) {
                        retval = Nullable.NullBehaviour.NULL_MEANS_NOT_SPECIFIED;
                    }
                }
                catch (DBException dbe) {
                    DBLog.getLogger((Object)this).log(Level.WARNING, "Couldn't resolve datatype: " + dbe.getMessage());
                }
            }
        } else if (updatedObject != null) {
            retval = propMgr.getNullBehaviour(originalObject, updatedObject, property);
        }
        return retval;
    }

    private boolean isImplicitDefaultValue(Object value, DBObject obj, String property, PropertyManager propMgr) {
        Object def = propMgr.getImplicitDefaultValue(obj, property);
        return def != null && def.equals(value);
    }

    @Override
    protected boolean ignoreProperty(DBObject obj, String redactedProp) {
        return false;
    }
}

